/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pointer to the dataset that underlies this table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableReference implements SdkPojo, Serializable, ToCopyableBuilder<TableReference.Builder, TableReference> {
    private static final SdkField<GlueTableReference> GLUE_FIELD = SdkField
            .<GlueTableReference> builder(MarshallingType.SDK_POJO).memberName("glue").getter(getter(TableReference::glue))
            .setter(setter(Builder::glue)).constructor(GlueTableReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glue").build()).build();

    private static final SdkField<SnowflakeTableReference> SNOWFLAKE_FIELD = SdkField
            .<SnowflakeTableReference> builder(MarshallingType.SDK_POJO).memberName("snowflake")
            .getter(getter(TableReference::snowflake)).setter(setter(Builder::snowflake))
            .constructor(SnowflakeTableReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snowflake").build()).build();

    private static final SdkField<AthenaTableReference> ATHENA_FIELD = SdkField
            .<AthenaTableReference> builder(MarshallingType.SDK_POJO).memberName("athena").getter(getter(TableReference::athena))
            .setter(setter(Builder::athena)).constructor(AthenaTableReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athena").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_FIELD, SNOWFLAKE_FIELD,
            ATHENA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GlueTableReference glue;

    private final SnowflakeTableReference snowflake;

    private final AthenaTableReference athena;

    private final Type type;

    private TableReference(BuilderImpl builder) {
        this.glue = builder.glue;
        this.snowflake = builder.snowflake;
        this.athena = builder.athena;
        this.type = builder.type;
    }

    /**
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @return If present, a reference to the Glue table referred to by this table reference.
     */
    public final GlueTableReference glue() {
        return glue;
    }

    /**
     * <p>
     * If present, a reference to the Snowflake table referred to by this table reference.
     * </p>
     * 
     * @return If present, a reference to the Snowflake table referred to by this table reference.
     */
    public final SnowflakeTableReference snowflake() {
        return snowflake;
    }

    /**
     * <p>
     * If present, a reference to the Athena table referred to by this table reference.
     * </p>
     * 
     * @return If present, a reference to the Athena table referred to by this table reference.
     */
    public final AthenaTableReference athena() {
        return athena;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glue());
        hashCode = 31 * hashCode + Objects.hashCode(snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(athena());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableReference)) {
            return false;
        }
        TableReference other = (TableReference) obj;
        return Objects.equals(glue(), other.glue()) && Objects.equals(snowflake(), other.snowflake())
                && Objects.equals(athena(), other.athena());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableReference").add("Glue", glue()).add("Snowflake", snowflake()).add("Athena", athena())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glue":
            return Optional.ofNullable(clazz.cast(glue()));
        case "snowflake":
            return Optional.ofNullable(clazz.cast(snowflake()));
        case "athena":
            return Optional.ofNullable(clazz.cast(athena()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #glue()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @param glue
     *        If present, a reference to the Glue table referred to by this table reference.
     */
    public static TableReference fromGlue(GlueTableReference glue) {
        return builder().glue(glue).build();
    }

    /**
     * Create an instance of this class with {@link #glue()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Glue table referred to by this table reference.
     * </p>
     * 
     * @param glue
     *        If present, a reference to the Glue table referred to by this table reference.
     */
    public static TableReference fromGlue(Consumer<GlueTableReference.Builder> glue) {
        GlueTableReference.Builder builder = GlueTableReference.builder();
        glue.accept(builder);
        return fromGlue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #snowflake()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Snowflake table referred to by this table reference.
     * </p>
     * 
     * @param snowflake
     *        If present, a reference to the Snowflake table referred to by this table reference.
     */
    public static TableReference fromSnowflake(SnowflakeTableReference snowflake) {
        return builder().snowflake(snowflake).build();
    }

    /**
     * Create an instance of this class with {@link #snowflake()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Snowflake table referred to by this table reference.
     * </p>
     * 
     * @param snowflake
     *        If present, a reference to the Snowflake table referred to by this table reference.
     */
    public static TableReference fromSnowflake(Consumer<SnowflakeTableReference.Builder> snowflake) {
        SnowflakeTableReference.Builder builder = SnowflakeTableReference.builder();
        snowflake.accept(builder);
        return fromSnowflake(builder.build());
    }

    /**
     * Create an instance of this class with {@link #athena()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Athena table referred to by this table reference.
     * </p>
     * 
     * @param athena
     *        If present, a reference to the Athena table referred to by this table reference.
     */
    public static TableReference fromAthena(AthenaTableReference athena) {
        return builder().athena(athena).build();
    }

    /**
     * Create an instance of this class with {@link #athena()} initialized to the given value.
     *
     * <p>
     * If present, a reference to the Athena table referred to by this table reference.
     * </p>
     * 
     * @param athena
     *        If present, a reference to the Athena table referred to by this table reference.
     */
    public static TableReference fromAthena(Consumer<AthenaTableReference.Builder> athena) {
        AthenaTableReference.Builder builder = AthenaTableReference.builder();
        athena.accept(builder);
        return fromAthena(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glue", GLUE_FIELD);
        map.put("snowflake", SNOWFLAKE_FIELD);
        map.put("athena", ATHENA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableReference, T> g) {
        return obj -> g.apply((TableReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableReference> {
        /**
         * <p>
         * If present, a reference to the Glue table referred to by this table reference.
         * </p>
         * 
         * @param glue
         *        If present, a reference to the Glue table referred to by this table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glue(GlueTableReference glue);

        /**
         * <p>
         * If present, a reference to the Glue table referred to by this table reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueTableReference.Builder} avoiding the
         * need to create one manually via {@link GlueTableReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueTableReference.Builder#build()} is called immediately and its
         * result is passed to {@link #glue(GlueTableReference)}.
         * 
         * @param glue
         *        a consumer that will call methods on {@link GlueTableReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glue(GlueTableReference)
         */
        default Builder glue(Consumer<GlueTableReference.Builder> glue) {
            return glue(GlueTableReference.builder().applyMutation(glue).build());
        }

        /**
         * <p>
         * If present, a reference to the Snowflake table referred to by this table reference.
         * </p>
         * 
         * @param snowflake
         *        If present, a reference to the Snowflake table referred to by this table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflake(SnowflakeTableReference snowflake);

        /**
         * <p>
         * If present, a reference to the Snowflake table referred to by this table reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeTableReference.Builder} avoiding
         * the need to create one manually via {@link SnowflakeTableReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeTableReference.Builder#build()} is called immediately
         * and its result is passed to {@link #snowflake(SnowflakeTableReference)}.
         * 
         * @param snowflake
         *        a consumer that will call methods on {@link SnowflakeTableReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflake(SnowflakeTableReference)
         */
        default Builder snowflake(Consumer<SnowflakeTableReference.Builder> snowflake) {
            return snowflake(SnowflakeTableReference.builder().applyMutation(snowflake).build());
        }

        /**
         * <p>
         * If present, a reference to the Athena table referred to by this table reference.
         * </p>
         * 
         * @param athena
         *        If present, a reference to the Athena table referred to by this table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athena(AthenaTableReference athena);

        /**
         * <p>
         * If present, a reference to the Athena table referred to by this table reference.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaTableReference.Builder} avoiding
         * the need to create one manually via {@link AthenaTableReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaTableReference.Builder#build()} is called immediately and
         * its result is passed to {@link #athena(AthenaTableReference)}.
         * 
         * @param athena
         *        a consumer that will call methods on {@link AthenaTableReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athena(AthenaTableReference)
         */
        default Builder athena(Consumer<AthenaTableReference.Builder> athena) {
            return athena(AthenaTableReference.builder().applyMutation(athena).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueTableReference glue;

        private SnowflakeTableReference snowflake;

        private AthenaTableReference athena;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableReference model) {
            glue(model.glue);
            snowflake(model.snowflake);
            athena(model.athena);
        }

        public final GlueTableReference.Builder getGlue() {
            return glue != null ? glue.toBuilder() : null;
        }

        public final void setGlue(GlueTableReference.BuilderImpl glue) {
            Object oldValue = this.glue;
            this.glue = glue != null ? glue.build() : null;
            handleUnionValueChange(Type.GLUE, oldValue, this.glue);
        }

        @Override
        public final Builder glue(GlueTableReference glue) {
            Object oldValue = this.glue;
            this.glue = glue;
            handleUnionValueChange(Type.GLUE, oldValue, this.glue);
            return this;
        }

        public final SnowflakeTableReference.Builder getSnowflake() {
            return snowflake != null ? snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeTableReference.BuilderImpl snowflake) {
            Object oldValue = this.snowflake;
            this.snowflake = snowflake != null ? snowflake.build() : null;
            handleUnionValueChange(Type.SNOWFLAKE, oldValue, this.snowflake);
        }

        @Override
        public final Builder snowflake(SnowflakeTableReference snowflake) {
            Object oldValue = this.snowflake;
            this.snowflake = snowflake;
            handleUnionValueChange(Type.SNOWFLAKE, oldValue, this.snowflake);
            return this;
        }

        public final AthenaTableReference.Builder getAthena() {
            return athena != null ? athena.toBuilder() : null;
        }

        public final void setAthena(AthenaTableReference.BuilderImpl athena) {
            Object oldValue = this.athena;
            this.athena = athena != null ? athena.build() : null;
            handleUnionValueChange(Type.ATHENA, oldValue, this.athena);
        }

        @Override
        public final Builder athena(AthenaTableReference athena) {
            Object oldValue = this.athena;
            this.athena = athena;
            handleUnionValueChange(Type.ATHENA, oldValue, this.athena);
            return this;
        }

        @Override
        public TableReference build() {
            return new TableReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableReference#type()
     */
    public enum Type {
        GLUE,

        SNOWFLAKE,

        ATHENA,

        UNKNOWN_TO_SDK_VERSION
    }
}
