/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfiguredTableAssociationAnalysisRuleRequest extends CleanRoomsRequest
        implements
        ToCopyableBuilder<UpdateConfiguredTableAssociationAnalysisRuleRequest.Builder, UpdateConfiguredTableAssociationAnalysisRuleRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier")
            .getter(getter(UpdateConfiguredTableAssociationAnalysisRuleRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredTableAssociationIdentifier")
            .getter(getter(UpdateConfiguredTableAssociationAnalysisRuleRequest::configuredTableAssociationIdentifier))
            .setter(setter(Builder::configuredTableAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableAssociationIdentifier")
                    .build()).build();

    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisRuleType")
            .getter(getter(UpdateConfiguredTableAssociationAnalysisRuleRequest::analysisRuleTypeAsString))
            .setter(setter(Builder::analysisRuleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisRuleType").build()).build();

    private static final SdkField<ConfiguredTableAssociationAnalysisRulePolicy> ANALYSIS_RULE_POLICY_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRulePolicy> builder(MarshallingType.SDK_POJO).memberName("analysisRulePolicy")
            .getter(getter(UpdateConfiguredTableAssociationAnalysisRuleRequest::analysisRulePolicy))
            .setter(setter(Builder::analysisRulePolicy)).constructor(ConfiguredTableAssociationAnalysisRulePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRulePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD, ANALYSIS_RULE_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String configuredTableAssociationIdentifier;

    private final String analysisRuleType;

    private final ConfiguredTableAssociationAnalysisRulePolicy analysisRulePolicy;

    private UpdateConfiguredTableAssociationAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredTableAssociationIdentifier = builder.configuredTableAssociationIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
        this.analysisRulePolicy = builder.analysisRulePolicy;
    }

    /**
     * <p>
     * A unique identifier for the membership that the configured table association belongs to. Currently accepts the
     * membership ID.
     * </p>
     * 
     * @return A unique identifier for the membership that the configured table association belongs to. Currently
     *         accepts the membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The identifier for the configured table association to update.
     * </p>
     * 
     * @return The identifier for the configured table association to update.
     */
    public final String configuredTableAssociationIdentifier() {
        return configuredTableAssociationIdentifier;
    }

    /**
     * <p>
     * The analysis rule type that you want to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAssociationAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type that you want to update.
     * @see ConfiguredTableAssociationAnalysisRuleType
     */
    public final ConfiguredTableAssociationAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAssociationAnalysisRuleType.fromValue(analysisRuleType);
    }

    /**
     * <p>
     * The analysis rule type that you want to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAssociationAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type that you want to update.
     * @see ConfiguredTableAssociationAnalysisRuleType
     */
    public final String analysisRuleTypeAsString() {
        return analysisRuleType;
    }

    /**
     * <p>
     * The updated analysis rule policy for the conﬁgured table association.
     * </p>
     * 
     * @return The updated analysis rule policy for the conﬁgured table association.
     */
    public final ConfiguredTableAssociationAnalysisRulePolicy analysisRulePolicy() {
        return analysisRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(analysisRuleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisRulePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredTableAssociationAnalysisRuleRequest)) {
            return false;
        }
        UpdateConfiguredTableAssociationAnalysisRuleRequest other = (UpdateConfiguredTableAssociationAnalysisRuleRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(configuredTableAssociationIdentifier(), other.configuredTableAssociationIdentifier())
                && Objects.equals(analysisRuleTypeAsString(), other.analysisRuleTypeAsString())
                && Objects.equals(analysisRulePolicy(), other.analysisRulePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfiguredTableAssociationAnalysisRuleRequest")
                .add("MembershipIdentifier", membershipIdentifier())
                .add("ConfiguredTableAssociationIdentifier", configuredTableAssociationIdentifier())
                .add("AnalysisRuleType", analysisRuleTypeAsString()).add("AnalysisRulePolicy", analysisRulePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "configuredTableAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(configuredTableAssociationIdentifier()));
        case "analysisRuleType":
            return Optional.ofNullable(clazz.cast(analysisRuleTypeAsString()));
        case "analysisRulePolicy":
            return Optional.ofNullable(clazz.cast(analysisRulePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("configuredTableAssociationIdentifier", CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("analysisRuleType", ANALYSIS_RULE_TYPE_FIELD);
        map.put("analysisRulePolicy", ANALYSIS_RULE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredTableAssociationAnalysisRuleRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredTableAssociationAnalysisRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfiguredTableAssociationAnalysisRuleRequest> {
        /**
         * <p>
         * A unique identifier for the membership that the configured table association belongs to. Currently accepts
         * the membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for the membership that the configured table association belongs to. Currently
         *        accepts the membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The identifier for the configured table association to update.
         * </p>
         * 
         * @param configuredTableAssociationIdentifier
         *        The identifier for the configured table association to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier);

        /**
         * <p>
         * The analysis rule type that you want to update.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type that you want to update.
         * @see ConfiguredTableAssociationAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAssociationAnalysisRuleType
         */
        Builder analysisRuleType(String analysisRuleType);

        /**
         * <p>
         * The analysis rule type that you want to update.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type that you want to update.
         * @see ConfiguredTableAssociationAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAssociationAnalysisRuleType
         */
        Builder analysisRuleType(ConfiguredTableAssociationAnalysisRuleType analysisRuleType);

        /**
         * <p>
         * The updated analysis rule policy for the conﬁgured table association.
         * </p>
         * 
         * @param analysisRulePolicy
         *        The updated analysis rule policy for the conﬁgured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy analysisRulePolicy);

        /**
         * <p>
         * The updated analysis rule policy for the conﬁgured table association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAssociationAnalysisRulePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #analysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy)}.
         * 
         * @param analysisRulePolicy
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRulePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy)
         */
        default Builder analysisRulePolicy(Consumer<ConfiguredTableAssociationAnalysisRulePolicy.Builder> analysisRulePolicy) {
            return analysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy.builder().applyMutation(analysisRulePolicy)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String configuredTableAssociationIdentifier;

        private String analysisRuleType;

        private ConfiguredTableAssociationAnalysisRulePolicy analysisRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredTableAssociationAnalysisRuleRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            configuredTableAssociationIdentifier(model.configuredTableAssociationIdentifier);
            analysisRuleType(model.analysisRuleType);
            analysisRulePolicy(model.analysisRulePolicy);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredTableAssociationIdentifier() {
            return configuredTableAssociationIdentifier;
        }

        public final void setConfiguredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
        }

        @Override
        public final Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAssociationAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRulePolicy.Builder getAnalysisRulePolicy() {
            return analysisRulePolicy != null ? analysisRulePolicy.toBuilder() : null;
        }

        public final void setAnalysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy.BuilderImpl analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy != null ? analysisRulePolicy.build() : null;
        }

        @Override
        public final Builder analysisRulePolicy(ConfiguredTableAssociationAnalysisRulePolicy analysisRulePolicy) {
            this.analysisRulePolicy = analysisRulePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredTableAssociationAnalysisRuleRequest build() {
            return new UpdateConfiguredTableAssociationAnalysisRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
