/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfiguredTableAssociationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateConfiguredTableAssociationRequest.Builder, UpdateConfiguredTableAssociationRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredTableAssociationIdentifier")
            .getter(getter(UpdateConfiguredTableAssociationRequest::configuredTableAssociationIdentifier))
            .setter(setter(Builder::configuredTableAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableAssociationIdentifier")
                    .build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdateConfiguredTableAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateConfiguredTableAssociationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateConfiguredTableAssociationRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configuredTableAssociationIdentifier;

    private final String membershipIdentifier;

    private final String description;

    private final String roleArn;

    private UpdateConfiguredTableAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableAssociationIdentifier = builder.configuredTableAssociationIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The unique identifier for the configured table association to update. Currently accepts the configured table
     * association ID.
     * </p>
     * 
     * @return The unique identifier for the configured table association to update. Currently accepts the configured
     *         table association ID.
     */
    public final String configuredTableAssociationIdentifier() {
        return configuredTableAssociationIdentifier;
    }

    /**
     * <p>
     * The unique ID for the membership that the configured table association belongs to.
     * </p>
     * 
     * @return The unique ID for the membership that the configured table association belongs to.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A new description for the configured table association.
     * </p>
     * 
     * @return A new description for the configured table association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The service will assume this role to access catalog metadata and query the table.
     * </p>
     * 
     * @return The service will assume this role to access catalog metadata and query the table.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredTableAssociationRequest)) {
            return false;
        }
        UpdateConfiguredTableAssociationRequest other = (UpdateConfiguredTableAssociationRequest) obj;
        return Objects.equals(configuredTableAssociationIdentifier(), other.configuredTableAssociationIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfiguredTableAssociationRequest")
                .add("ConfiguredTableAssociationIdentifier", configuredTableAssociationIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).add("Description", description()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(configuredTableAssociationIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredTableAssociationIdentifier", CONFIGURED_TABLE_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredTableAssociationRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredTableAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfiguredTableAssociationRequest> {
        /**
         * <p>
         * The unique identifier for the configured table association to update. Currently accepts the configured table
         * association ID.
         * </p>
         * 
         * @param configuredTableAssociationIdentifier
         *        The unique identifier for the configured table association to update. Currently accepts the configured
         *        table association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier);

        /**
         * <p>
         * The unique ID for the membership that the configured table association belongs to.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique ID for the membership that the configured table association belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A new description for the configured table association.
         * </p>
         * 
         * @param description
         *        A new description for the configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The service will assume this role to access catalog metadata and query the table.
         * </p>
         * 
         * @param roleArn
         *        The service will assume this role to access catalog metadata and query the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String configuredTableAssociationIdentifier;

        private String membershipIdentifier;

        private String description;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredTableAssociationRequest model) {
            super(model);
            configuredTableAssociationIdentifier(model.configuredTableAssociationIdentifier);
            membershipIdentifier(model.membershipIdentifier);
            description(model.description);
            roleArn(model.roleArn);
        }

        public final String getConfiguredTableAssociationIdentifier() {
            return configuredTableAssociationIdentifier;
        }

        public final void setConfiguredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
        }

        @Override
        public final Builder configuredTableAssociationIdentifier(String configuredTableAssociationIdentifier) {
            this.configuredTableAssociationIdentifier = configuredTableAssociationIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredTableAssociationRequest build() {
            return new UpdateConfiguredTableAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
