/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProtectedQueryRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateProtectedQueryRequest.Builder, UpdateProtectedQueryRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdateProtectedQueryRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> PROTECTED_QUERY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protectedQueryIdentifier").getter(getter(UpdateProtectedQueryRequest::protectedQueryIdentifier))
            .setter(setter(Builder::protectedQueryIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("protectedQueryIdentifier").build())
            .build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStatus").getter(getter(UpdateProtectedQueryRequest::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            PROTECTED_QUERY_IDENTIFIER_FIELD, TARGET_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String protectedQueryIdentifier;

    private final String targetStatus;

    private UpdateProtectedQueryRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.protectedQueryIdentifier = builder.protectedQueryIdentifier;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The identifier for a member of a protected query instance.
     * </p>
     * 
     * @return The identifier for a member of a protected query instance.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The identifier for a protected query instance.
     * </p>
     * 
     * @return The identifier for a protected query instance.
     */
    public final String protectedQueryIdentifier() {
        return protectedQueryIdentifier;
    }

    /**
     * <p>
     * The target status of a query. Used to update the execution status of a currently running query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link TargetProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The target status of a query. Used to update the execution status of a currently running query.
     * @see TargetProtectedQueryStatus
     */
    public final TargetProtectedQueryStatus targetStatus() {
        return TargetProtectedQueryStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The target status of a query. Used to update the execution status of a currently running query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link TargetProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The target status of a query. Used to update the execution status of a currently running query.
     * @see TargetProtectedQueryStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(protectedQueryIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectedQueryRequest)) {
            return false;
        }
        UpdateProtectedQueryRequest other = (UpdateProtectedQueryRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(protectedQueryIdentifier(), other.protectedQueryIdentifier())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProtectedQueryRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("ProtectedQueryIdentifier", protectedQueryIdentifier()).add("TargetStatus", targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "protectedQueryIdentifier":
            return Optional.ofNullable(clazz.cast(protectedQueryIdentifier()));
        case "targetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("protectedQueryIdentifier", PROTECTED_QUERY_IDENTIFIER_FIELD);
        map.put("targetStatus", TARGET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProtectedQueryRequest, T> g) {
        return obj -> g.apply((UpdateProtectedQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProtectedQueryRequest> {
        /**
         * <p>
         * The identifier for a member of a protected query instance.
         * </p>
         * 
         * @param membershipIdentifier
         *        The identifier for a member of a protected query instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The identifier for a protected query instance.
         * </p>
         * 
         * @param protectedQueryIdentifier
         *        The identifier for a protected query instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedQueryIdentifier(String protectedQueryIdentifier);

        /**
         * <p>
         * The target status of a query. Used to update the execution status of a currently running query.
         * </p>
         * 
         * @param targetStatus
         *        The target status of a query. Used to update the execution status of a currently running query.
         * @see TargetProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetProtectedQueryStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The target status of a query. Used to update the execution status of a currently running query.
         * </p>
         * 
         * @param targetStatus
         *        The target status of a query. Used to update the execution status of a currently running query.
         * @see TargetProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetProtectedQueryStatus
         */
        Builder targetStatus(TargetProtectedQueryStatus targetStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String protectedQueryIdentifier;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProtectedQueryRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            protectedQueryIdentifier(model.protectedQueryIdentifier);
            targetStatus(model.targetStatus);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getProtectedQueryIdentifier() {
            return protectedQueryIdentifier;
        }

        public final void setProtectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
        }

        @Override
        public final Builder protectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(TargetProtectedQueryStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProtectedQueryRequest build() {
            return new UpdateProtectedQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
