/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummary;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProtectedQueriesResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListProtectedQueriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProtectedQueriesResponse.getter(ListProtectedQueriesResponse::nextToken)).setter(ListProtectedQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ProtectedQuerySummary>> PROTECTED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("protectedQueries").getter(ListProtectedQueriesResponse.getter(ListProtectedQueriesResponse::protectedQueries)).setter(ListProtectedQueriesResponse.setter(Builder::protectedQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectedQuerySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROTECTED_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProtectedQueriesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ProtectedQuerySummary> protectedQueries;

    private ListProtectedQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.protectedQueries = builder.protectedQueries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProtectedQueries() {
        return this.protectedQueries != null && !(this.protectedQueries instanceof SdkAutoConstructList);
    }

    public final List<ProtectedQuerySummary> protectedQueries() {
        return this.protectedQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectedQueries() ? this.protectedQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectedQueriesResponse)) {
            return false;
        }
        ListProtectedQueriesResponse other = (ListProtectedQueriesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProtectedQueries() == other.hasProtectedQueries() && Objects.equals(this.protectedQueries(), other.protectedQueries());
    }

    public final String toString() {
        return ToString.builder((String)"ListProtectedQueriesResponse").add("NextToken", (Object)this.nextToken()).add("ProtectedQueries", this.hasProtectedQueries() ? this.protectedQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "protectedQueries": {
                return Optional.ofNullable(clazz.cast(this.protectedQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("protectedQueries", PROTECTED_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectedQueriesResponse, T> g) {
        return obj -> g.apply((ListProtectedQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProtectedQuerySummary> protectedQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectedQueriesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.protectedQueries(model.protectedQueries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProtectedQuerySummary.Builder> getProtectedQueries() {
            List<ProtectedQuerySummary.Builder> result = ProtectedQuerySummaryListCopier.copyToBuilder(this.protectedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectedQueries(Collection<ProtectedQuerySummary.BuilderImpl> protectedQueries) {
            this.protectedQueries = ProtectedQuerySummaryListCopier.copyFromBuilder(protectedQueries);
        }

        @Override
        public final Builder protectedQueries(Collection<ProtectedQuerySummary> protectedQueries) {
            this.protectedQueries = ProtectedQuerySummaryListCopier.copy(protectedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedQueries(ProtectedQuerySummary ... protectedQueries) {
            this.protectedQueries(Arrays.asList(protectedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedQueries(Consumer<ProtectedQuerySummary.Builder> ... protectedQueries) {
            this.protectedQueries(Stream.of(protectedQueries).map(c -> (ProtectedQuerySummary)((ProtectedQuerySummary.Builder)ProtectedQuerySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProtectedQueriesResponse build() {
            return new ListProtectedQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProtectedQueriesResponse> {
        public Builder nextToken(String var1);

        public Builder protectedQueries(Collection<ProtectedQuerySummary> var1);

        public Builder protectedQueries(ProtectedQuerySummary ... var1);

        public Builder protectedQueries(Consumer<ProtectedQuerySummary.Builder> ... var1);
    }
}

