/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.IdNamespaceAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsResponse;

public class ListIdNamespaceAssociationsIterable
implements SdkIterable<ListIdNamespaceAssociationsResponse> {
    private final CleanRoomsClient client;
    private final ListIdNamespaceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIdNamespaceAssociationsIterable(CleanRoomsClient client, ListIdNamespaceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIdNamespaceAssociationsResponseFetcher();
    }

    public Iterator<ListIdNamespaceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IdNamespaceAssociationSummary> idNamespaceAssociationSummaries() {
        Function<ListIdNamespaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.idNamespaceAssociationSummaries() != null) {
                return response.idNamespaceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIdNamespaceAssociationsResponseFetcher
    implements SyncPageFetcher<ListIdNamespaceAssociationsResponse> {
        private ListIdNamespaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdNamespaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIdNamespaceAssociationsResponse nextPage(ListIdNamespaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListIdNamespaceAssociationsIterable.this.client.listIdNamespaceAssociations(ListIdNamespaceAssociationsIterable.this.firstRequest);
            }
            return ListIdNamespaceAssociationsIterable.this.client.listIdNamespaceAssociations((ListIdNamespaceAssociationsRequest)((Object)ListIdNamespaceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

