/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTableSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTableSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::id)).setter(ConfiguredTableSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::arn)).setter(ConfiguredTableSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::name)).setter(ConfiguredTableSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::createTime)).setter(ConfiguredTableSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::updateTime)).setter(ConfiguredTableSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRuleTypes").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::analysisRuleTypesAsStrings)).setter(ConfiguredTableSummary.setter(Builder::analysisRuleTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(ConfiguredTableSummary.getter(ConfiguredTableSummary::analysisMethodAsString)).setter(ConfiguredTableSummary.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTableSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final Instant createTime;
    private final Instant updateTime;
    private final List<String> analysisRuleTypes;
    private final String analysisMethod;

    private ConfiguredTableSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final List<ConfiguredTableAnalysisRuleType> analysisRuleTypes() {
        return ConfiguredTableAnalysisRuleTypeListCopier.copyStringToEnum(this.analysisRuleTypes);
    }

    public final boolean hasAnalysisRuleTypes() {
        return this.analysisRuleTypes != null && !(this.analysisRuleTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisRuleTypesAsStrings() {
        return this.analysisRuleTypes;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableSummary)) {
            return false;
        }
        ConfiguredTableSummary other = (ConfiguredTableSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && this.hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes() && Objects.equals(this.analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTableSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("AnalysisRuleTypes", this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null).add("AnalysisMethod", (Object)this.analysisMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "analysisRuleTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypesAsStrings()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableSummary, T> g) {
        return obj -> g.apply((ConfiguredTableSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private Instant createTime;
        private Instant updateTime;
        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();
        private String analysisMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.analysisRuleTypesWithStrings(model.analysisRuleTypes);
            this.analysisMethod(model.analysisMethod);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (this.analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String ... analysisRuleTypes) {
            this.analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType ... analysisRuleTypes) {
            this.analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public ConfiguredTableSummary build() {
            return new ConfiguredTableSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTableSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder analysisRuleTypesWithStrings(Collection<String> var1);

        public Builder analysisRuleTypesWithStrings(String ... var1);

        public Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> var1);

        public Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType ... var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);
    }
}

