/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AllowedColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleTypeListCopier;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethod;
import software.amazon.awssdk.services.cleanrooms.model.SelectedAnalysisMethodsCopier;
import software.amazon.awssdk.services.cleanrooms.model.TableReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTable> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ConfiguredTable.getter(ConfiguredTable::id)).setter(ConfiguredTable.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfiguredTable.getter(ConfiguredTable::arn)).setter(ConfiguredTable.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfiguredTable.getter(ConfiguredTable::name)).setter(ConfiguredTable.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConfiguredTable.getter(ConfiguredTable::description)).setter(ConfiguredTable.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TableReference> TABLE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tableReference").getter(ConfiguredTable.getter(ConfiguredTable::tableReference)).setter(ConfiguredTable.setter(Builder::tableReference)).constructor(TableReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableReference").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredTable.getter(ConfiguredTable::createTime)).setter(ConfiguredTable.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredTable.getter(ConfiguredTable::updateTime)).setter(ConfiguredTable.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRuleTypes").getter(ConfiguredTable.getter(ConfiguredTable::analysisRuleTypesAsStrings)).setter(ConfiguredTable.setter(Builder::analysisRuleTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisMethod").getter(ConfiguredTable.getter(ConfiguredTable::analysisMethodAsString)).setter(ConfiguredTable.setter(Builder::analysisMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()}).build();
    private static final SdkField<List<String>> ALLOWED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedColumns").getter(ConfiguredTable.getter(ConfiguredTable::allowedColumns)).setter(ConfiguredTable.setter(Builder::allowedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_ANALYSIS_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedAnalysisMethods").getter(ConfiguredTable.getter(ConfiguredTable::selectedAnalysisMethodsAsStrings)).setter(ConfiguredTable.setter(Builder::selectedAnalysisMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedAnalysisMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TABLE_REFERENCE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD, ALLOWED_COLUMNS_FIELD, SELECTED_ANALYSIS_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final TableReference tableReference;
    private final Instant createTime;
    private final Instant updateTime;
    private final List<String> analysisRuleTypes;
    private final String analysisMethod;
    private final List<String> allowedColumns;
    private final List<String> selectedAnalysisMethods;

    private ConfiguredTable(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.tableReference = builder.tableReference;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
        this.allowedColumns = builder.allowedColumns;
        this.selectedAnalysisMethods = builder.selectedAnalysisMethods;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TableReference tableReference() {
        return this.tableReference;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final List<ConfiguredTableAnalysisRuleType> analysisRuleTypes() {
        return ConfiguredTableAnalysisRuleTypeListCopier.copyStringToEnum(this.analysisRuleTypes);
    }

    public final boolean hasAnalysisRuleTypes() {
        return this.analysisRuleTypes != null && !(this.analysisRuleTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisRuleTypesAsStrings() {
        return this.analysisRuleTypes;
    }

    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(this.analysisMethod);
    }

    public final String analysisMethodAsString() {
        return this.analysisMethod;
    }

    public final boolean hasAllowedColumns() {
        return this.allowedColumns != null && !(this.allowedColumns instanceof SdkAutoConstructList);
    }

    public final List<String> allowedColumns() {
        return this.allowedColumns;
    }

    public final List<SelectedAnalysisMethod> selectedAnalysisMethods() {
        return SelectedAnalysisMethodsCopier.copyStringToEnum(this.selectedAnalysisMethods);
    }

    public final boolean hasSelectedAnalysisMethods() {
        return this.selectedAnalysisMethods != null && !(this.selectedAnalysisMethods instanceof SdkAutoConstructList);
    }

    public final List<String> selectedAnalysisMethodsAsStrings() {
        return this.selectedAnalysisMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedColumns() ? this.allowedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTable)) {
            return false;
        }
        ConfiguredTable other = (ConfiguredTable)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tableReference(), other.tableReference()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && this.hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes() && Objects.equals(this.analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings()) && Objects.equals(this.analysisMethodAsString(), other.analysisMethodAsString()) && this.hasAllowedColumns() == other.hasAllowedColumns() && Objects.equals(this.allowedColumns(), other.allowedColumns()) && this.hasSelectedAnalysisMethods() == other.hasSelectedAnalysisMethods() && Objects.equals(this.selectedAnalysisMethodsAsStrings(), other.selectedAnalysisMethodsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTable").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("TableReference", (Object)this.tableReference()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("AnalysisRuleTypes", this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null).add("AnalysisMethod", (Object)this.analysisMethodAsString()).add("AllowedColumns", this.hasAllowedColumns() ? this.allowedColumns() : null).add("SelectedAnalysisMethods", this.hasSelectedAnalysisMethods() ? this.selectedAnalysisMethodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tableReference": {
                return Optional.ofNullable(clazz.cast(this.tableReference()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "analysisRuleTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypesAsStrings()));
            }
            case "analysisMethod": {
                return Optional.ofNullable(clazz.cast(this.analysisMethodAsString()));
            }
            case "allowedColumns": {
                return Optional.ofNullable(clazz.cast(this.allowedColumns()));
            }
            case "selectedAnalysisMethods": {
                return Optional.ofNullable(clazz.cast(this.selectedAnalysisMethodsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tableReference", TABLE_REFERENCE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        map.put("allowedColumns", ALLOWED_COLUMNS_FIELD);
        map.put("selectedAnalysisMethods", SELECTED_ANALYSIS_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTable, T> g) {
        return obj -> g.apply((ConfiguredTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private TableReference tableReference;
        private Instant createTime;
        private Instant updateTime;
        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();
        private String analysisMethod;
        private List<String> allowedColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedAnalysisMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTable model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.tableReference(model.tableReference);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.analysisRuleTypesWithStrings(model.analysisRuleTypes);
            this.analysisMethod(model.analysisMethod);
            this.allowedColumns(model.allowedColumns);
            this.selectedAnalysisMethodsWithStrings(model.selectedAnalysisMethods);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TableReference.Builder getTableReference() {
            return this.tableReference != null ? this.tableReference.toBuilder() : null;
        }

        public final void setTableReference(TableReference.BuilderImpl tableReference) {
            this.tableReference = tableReference != null ? tableReference.build() : null;
        }

        @Override
        public final Builder tableReference(TableReference tableReference) {
            this.tableReference = tableReference;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (this.analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String ... analysisRuleTypes) {
            this.analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType ... analysisRuleTypes) {
            this.analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return this.analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final Collection<String> getAllowedColumns() {
            if (this.allowedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedColumns;
        }

        public final void setAllowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
        }

        @Override
        public final Builder allowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedColumns(String ... allowedColumns) {
            this.allowedColumns(Arrays.asList(allowedColumns));
            return this;
        }

        public final Collection<String> getSelectedAnalysisMethods() {
            if (this.selectedAnalysisMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedAnalysisMethods;
        }

        public final void setSelectedAnalysisMethods(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
        }

        @Override
        public final Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethodsWithStrings(String ... selectedAnalysisMethods) {
            this.selectedAnalysisMethodsWithStrings(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public final Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copyEnumToString(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethods(SelectedAnalysisMethod ... selectedAnalysisMethods) {
            this.selectedAnalysisMethods(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        public ConfiguredTable build() {
            return new ConfiguredTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTable> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tableReference(TableReference var1);

        default public Builder tableReference(Consumer<TableReference.Builder> tableReference) {
            return this.tableReference((TableReference)((TableReference.Builder)TableReference.builder().applyMutation(tableReference)).build());
        }

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder analysisRuleTypesWithStrings(Collection<String> var1);

        public Builder analysisRuleTypesWithStrings(String ... var1);

        public Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> var1);

        public Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType ... var1);

        public Builder analysisMethod(String var1);

        public Builder analysisMethod(AnalysisMethod var1);

        public Builder allowedColumns(Collection<String> var1);

        public Builder allowedColumns(String ... var1);

        public Builder selectedAnalysisMethodsWithStrings(Collection<String> var1);

        public Builder selectedAnalysisMethodsWithStrings(String ... var1);

        public Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> var1);

        public Builder selectedAnalysisMethods(SelectedAnalysisMethod ... var1);
    }
}

