/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRuleType;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAssociationAnalysisRuleTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTableAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTableAssociation> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::arn)).setter(ConfiguredTableAssociation.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::id)).setter(ConfiguredTableAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableId").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::configuredTableId)).setter(ConfiguredTableAssociation.setter(Builder::configuredTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableId").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableArn").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::configuredTableArn)).setter(ConfiguredTableAssociation.setter(Builder::configuredTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableArn").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::membershipId)).setter(ConfiguredTableAssociation.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::membershipArn)).setter(ConfiguredTableAssociation.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::roleArn)).setter(ConfiguredTableAssociation.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::name)).setter(ConfiguredTableAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::description)).setter(ConfiguredTableAssociation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisRuleTypes").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::analysisRuleTypesAsStrings)).setter(ConfiguredTableAssociation.setter(Builder::analysisRuleTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::createTime)).setter(ConfiguredTableAssociation.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredTableAssociation.getter(ConfiguredTableAssociation::updateTime)).setter(ConfiguredTableAssociation.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, CONFIGURED_TABLE_ID_FIELD, CONFIGURED_TABLE_ARN_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, ROLE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ANALYSIS_RULE_TYPES_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTableAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String configuredTableId;
    private final String configuredTableArn;
    private final String membershipId;
    private final String membershipArn;
    private final String roleArn;
    private final String name;
    private final String description;
    private final List<String> analysisRuleTypes;
    private final Instant createTime;
    private final Instant updateTime;

    private ConfiguredTableAssociation(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.configuredTableId = builder.configuredTableId;
        this.configuredTableArn = builder.configuredTableArn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.description = builder.description;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String configuredTableId() {
        return this.configuredTableId;
    }

    public final String configuredTableArn() {
        return this.configuredTableArn;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final List<ConfiguredTableAssociationAnalysisRuleType> analysisRuleTypes() {
        return ConfiguredTableAssociationAnalysisRuleTypeListCopier.copyStringToEnum(this.analysisRuleTypes);
    }

    public final boolean hasAnalysisRuleTypes() {
        return this.analysisRuleTypes != null && !(this.analysisRuleTypes instanceof SdkAutoConstructList);
    }

    public final List<String> analysisRuleTypesAsStrings() {
        return this.analysisRuleTypes;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociation)) {
            return false;
        }
        ConfiguredTableAssociation other = (ConfiguredTableAssociation)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.configuredTableId(), other.configuredTableId()) && Objects.equals(this.configuredTableArn(), other.configuredTableArn()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes() && Objects.equals(this.analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTableAssociation").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("ConfiguredTableId", (Object)this.configuredTableId()).add("ConfiguredTableArn", (Object)this.configuredTableArn()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("RoleArn", (Object)this.roleArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AnalysisRuleTypes", this.hasAnalysisRuleTypes() ? this.analysisRuleTypesAsStrings() : null).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "configuredTableId": {
                return Optional.ofNullable(clazz.cast(this.configuredTableId()));
            }
            case "configuredTableArn": {
                return Optional.ofNullable(clazz.cast(this.configuredTableArn()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "analysisRuleTypes": {
                return Optional.ofNullable(clazz.cast(this.analysisRuleTypesAsStrings()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("configuredTableId", CONFIGURED_TABLE_ID_FIELD);
        map.put("configuredTableArn", CONFIGURED_TABLE_ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociation, T> g) {
        return obj -> g.apply((ConfiguredTableAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String configuredTableId;
        private String configuredTableArn;
        private String membershipId;
        private String membershipArn;
        private String roleArn;
        private String name;
        private String description;
        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociation model) {
            this.arn(model.arn);
            this.id(model.id);
            this.configuredTableId(model.configuredTableId);
            this.configuredTableArn(model.configuredTableArn);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.roleArn(model.roleArn);
            this.name(model.name);
            this.description(model.description);
            this.analysisRuleTypesWithStrings(model.analysisRuleTypes);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getConfiguredTableId() {
            return this.configuredTableId;
        }

        public final void setConfiguredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
        }

        @Override
        public final Builder configuredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
            return this;
        }

        public final String getConfiguredTableArn() {
            return this.configuredTableArn;
        }

        public final void setConfiguredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
        }

        @Override
        public final Builder configuredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (this.analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String ... analysisRuleTypes) {
            this.analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<ConfiguredTableAssociationAnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAssociationAnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType ... analysisRuleTypes) {
            this.analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ConfiguredTableAssociation build() {
            return new ConfiguredTableAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTableAssociation> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder configuredTableId(String var1);

        public Builder configuredTableArn(String var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder roleArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder analysisRuleTypesWithStrings(Collection<String> var1);

        public Builder analysisRuleTypesWithStrings(String ... var1);

        public Builder analysisRuleTypes(Collection<ConfiguredTableAssociationAnalysisRuleType> var1);

        public Builder analysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType ... var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

