/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hash
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hash> {
    private static final SdkField<String> SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sha256").getter(Hash.getter(Hash::sha256)).setter(Hash.setter(Builder::sha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHA256_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Hash.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sha256;

    private Hash(BuilderImpl builder) {
        this.sha256 = builder.sha256;
    }

    public final String sha256() {
        return this.sha256;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sha256());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash other = (Hash)obj;
        return Objects.equals(this.sha256(), other.sha256());
    }

    public final String toString() {
        return ToString.builder((String)"Hash").add("Sha256", (Object)this.sha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sha256": {
                return Optional.ofNullable(clazz.cast(this.sha256()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sha256", SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hash, T> g) {
        return obj -> g.apply((Hash)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sha256;

        private BuilderImpl() {
        }

        private BuilderImpl(Hash model) {
            this.sha256(model.sha256);
        }

        public final String getSha256() {
            return this.sha256;
        }

        public final void setSha256(String sha256) {
            this.sha256 = sha256;
        }

        @Override
        public final Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }

        public Hash build() {
            return new Hash(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hash> {
        public Builder sha256(String var1);
    }
}

