/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.IdNamespaceAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdNamespaceAssociationsResponse;

public class ListIdNamespaceAssociationsPublisher
implements SdkPublisher<ListIdNamespaceAssociationsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListIdNamespaceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdNamespaceAssociationsPublisher(CleanRoomsAsyncClient client, ListIdNamespaceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdNamespaceAssociationsPublisher(CleanRoomsAsyncClient client, ListIdNamespaceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdNamespaceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdNamespaceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdNamespaceAssociationSummary> idNamespaceAssociationSummaries() {
        Function<ListIdNamespaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.idNamespaceAssociationSummaries() != null) {
                return response.idNamespaceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdNamespaceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdNamespaceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListIdNamespaceAssociationsResponse> {
        private ListIdNamespaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdNamespaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdNamespaceAssociationsResponse> nextPage(ListIdNamespaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListIdNamespaceAssociationsPublisher.this.client.listIdNamespaceAssociations(ListIdNamespaceAssociationsPublisher.this.firstRequest);
            }
            return ListIdNamespaceAssociationsPublisher.this.client.listIdNamespaceAssociations((ListIdNamespaceAssociationsRequest)((Object)ListIdNamespaceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

