/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AdditionalAnalyses;
import software.amazon.awssdk.services.cleanrooms.model.AggregateColumn;
import software.amazon.awssdk.services.cleanrooms.model.AggregationConstraint;
import software.amazon.awssdk.services.cleanrooms.model.AggregationConstraintsCopier;
import software.amazon.awssdk.services.cleanrooms.model.AllowedAdditionalAnalysesCopier;
import software.amazon.awssdk.services.cleanrooms.model.AllowedResultReceiversCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicyAggregationAggregateColumnsListCopier;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperator;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperatorsListCopier;
import software.amazon.awssdk.services.cleanrooms.model.JoinRequiredOption;
import software.amazon.awssdk.services.cleanrooms.model.ScalarFunctions;
import software.amazon.awssdk.services.cleanrooms.model.ScalarFunctionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsolidatedPolicyAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsolidatedPolicyAggregation> {
    private static final SdkField<List<AggregateColumn>> AGGREGATE_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregateColumns").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::aggregateColumns)).setter(ConsolidatedPolicyAggregation.setter(Builder::aggregateColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregateColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("joinColumns").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::joinColumns)).setter(ConsolidatedPolicyAggregation.setter(Builder::joinColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOIN_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("joinRequired").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::joinRequiredAsString)).setter(ConsolidatedPolicyAggregation.setter(Builder::joinRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinRequired").build()}).build();
    private static final SdkField<List<String>> ALLOWED_JOIN_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedJoinOperators").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::allowedJoinOperatorsAsStrings)).setter(ConsolidatedPolicyAggregation.setter(Builder::allowedJoinOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedJoinOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DIMENSION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dimensionColumns").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::dimensionColumns)).setter(ConsolidatedPolicyAggregation.setter(Builder::dimensionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SCALAR_FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scalarFunctions").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::scalarFunctionsAsStrings)).setter(ConsolidatedPolicyAggregation.setter(Builder::scalarFunctionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalarFunctions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AggregationConstraint>> OUTPUT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputConstraints").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::outputConstraints)).setter(ConsolidatedPolicyAggregation.setter(Builder::outputConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalAnalyses").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::additionalAnalysesAsString)).setter(ConsolidatedPolicyAggregation.setter(Builder::additionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build()}).build();
    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedResultReceivers").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::allowedResultReceivers)).setter(ConsolidatedPolicyAggregation.setter(Builder::allowedResultReceivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAdditionalAnalyses").getter(ConsolidatedPolicyAggregation.getter(ConsolidatedPolicyAggregation::allowedAdditionalAnalyses)).setter(ConsolidatedPolicyAggregation.setter(Builder::allowedAdditionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_COLUMNS_FIELD, JOIN_COLUMNS_FIELD, JOIN_REQUIRED_FIELD, ALLOWED_JOIN_OPERATORS_FIELD, DIMENSION_COLUMNS_FIELD, SCALAR_FUNCTIONS_FIELD, OUTPUT_CONSTRAINTS_FIELD, ADDITIONAL_ANALYSES_FIELD, ALLOWED_RESULT_RECEIVERS_FIELD, ALLOWED_ADDITIONAL_ANALYSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConsolidatedPolicyAggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AggregateColumn> aggregateColumns;
    private final List<String> joinColumns;
    private final String joinRequired;
    private final List<String> allowedJoinOperators;
    private final List<String> dimensionColumns;
    private final List<String> scalarFunctions;
    private final List<AggregationConstraint> outputConstraints;
    private final String additionalAnalyses;
    private final List<String> allowedResultReceivers;
    private final List<String> allowedAdditionalAnalyses;

    private ConsolidatedPolicyAggregation(BuilderImpl builder) {
        this.aggregateColumns = builder.aggregateColumns;
        this.joinColumns = builder.joinColumns;
        this.joinRequired = builder.joinRequired;
        this.allowedJoinOperators = builder.allowedJoinOperators;
        this.dimensionColumns = builder.dimensionColumns;
        this.scalarFunctions = builder.scalarFunctions;
        this.outputConstraints = builder.outputConstraints;
        this.additionalAnalyses = builder.additionalAnalyses;
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    public final boolean hasAggregateColumns() {
        return this.aggregateColumns != null && !(this.aggregateColumns instanceof SdkAutoConstructList);
    }

    public final List<AggregateColumn> aggregateColumns() {
        return this.aggregateColumns;
    }

    public final boolean hasJoinColumns() {
        return this.joinColumns != null && !(this.joinColumns instanceof SdkAutoConstructList);
    }

    public final List<String> joinColumns() {
        return this.joinColumns;
    }

    public final JoinRequiredOption joinRequired() {
        return JoinRequiredOption.fromValue(this.joinRequired);
    }

    public final String joinRequiredAsString() {
        return this.joinRequired;
    }

    public final List<JoinOperator> allowedJoinOperators() {
        return JoinOperatorsListCopier.copyStringToEnum(this.allowedJoinOperators);
    }

    public final boolean hasAllowedJoinOperators() {
        return this.allowedJoinOperators != null && !(this.allowedJoinOperators instanceof SdkAutoConstructList);
    }

    public final List<String> allowedJoinOperatorsAsStrings() {
        return this.allowedJoinOperators;
    }

    public final boolean hasDimensionColumns() {
        return this.dimensionColumns != null && !(this.dimensionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionColumns() {
        return this.dimensionColumns;
    }

    public final List<ScalarFunctions> scalarFunctions() {
        return ScalarFunctionsListCopier.copyStringToEnum(this.scalarFunctions);
    }

    public final boolean hasScalarFunctions() {
        return this.scalarFunctions != null && !(this.scalarFunctions instanceof SdkAutoConstructList);
    }

    public final List<String> scalarFunctionsAsStrings() {
        return this.scalarFunctions;
    }

    public final boolean hasOutputConstraints() {
        return this.outputConstraints != null && !(this.outputConstraints instanceof SdkAutoConstructList);
    }

    public final List<AggregationConstraint> outputConstraints() {
        return this.outputConstraints;
    }

    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(this.additionalAnalyses);
    }

    public final String additionalAnalysesAsString() {
        return this.additionalAnalyses;
    }

    public final boolean hasAllowedResultReceivers() {
        return this.allowedResultReceivers != null && !(this.allowedResultReceivers instanceof SdkAutoConstructList);
    }

    public final List<String> allowedResultReceivers() {
        return this.allowedResultReceivers;
    }

    public final boolean hasAllowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses != null && !(this.allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregateColumns() ? this.aggregateColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinColumns() ? this.joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.joinRequiredAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionColumns() ? this.dimensionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalarFunctions() ? this.scalarFunctionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputConstraints() ? this.outputConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyAggregation)) {
            return false;
        }
        ConsolidatedPolicyAggregation other = (ConsolidatedPolicyAggregation)obj;
        return this.hasAggregateColumns() == other.hasAggregateColumns() && Objects.equals(this.aggregateColumns(), other.aggregateColumns()) && this.hasJoinColumns() == other.hasJoinColumns() && Objects.equals(this.joinColumns(), other.joinColumns()) && Objects.equals(this.joinRequiredAsString(), other.joinRequiredAsString()) && this.hasAllowedJoinOperators() == other.hasAllowedJoinOperators() && Objects.equals(this.allowedJoinOperatorsAsStrings(), other.allowedJoinOperatorsAsStrings()) && this.hasDimensionColumns() == other.hasDimensionColumns() && Objects.equals(this.dimensionColumns(), other.dimensionColumns()) && this.hasScalarFunctions() == other.hasScalarFunctions() && Objects.equals(this.scalarFunctionsAsStrings(), other.scalarFunctionsAsStrings()) && this.hasOutputConstraints() == other.hasOutputConstraints() && Objects.equals(this.outputConstraints(), other.outputConstraints()) && Objects.equals(this.additionalAnalysesAsString(), other.additionalAnalysesAsString()) && this.hasAllowedResultReceivers() == other.hasAllowedResultReceivers() && Objects.equals(this.allowedResultReceivers(), other.allowedResultReceivers()) && this.hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses() && Objects.equals(this.allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    public final String toString() {
        return ToString.builder((String)"ConsolidatedPolicyAggregation").add("AggregateColumns", this.hasAggregateColumns() ? this.aggregateColumns() : null).add("JoinColumns", this.hasJoinColumns() ? this.joinColumns() : null).add("JoinRequired", (Object)this.joinRequiredAsString()).add("AllowedJoinOperators", this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null).add("DimensionColumns", this.hasDimensionColumns() ? this.dimensionColumns() : null).add("ScalarFunctions", this.hasScalarFunctions() ? this.scalarFunctionsAsStrings() : null).add("OutputConstraints", this.hasOutputConstraints() ? this.outputConstraints() : null).add("AdditionalAnalyses", (Object)this.additionalAnalysesAsString()).add("AllowedResultReceivers", this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null).add("AllowedAdditionalAnalyses", this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregateColumns": {
                return Optional.ofNullable(clazz.cast(this.aggregateColumns()));
            }
            case "joinColumns": {
                return Optional.ofNullable(clazz.cast(this.joinColumns()));
            }
            case "joinRequired": {
                return Optional.ofNullable(clazz.cast(this.joinRequiredAsString()));
            }
            case "allowedJoinOperators": {
                return Optional.ofNullable(clazz.cast(this.allowedJoinOperatorsAsStrings()));
            }
            case "dimensionColumns": {
                return Optional.ofNullable(clazz.cast(this.dimensionColumns()));
            }
            case "scalarFunctions": {
                return Optional.ofNullable(clazz.cast(this.scalarFunctionsAsStrings()));
            }
            case "outputConstraints": {
                return Optional.ofNullable(clazz.cast(this.outputConstraints()));
            }
            case "additionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.additionalAnalysesAsString()));
            }
            case "allowedResultReceivers": {
                return Optional.ofNullable(clazz.cast(this.allowedResultReceivers()));
            }
            case "allowedAdditionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.allowedAdditionalAnalyses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aggregateColumns", AGGREGATE_COLUMNS_FIELD);
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("joinRequired", JOIN_REQUIRED_FIELD);
        map.put("allowedJoinOperators", ALLOWED_JOIN_OPERATORS_FIELD);
        map.put("dimensionColumns", DIMENSION_COLUMNS_FIELD);
        map.put("scalarFunctions", SCALAR_FUNCTIONS_FIELD);
        map.put("outputConstraints", OUTPUT_CONSTRAINTS_FIELD);
        map.put("additionalAnalyses", ADDITIONAL_ANALYSES_FIELD);
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyAggregation, T> g) {
        return obj -> g.apply((ConsolidatedPolicyAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AggregateColumn> aggregateColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();
        private String joinRequired;
        private List<String> allowedJoinOperators = DefaultSdkAutoConstructList.getInstance();
        private List<String> dimensionColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> scalarFunctions = DefaultSdkAutoConstructList.getInstance();
        private List<AggregationConstraint> outputConstraints = DefaultSdkAutoConstructList.getInstance();
        private String additionalAnalyses;
        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyAggregation model) {
            this.aggregateColumns(model.aggregateColumns);
            this.joinColumns(model.joinColumns);
            this.joinRequired(model.joinRequired);
            this.allowedJoinOperatorsWithStrings(model.allowedJoinOperators);
            this.dimensionColumns(model.dimensionColumns);
            this.scalarFunctionsWithStrings(model.scalarFunctions);
            this.outputConstraints(model.outputConstraints);
            this.additionalAnalyses(model.additionalAnalyses);
            this.allowedResultReceivers(model.allowedResultReceivers);
            this.allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final List<AggregateColumn.Builder> getAggregateColumns() {
            List<AggregateColumn.Builder> result = ConsolidatedPolicyAggregationAggregateColumnsListCopier.copyToBuilder(this.aggregateColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregateColumns(Collection<AggregateColumn.BuilderImpl> aggregateColumns) {
            this.aggregateColumns = ConsolidatedPolicyAggregationAggregateColumnsListCopier.copyFromBuilder(aggregateColumns);
        }

        @Override
        public final Builder aggregateColumns(Collection<AggregateColumn> aggregateColumns) {
            this.aggregateColumns = ConsolidatedPolicyAggregationAggregateColumnsListCopier.copy(aggregateColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateColumns(AggregateColumn ... aggregateColumns) {
            this.aggregateColumns(Arrays.asList(aggregateColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateColumns(Consumer<AggregateColumn.Builder> ... aggregateColumns) {
            this.aggregateColumns(Stream.of(aggregateColumns).map(c -> (AggregateColumn)((AggregateColumn.Builder)AggregateColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getJoinColumns() {
            if (this.joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleColumnListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleColumnListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String ... joinColumns) {
            this.joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final String getJoinRequired() {
            return this.joinRequired;
        }

        public final void setJoinRequired(String joinRequired) {
            this.joinRequired = joinRequired;
        }

        @Override
        public final Builder joinRequired(String joinRequired) {
            this.joinRequired = joinRequired;
            return this;
        }

        @Override
        public final Builder joinRequired(JoinRequiredOption joinRequired) {
            this.joinRequired(joinRequired == null ? null : joinRequired.toString());
            return this;
        }

        public final Collection<String> getAllowedJoinOperators() {
            if (this.allowedJoinOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedJoinOperators;
        }

        public final void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
        }

        @Override
        public final Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperatorsWithStrings(String ... allowedJoinOperators) {
            this.allowedJoinOperatorsWithStrings(Arrays.asList(allowedJoinOperators));
            return this;
        }

        @Override
        public final Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copyEnumToString(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperators(JoinOperator ... allowedJoinOperators) {
            this.allowedJoinOperators(Arrays.asList(allowedJoinOperators));
            return this;
        }

        public final Collection<String> getDimensionColumns() {
            if (this.dimensionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionColumns;
        }

        public final void setDimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
        }

        @Override
        public final Builder dimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionColumns(String ... dimensionColumns) {
            this.dimensionColumns(Arrays.asList(dimensionColumns));
            return this;
        }

        public final Collection<String> getScalarFunctions() {
            if (this.scalarFunctions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scalarFunctions;
        }

        public final void setScalarFunctions(Collection<String> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copy(scalarFunctions);
        }

        @Override
        public final Builder scalarFunctionsWithStrings(Collection<String> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copy(scalarFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalarFunctionsWithStrings(String ... scalarFunctions) {
            this.scalarFunctionsWithStrings(Arrays.asList(scalarFunctions));
            return this;
        }

        @Override
        public final Builder scalarFunctions(Collection<ScalarFunctions> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copyEnumToString(scalarFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalarFunctions(ScalarFunctions ... scalarFunctions) {
            this.scalarFunctions(Arrays.asList(scalarFunctions));
            return this;
        }

        public final List<AggregationConstraint.Builder> getOutputConstraints() {
            List<AggregationConstraint.Builder> result = AggregationConstraintsCopier.copyToBuilder(this.outputConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputConstraints(Collection<AggregationConstraint.BuilderImpl> outputConstraints) {
            this.outputConstraints = AggregationConstraintsCopier.copyFromBuilder(outputConstraints);
        }

        @Override
        public final Builder outputConstraints(Collection<AggregationConstraint> outputConstraints) {
            this.outputConstraints = AggregationConstraintsCopier.copy(outputConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputConstraints(AggregationConstraint ... outputConstraints) {
            this.outputConstraints(Arrays.asList(outputConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputConstraints(Consumer<AggregationConstraint.Builder> ... outputConstraints) {
            this.outputConstraints(Stream.of(outputConstraints).map(c -> (AggregationConstraint)((AggregationConstraint.Builder)AggregationConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return this.additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (this.allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String ... allowedResultReceivers) {
            this.allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (this.allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String ... allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        public ConsolidatedPolicyAggregation build() {
            return new ConsolidatedPolicyAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsolidatedPolicyAggregation> {
        public Builder aggregateColumns(Collection<AggregateColumn> var1);

        public Builder aggregateColumns(AggregateColumn ... var1);

        public Builder aggregateColumns(Consumer<AggregateColumn.Builder> ... var1);

        public Builder joinColumns(Collection<String> var1);

        public Builder joinColumns(String ... var1);

        public Builder joinRequired(String var1);

        public Builder joinRequired(JoinRequiredOption var1);

        public Builder allowedJoinOperatorsWithStrings(Collection<String> var1);

        public Builder allowedJoinOperatorsWithStrings(String ... var1);

        public Builder allowedJoinOperators(Collection<JoinOperator> var1);

        public Builder allowedJoinOperators(JoinOperator ... var1);

        public Builder dimensionColumns(Collection<String> var1);

        public Builder dimensionColumns(String ... var1);

        public Builder scalarFunctionsWithStrings(Collection<String> var1);

        public Builder scalarFunctionsWithStrings(String ... var1);

        public Builder scalarFunctions(Collection<ScalarFunctions> var1);

        public Builder scalarFunctions(ScalarFunctions ... var1);

        public Builder outputConstraints(Collection<AggregationConstraint> var1);

        public Builder outputConstraints(AggregationConstraint ... var1);

        public Builder outputConstraints(Consumer<AggregationConstraint.Builder> ... var1);

        public Builder additionalAnalyses(String var1);

        public Builder additionalAnalyses(AdditionalAnalyses var1);

        public Builder allowedResultReceivers(Collection<String> var1);

        public Builder allowedResultReceivers(String ... var1);

        public Builder allowedAdditionalAnalyses(Collection<String> var1);

        public Builder allowedAdditionalAnalyses(String ... var1);
    }
}

