/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.MemberSummary;
import software.amazon.awssdk.services.cleanrooms.model.MemberSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembersResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListMembersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMembersResponse.getter(ListMembersResponse::nextToken)).setter(ListMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<MemberSummary>> MEMBER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberSummaries").getter(ListMembersResponse.getter(ListMembersResponse::memberSummaries)).setter(ListMembersResponse.setter(Builder::memberSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MEMBER_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMembersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MemberSummary> memberSummaries;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.memberSummaries = builder.memberSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMemberSummaries() {
        return this.memberSummaries != null && !(this.memberSummaries instanceof SdkAutoConstructList);
    }

    public final List<MemberSummary> memberSummaries() {
        return this.memberSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberSummaries() ? this.memberSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMemberSummaries() == other.hasMemberSummaries() && Objects.equals(this.memberSummaries(), other.memberSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListMembersResponse").add("NextToken", (Object)this.nextToken()).add("MemberSummaries", this.hasMemberSummaries() ? this.memberSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "memberSummaries": {
                return Optional.ofNullable(clazz.cast(this.memberSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("memberSummaries", MEMBER_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MemberSummary> memberSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.memberSummaries(model.memberSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MemberSummary.Builder> getMemberSummaries() {
            List<MemberSummary.Builder> result = MemberSummaryListCopier.copyToBuilder(this.memberSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberSummaries(Collection<MemberSummary.BuilderImpl> memberSummaries) {
            this.memberSummaries = MemberSummaryListCopier.copyFromBuilder(memberSummaries);
        }

        @Override
        public final Builder memberSummaries(Collection<MemberSummary> memberSummaries) {
            this.memberSummaries = MemberSummaryListCopier.copy(memberSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberSummaries(MemberSummary ... memberSummaries) {
            this.memberSummaries(Arrays.asList(memberSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberSummaries(Consumer<MemberSummary.Builder> ... memberSummaries) {
            this.memberSummaries(Stream.of(memberSummaries).map(c -> (MemberSummary)((MemberSummary.Builder)MemberSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMembersResponse> {
        public Builder nextToken(String var1);

        public Builder memberSummaries(Collection<MemberSummary> var1);

        public Builder memberSummaries(MemberSummary ... var1);

        public Builder memberSummaries(Consumer<MemberSummary.Builder> ... var1);
    }
}

