/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalysisMethod {
    DIRECT_QUERY("DIRECT_QUERY"),
    DIRECT_JOB("DIRECT_JOB"),
    MULTIPLE("MULTIPLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalysisMethod> VALUE_MAP;
    private final String value;

    private AnalysisMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisMethod> knownValues() {
        EnumSet<AnalysisMethod> knownValues = EnumSet.allOf(AnalysisMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalysisMethod.class, AnalysisMethod::toString);
    }
}

