/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobError;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobParameters;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobResult;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobResultConfigurationOutput;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobStatistics;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedJob> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ProtectedJob.getter(ProtectedJob::id)).setter(ProtectedJob.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(ProtectedJob.getter(ProtectedJob::membershipId)).setter(ProtectedJob.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(ProtectedJob.getter(ProtectedJob::membershipArn)).setter(ProtectedJob.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ProtectedJob.getter(ProtectedJob::createTime)).setter(ProtectedJob.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<ProtectedJobParameters> JOB_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobParameters").getter(ProtectedJob.getter(ProtectedJob::jobParameters)).setter(ProtectedJob.setter(Builder::jobParameters)).constructor(ProtectedJobParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ProtectedJob.getter(ProtectedJob::statusAsString)).setter(ProtectedJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ProtectedJobResultConfigurationOutput> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultConfiguration").getter(ProtectedJob.getter(ProtectedJob::resultConfiguration)).setter(ProtectedJob.setter(Builder::resultConfiguration)).constructor(ProtectedJobResultConfigurationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build()}).build();
    private static final SdkField<ProtectedJobStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(ProtectedJob.getter(ProtectedJob::statistics)).setter(ProtectedJob.setter(Builder::statistics)).constructor(ProtectedJobStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<ProtectedJobResult> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("result").getter(ProtectedJob.getter(ProtectedJob::result)).setter(ProtectedJob.setter(Builder::result)).constructor(ProtectedJobResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<ProtectedJobError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ProtectedJob.getter(ProtectedJob::error)).setter(ProtectedJob.setter(Builder::error)).constructor(ProtectedJobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, JOB_PARAMETERS_FIELD, STATUS_FIELD, RESULT_CONFIGURATION_FIELD, STATISTICS_FIELD, RESULT_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String membershipId;
    private final String membershipArn;
    private final Instant createTime;
    private final ProtectedJobParameters jobParameters;
    private final String status;
    private final ProtectedJobResultConfigurationOutput resultConfiguration;
    private final ProtectedJobStatistics statistics;
    private final ProtectedJobResult result;
    private final ProtectedJobError error;

    private ProtectedJob(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.jobParameters = builder.jobParameters;
        this.status = builder.status;
        this.resultConfiguration = builder.resultConfiguration;
        this.statistics = builder.statistics;
        this.result = builder.result;
        this.error = builder.error;
    }

    public final String id() {
        return this.id;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final ProtectedJobParameters jobParameters() {
        return this.jobParameters;
    }

    public final ProtectedJobStatus status() {
        return ProtectedJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ProtectedJobResultConfigurationOutput resultConfiguration() {
        return this.resultConfiguration;
    }

    public final ProtectedJobStatistics statistics() {
        return this.statistics;
    }

    public final ProtectedJobResult result() {
        return this.result;
    }

    public final ProtectedJobError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJob)) {
            return false;
        }
        ProtectedJob other = (ProtectedJob)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.jobParameters(), other.jobParameters()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedJob").add("Id", (Object)this.id()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("CreateTime", (Object)this.createTime()).add("JobParameters", (Object)this.jobParameters()).add("Status", (Object)this.statusAsString()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("Statistics", (Object)this.statistics()).add("Result", (Object)this.result()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "jobParameters": {
                return Optional.ofNullable(clazz.cast(this.jobParameters()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("jobParameters", JOB_PARAMETERS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJob, T> g) {
        return obj -> g.apply((ProtectedJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String membershipId;
        private String membershipArn;
        private Instant createTime;
        private ProtectedJobParameters jobParameters;
        private String status;
        private ProtectedJobResultConfigurationOutput resultConfiguration;
        private ProtectedJobStatistics statistics;
        private ProtectedJobResult result;
        private ProtectedJobError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJob model) {
            this.id(model.id);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.createTime(model.createTime);
            this.jobParameters(model.jobParameters);
            this.status(model.status);
            this.resultConfiguration(model.resultConfiguration);
            this.statistics(model.statistics);
            this.result(model.result);
            this.error(model.error);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final ProtectedJobParameters.Builder getJobParameters() {
            return this.jobParameters != null ? this.jobParameters.toBuilder() : null;
        }

        public final void setJobParameters(ProtectedJobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        @Override
        public final Builder jobParameters(ProtectedJobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ProtectedJobResultConfigurationOutput.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedJobResultConfigurationOutput.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedJobResultConfigurationOutput resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedJobStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(ProtectedJobStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ProtectedJobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final ProtectedJobResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(ProtectedJobResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(ProtectedJobResult result) {
            this.result = result;
            return this;
        }

        public final ProtectedJobError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ProtectedJobError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProtectedJobError error) {
            this.error = error;
            return this;
        }

        public ProtectedJob build() {
            return new ProtectedJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedJob> {
        public Builder id(String var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder createTime(Instant var1);

        public Builder jobParameters(ProtectedJobParameters var1);

        default public Builder jobParameters(Consumer<ProtectedJobParameters.Builder> jobParameters) {
            return this.jobParameters((ProtectedJobParameters)((ProtectedJobParameters.Builder)ProtectedJobParameters.builder().applyMutation(jobParameters)).build());
        }

        public Builder status(String var1);

        public Builder status(ProtectedJobStatus var1);

        public Builder resultConfiguration(ProtectedJobResultConfigurationOutput var1);

        default public Builder resultConfiguration(Consumer<ProtectedJobResultConfigurationOutput.Builder> resultConfiguration) {
            return this.resultConfiguration((ProtectedJobResultConfigurationOutput)((ProtectedJobResultConfigurationOutput.Builder)ProtectedJobResultConfigurationOutput.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder statistics(ProtectedJobStatistics var1);

        default public Builder statistics(Consumer<ProtectedJobStatistics.Builder> statistics) {
            return this.statistics((ProtectedJobStatistics)((ProtectedJobStatistics.Builder)ProtectedJobStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder result(ProtectedJobResult var1);

        default public Builder result(Consumer<ProtectedJobResult.Builder> result) {
            return this.result((ProtectedJobResult)((ProtectedJobResult.Builder)ProtectedJobResult.builder().applyMutation(result)).build());
        }

        public Builder error(ProtectedJobError var1);

        default public Builder error(Consumer<ProtectedJobError.Builder> error) {
            return this.error((ProtectedJobError)((ProtectedJobError.Builder)ProtectedJobError.builder().applyMutation(error)).build());
        }
    }
}

