/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a table within Athena.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AthenaTableReference implements SdkPojo, Serializable,
        ToCopyableBuilder<AthenaTableReference.Builder, AthenaTableReference> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workGroup").getter(getter(AthenaTableReference::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workGroup").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputLocation").getter(getter(AthenaTableReference::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(AthenaTableReference::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(AthenaTableReference::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD,
            OUTPUT_LOCATION_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workGroup;

    private final String outputLocation;

    private final String databaseName;

    private final String tableName;

    private AthenaTableReference(BuilderImpl builder) {
        this.workGroup = builder.workGroup;
        this.outputLocation = builder.outputLocation;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
    }

    /**
     * <p>
     * The workgroup of the Athena table reference.
     * </p>
     * 
     * @return The workgroup of the Athena table reference.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The output location for the Athena table.
     * </p>
     * 
     * @return The output location for the Athena table.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The database name.
     * </p>
     * 
     * @return The database name.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The table reference.
     * </p>
     * 
     * @return The table reference.
     */
    public final String tableName() {
        return tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AthenaTableReference)) {
            return false;
        }
        AthenaTableReference other = (AthenaTableReference) obj;
        return Objects.equals(workGroup(), other.workGroup()) && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AthenaTableReference").add("WorkGroup", workGroup()).add("OutputLocation", outputLocation())
                .add("DatabaseName", databaseName()).add("TableName", tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workGroup", WORK_GROUP_FIELD);
        map.put("outputLocation", OUTPUT_LOCATION_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AthenaTableReference, T> g) {
        return obj -> g.apply((AthenaTableReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AthenaTableReference> {
        /**
         * <p>
         * The workgroup of the Athena table reference.
         * </p>
         * 
         * @param workGroup
         *        The workgroup of the Athena table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The output location for the Athena table.
         * </p>
         * 
         * @param outputLocation
         *        The output location for the Athena table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The database name.
         * </p>
         * 
         * @param databaseName
         *        The database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The table reference.
         * </p>
         * 
         * @param tableName
         *        The table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);
    }

    static final class BuilderImpl implements Builder {
        private String workGroup;

        private String outputLocation;

        private String databaseName;

        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(AthenaTableReference model) {
            workGroup(model.workGroup);
            outputLocation(model.outputLocation);
            databaseName(model.databaseName);
            tableName(model.tableName);
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AthenaTableReference build() {
            return new AthenaTableReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
