/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnalysisTemplateResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<CreateAnalysisTemplateResponse.Builder, CreateAnalysisTemplateResponse> {
    private static final SdkField<AnalysisTemplate> ANALYSIS_TEMPLATE_FIELD = SdkField
            .<AnalysisTemplate> builder(MarshallingType.SDK_POJO).memberName("analysisTemplate")
            .getter(getter(CreateAnalysisTemplateResponse::analysisTemplate)).setter(setter(Builder::analysisTemplate))
            .constructor(AnalysisTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnalysisTemplate analysisTemplate;

    private CreateAnalysisTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.analysisTemplate = builder.analysisTemplate;
    }

    /**
     * <p>
     * The analysis template.
     * </p>
     * 
     * @return The analysis template.
     */
    public final AnalysisTemplate analysisTemplate() {
        return analysisTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisTemplateResponse)) {
            return false;
        }
        CreateAnalysisTemplateResponse other = (CreateAnalysisTemplateResponse) obj;
        return Objects.equals(analysisTemplate(), other.analysisTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnalysisTemplateResponse").add("AnalysisTemplate", analysisTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisTemplate":
            return Optional.ofNullable(clazz.cast(analysisTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisTemplate", ANALYSIS_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalysisTemplateResponse, T> g) {
        return obj -> g.apply((CreateAnalysisTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnalysisTemplateResponse> {
        /**
         * <p>
         * The analysis template.
         * </p>
         * 
         * @param analysisTemplate
         *        The analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisTemplate(AnalysisTemplate analysisTemplate);

        /**
         * <p>
         * The analysis template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisTemplate.Builder} avoiding the
         * need to create one manually via {@link AnalysisTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisTemplate(AnalysisTemplate)}.
         * 
         * @param analysisTemplate
         *        a consumer that will call methods on {@link AnalysisTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisTemplate(AnalysisTemplate)
         */
        default Builder analysisTemplate(Consumer<AnalysisTemplate.Builder> analysisTemplate) {
            return analysisTemplate(AnalysisTemplate.builder().applyMutation(analysisTemplate).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private AnalysisTemplate analysisTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalysisTemplateResponse model) {
            super(model);
            analysisTemplate(model.analysisTemplate);
        }

        public final AnalysisTemplate.Builder getAnalysisTemplate() {
            return analysisTemplate != null ? analysisTemplate.toBuilder() : null;
        }

        public final void setAnalysisTemplate(AnalysisTemplate.BuilderImpl analysisTemplate) {
            this.analysisTemplate = analysisTemplate != null ? analysisTemplate.build() : null;
        }

        @Override
        public final Builder analysisTemplate(AnalysisTemplate analysisTemplate) {
            this.analysisTemplate = analysisTemplate;
            return this;
        }

        @Override
        public CreateAnalysisTemplateResponse build() {
            return new CreateAnalysisTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
