/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfiguredTableRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateConfiguredTableRequest.Builder, CreateConfiguredTableRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateConfiguredTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateConfiguredTableRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TableReference> TABLE_REFERENCE_FIELD = SdkField
            .<TableReference> builder(MarshallingType.SDK_POJO).memberName("tableReference")
            .getter(getter(CreateConfiguredTableRequest::tableReference)).setter(setter(Builder::tableReference))
            .constructor(TableReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableReference").build()).build();

    private static final SdkField<List<String>> ALLOWED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedColumns")
            .getter(getter(CreateConfiguredTableRequest::allowedColumns))
            .setter(setter(Builder::allowedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisMethod").getter(getter(CreateConfiguredTableRequest::analysisMethodAsString))
            .setter(setter(Builder::analysisMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()).build();

    private static final SdkField<List<String>> SELECTED_ANALYSIS_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("selectedAnalysisMethods")
            .getter(getter(CreateConfiguredTableRequest::selectedAnalysisMethodsAsStrings))
            .setter(setter(Builder::selectedAnalysisMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedAnalysisMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateConfiguredTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TABLE_REFERENCE_FIELD, ALLOWED_COLUMNS_FIELD, ANALYSIS_METHOD_FIELD, SELECTED_ANALYSIS_METHODS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final TableReference tableReference;

    private final List<String> allowedColumns;

    private final String analysisMethod;

    private final List<String> selectedAnalysisMethods;

    private final Map<String, String> tags;

    private CreateConfiguredTableRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.tableReference = builder.tableReference;
        this.allowedColumns = builder.allowedColumns;
        this.analysisMethod = builder.analysisMethod;
        this.selectedAnalysisMethods = builder.selectedAnalysisMethods;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the configured table.
     * </p>
     * 
     * @return The name of the configured table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the configured table.
     * </p>
     * 
     * @return A description for the configured table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A reference to the table being configured.
     * </p>
     * 
     * @return A reference to the table being configured.
     */
    public final TableReference tableReference() {
        return tableReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedColumns() {
        return allowedColumns != null && !(allowedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns of the underlying table that can be used by collaborations or analysis rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedColumns} method.
     * </p>
     * 
     * @return The columns of the underlying table that can be used by collaborations or analysis rules.
     */
    public final List<String> allowedColumns() {
        return allowedColumns;
    }

    /**
     * <p>
     * The analysis method allowed for the configured tables.
     * </p>
     * <p>
     * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     * </p>
     * <p>
     * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method allowed for the configured tables.</p>
     *         <p>
     *         <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * @see AnalysisMethod
     */
    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(analysisMethod);
    }

    /**
     * <p>
     * The analysis method allowed for the configured tables.
     * </p>
     * <p>
     * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     * </p>
     * <p>
     * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method allowed for the configured tables.</p>
     *         <p>
     *         <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * @see AnalysisMethod
     */
    public final String analysisMethodAsString() {
        return analysisMethod;
    }

    /**
     * <p>
     * The analysis methods to enable for the configured table. When configured, you must specify at least two analysis
     * methods.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedAnalysisMethods} method.
     * </p>
     * 
     * @return The analysis methods to enable for the configured table. When configured, you must specify at least two
     *         analysis methods.
     */
    public final List<SelectedAnalysisMethod> selectedAnalysisMethods() {
        return SelectedAnalysisMethodsCopier.copyStringToEnum(selectedAnalysisMethods);
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedAnalysisMethods property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelectedAnalysisMethods() {
        return selectedAnalysisMethods != null && !(selectedAnalysisMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The analysis methods to enable for the configured table. When configured, you must specify at least two analysis
     * methods.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedAnalysisMethods} method.
     * </p>
     * 
     * @return The analysis methods to enable for the configured table. When configured, you must specify at least two
     *         analysis methods.
     */
    public final List<String> selectedAnalysisMethodsAsStrings() {
        return selectedAnalysisMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tableReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedColumns() ? allowedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedAnalysisMethods() ? selectedAnalysisMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredTableRequest)) {
            return false;
        }
        CreateConfiguredTableRequest other = (CreateConfiguredTableRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(tableReference(), other.tableReference()) && hasAllowedColumns() == other.hasAllowedColumns()
                && Objects.equals(allowedColumns(), other.allowedColumns())
                && Objects.equals(analysisMethodAsString(), other.analysisMethodAsString())
                && hasSelectedAnalysisMethods() == other.hasSelectedAnalysisMethods()
                && Objects.equals(selectedAnalysisMethodsAsStrings(), other.selectedAnalysisMethodsAsStrings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfiguredTableRequest").add("Name", name()).add("Description", description())
                .add("TableReference", tableReference()).add("AllowedColumns", hasAllowedColumns() ? allowedColumns() : null)
                .add("AnalysisMethod", analysisMethodAsString())
                .add("SelectedAnalysisMethods", hasSelectedAnalysisMethods() ? selectedAnalysisMethodsAsStrings() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tableReference":
            return Optional.ofNullable(clazz.cast(tableReference()));
        case "allowedColumns":
            return Optional.ofNullable(clazz.cast(allowedColumns()));
        case "analysisMethod":
            return Optional.ofNullable(clazz.cast(analysisMethodAsString()));
        case "selectedAnalysisMethods":
            return Optional.ofNullable(clazz.cast(selectedAnalysisMethodsAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tableReference", TABLE_REFERENCE_FIELD);
        map.put("allowedColumns", ALLOWED_COLUMNS_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        map.put("selectedAnalysisMethods", SELECTED_ANALYSIS_METHODS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredTableRequest, T> g) {
        return obj -> g.apply((CreateConfiguredTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConfiguredTableRequest> {
        /**
         * <p>
         * The name of the configured table.
         * </p>
         * 
         * @param name
         *        The name of the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the configured table.
         * </p>
         * 
         * @param description
         *        A description for the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A reference to the table being configured.
         * </p>
         * 
         * @param tableReference
         *        A reference to the table being configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableReference(TableReference tableReference);

        /**
         * <p>
         * A reference to the table being configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableReference.Builder} avoiding the need
         * to create one manually via {@link TableReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableReference.Builder#build()} is called immediately and its
         * result is passed to {@link #tableReference(TableReference)}.
         * 
         * @param tableReference
         *        a consumer that will call methods on {@link TableReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableReference(TableReference)
         */
        default Builder tableReference(Consumer<TableReference.Builder> tableReference) {
            return tableReference(TableReference.builder().applyMutation(tableReference).build());
        }

        /**
         * <p>
         * The columns of the underlying table that can be used by collaborations or analysis rules.
         * </p>
         * 
         * @param allowedColumns
         *        The columns of the underlying table that can be used by collaborations or analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedColumns(Collection<String> allowedColumns);

        /**
         * <p>
         * The columns of the underlying table that can be used by collaborations or analysis rules.
         * </p>
         * 
         * @param allowedColumns
         *        The columns of the underlying table that can be used by collaborations or analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedColumns(String... allowedColumns);

        /**
         * <p>
         * The analysis method allowed for the configured tables.
         * </p>
         * <p>
         * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         * </p>
         * <p>
         * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         * </p>
         * <p>
         * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method allowed for the configured tables.</p>
         *        <p>
         *        <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(String analysisMethod);

        /**
         * <p>
         * The analysis method allowed for the configured tables.
         * </p>
         * <p>
         * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         * </p>
         * <p>
         * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         * </p>
         * <p>
         * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method allowed for the configured tables.</p>
         *        <p>
         *        <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(AnalysisMethod analysisMethod);

        /**
         * <p>
         * The analysis methods to enable for the configured table. When configured, you must specify at least two
         * analysis methods.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The analysis methods to enable for the configured table. When configured, you must specify at least
         *        two analysis methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods);

        /**
         * <p>
         * The analysis methods to enable for the configured table. When configured, you must specify at least two
         * analysis methods.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The analysis methods to enable for the configured table. When configured, you must specify at least
         *        two analysis methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethodsWithStrings(String... selectedAnalysisMethods);

        /**
         * <p>
         * The analysis methods to enable for the configured table. When configured, you must specify at least two
         * analysis methods.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The analysis methods to enable for the configured table. When configured, you must specify at least
         *        two analysis methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods);

        /**
         * <p>
         * The analysis methods to enable for the configured table. When configured, you must specify at least two
         * analysis methods.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The analysis methods to enable for the configured table. When configured, you must specify at least
         *        two analysis methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethods(SelectedAnalysisMethod... selectedAnalysisMethods);

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private TableReference tableReference;

        private List<String> allowedColumns = DefaultSdkAutoConstructList.getInstance();

        private String analysisMethod;

        private List<String> selectedAnalysisMethods = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredTableRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            tableReference(model.tableReference);
            allowedColumns(model.allowedColumns);
            analysisMethod(model.analysisMethod);
            selectedAnalysisMethodsWithStrings(model.selectedAnalysisMethods);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TableReference.Builder getTableReference() {
            return tableReference != null ? tableReference.toBuilder() : null;
        }

        public final void setTableReference(TableReference.BuilderImpl tableReference) {
            this.tableReference = tableReference != null ? tableReference.build() : null;
        }

        @Override
        public final Builder tableReference(TableReference tableReference) {
            this.tableReference = tableReference;
            return this;
        }

        public final Collection<String> getAllowedColumns() {
            if (allowedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedColumns;
        }

        public final void setAllowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
        }

        @Override
        public final Builder allowedColumns(Collection<String> allowedColumns) {
            this.allowedColumns = AllowedColumnListCopier.copy(allowedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedColumns(String... allowedColumns) {
            allowedColumns(Arrays.asList(allowedColumns));
            return this;
        }

        public final String getAnalysisMethod() {
            return analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final Collection<String> getSelectedAnalysisMethods() {
            if (selectedAnalysisMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedAnalysisMethods;
        }

        public final void setSelectedAnalysisMethods(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
        }

        @Override
        public final Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethodsWithStrings(String... selectedAnalysisMethods) {
            selectedAnalysisMethodsWithStrings(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public final Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copyEnumToString(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethods(SelectedAnalysisMethod... selectedAnalysisMethods) {
            selectedAnalysisMethods(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredTableRequest build() {
            return new CreateConfiguredTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
