/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional properties that are specific to the type of the associated schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingTableSchemaTypeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingTableSchemaTypeProperties.Builder, IdMappingTableSchemaTypeProperties> {
    private static final SdkField<List<IdMappingTableInputSource>> ID_MAPPING_TABLE_INPUT_SOURCE_FIELD = SdkField
            .<List<IdMappingTableInputSource>> builder(MarshallingType.LIST)
            .memberName("idMappingTableInputSource")
            .getter(getter(IdMappingTableSchemaTypeProperties::idMappingTableInputSource))
            .setter(setter(Builder::idMappingTableInputSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingTableInputSource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingTableInputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingTableInputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ID_MAPPING_TABLE_INPUT_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<IdMappingTableInputSource> idMappingTableInputSource;

    private IdMappingTableSchemaTypeProperties(BuilderImpl builder) {
        this.idMappingTableInputSource = builder.idMappingTableInputSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdMappingTableInputSource property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdMappingTableInputSource() {
        return idMappingTableInputSource != null && !(idMappingTableInputSource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines which ID namespace associations are used to create the ID mapping table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdMappingTableInputSource} method.
     * </p>
     * 
     * @return Defines which ID namespace associations are used to create the ID mapping table.
     */
    public final List<IdMappingTableInputSource> idMappingTableInputSource() {
        return idMappingTableInputSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIdMappingTableInputSource() ? idMappingTableInputSource() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingTableSchemaTypeProperties)) {
            return false;
        }
        IdMappingTableSchemaTypeProperties other = (IdMappingTableSchemaTypeProperties) obj;
        return hasIdMappingTableInputSource() == other.hasIdMappingTableInputSource()
                && Objects.equals(idMappingTableInputSource(), other.idMappingTableInputSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingTableSchemaTypeProperties")
                .add("IdMappingTableInputSource", hasIdMappingTableInputSource() ? idMappingTableInputSource() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingTableInputSource":
            return Optional.ofNullable(clazz.cast(idMappingTableInputSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingTableInputSource", ID_MAPPING_TABLE_INPUT_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingTableSchemaTypeProperties, T> g) {
        return obj -> g.apply((IdMappingTableSchemaTypeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingTableSchemaTypeProperties> {
        /**
         * <p>
         * Defines which ID namespace associations are used to create the ID mapping table.
         * </p>
         * 
         * @param idMappingTableInputSource
         *        Defines which ID namespace associations are used to create the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTableInputSource(Collection<IdMappingTableInputSource> idMappingTableInputSource);

        /**
         * <p>
         * Defines which ID namespace associations are used to create the ID mapping table.
         * </p>
         * 
         * @param idMappingTableInputSource
         *        Defines which ID namespace associations are used to create the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTableInputSource(IdMappingTableInputSource... idMappingTableInputSource);

        /**
         * <p>
         * Defines which ID namespace associations are used to create the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.IdMappingTableInputSource.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.IdMappingTableInputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.IdMappingTableInputSource.Builder#build()} is called
         * immediately and its result is passed to {@link #idMappingTableInputSource(List<IdMappingTableInputSource>)}.
         * 
         * @param idMappingTableInputSource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.IdMappingTableInputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingTableInputSource(java.util.Collection<IdMappingTableInputSource>)
         */
        Builder idMappingTableInputSource(Consumer<IdMappingTableInputSource.Builder>... idMappingTableInputSource);
    }

    static final class BuilderImpl implements Builder {
        private List<IdMappingTableInputSource> idMappingTableInputSource = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingTableSchemaTypeProperties model) {
            idMappingTableInputSource(model.idMappingTableInputSource);
        }

        public final List<IdMappingTableInputSource.Builder> getIdMappingTableInputSource() {
            List<IdMappingTableInputSource.Builder> result = IdMappingTableInputSourceListCopier
                    .copyToBuilder(this.idMappingTableInputSource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdMappingTableInputSource(Collection<IdMappingTableInputSource.BuilderImpl> idMappingTableInputSource) {
            this.idMappingTableInputSource = IdMappingTableInputSourceListCopier.copyFromBuilder(idMappingTableInputSource);
        }

        @Override
        public final Builder idMappingTableInputSource(Collection<IdMappingTableInputSource> idMappingTableInputSource) {
            this.idMappingTableInputSource = IdMappingTableInputSourceListCopier.copy(idMappingTableInputSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingTableInputSource(IdMappingTableInputSource... idMappingTableInputSource) {
            idMappingTableInputSource(Arrays.asList(idMappingTableInputSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingTableInputSource(Consumer<IdMappingTableInputSource.Builder>... idMappingTableInputSource) {
            idMappingTableInputSource(Stream.of(idMappingTableInputSource)
                    .map(c -> IdMappingTableInputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IdMappingTableSchemaTypeProperties build() {
            return new IdMappingTableSchemaTypeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
