/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProtectedJobsResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListProtectedJobsResponse.Builder, ListProtectedJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProtectedJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ProtectedJobSummary>> PROTECTED_JOBS_FIELD = SdkField
            .<List<ProtectedJobSummary>> builder(MarshallingType.LIST)
            .memberName("protectedJobs")
            .getter(getter(ListProtectedJobsResponse::protectedJobs))
            .setter(setter(Builder::protectedJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectedJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectedJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROTECTED_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ProtectedJobSummary> protectedJobs;

    private ListProtectedJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.protectedJobs = builder.protectedJobs;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectedJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectedJobs() {
        return protectedJobs != null && !(protectedJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of protected job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectedJobs} method.
     * </p>
     * 
     * @return A list of protected job summaries.
     */
    public final List<ProtectedJobSummary> protectedJobs() {
        return protectedJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedJobs() ? protectedJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProtectedJobsResponse)) {
            return false;
        }
        ListProtectedJobsResponse other = (ListProtectedJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasProtectedJobs() == other.hasProtectedJobs()
                && Objects.equals(protectedJobs(), other.protectedJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProtectedJobsResponse").add("NextToken", nextToken())
                .add("ProtectedJobs", hasProtectedJobs() ? protectedJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "protectedJobs":
            return Optional.ofNullable(clazz.cast(protectedJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("protectedJobs", PROTECTED_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProtectedJobsResponse, T> g) {
        return obj -> g.apply((ListProtectedJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProtectedJobsResponse> {
        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of protected job summaries.
         * </p>
         * 
         * @param protectedJobs
         *        A list of protected job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedJobs(Collection<ProtectedJobSummary> protectedJobs);

        /**
         * <p>
         * A list of protected job summaries.
         * </p>
         * 
         * @param protectedJobs
         *        A list of protected job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedJobs(ProtectedJobSummary... protectedJobs);

        /**
         * <p>
         * A list of protected job summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #protectedJobs(List<ProtectedJobSummary>)}.
         * 
         * @param protectedJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedJobs(java.util.Collection<ProtectedJobSummary>)
         */
        Builder protectedJobs(Consumer<ProtectedJobSummary.Builder>... protectedJobs);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ProtectedJobSummary> protectedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProtectedJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            protectedJobs(model.protectedJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProtectedJobSummary.Builder> getProtectedJobs() {
            List<ProtectedJobSummary.Builder> result = ProtectedJobSummaryListCopier.copyToBuilder(this.protectedJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectedJobs(Collection<ProtectedJobSummary.BuilderImpl> protectedJobs) {
            this.protectedJobs = ProtectedJobSummaryListCopier.copyFromBuilder(protectedJobs);
        }

        @Override
        public final Builder protectedJobs(Collection<ProtectedJobSummary> protectedJobs) {
            this.protectedJobs = ProtectedJobSummaryListCopier.copy(protectedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedJobs(ProtectedJobSummary... protectedJobs) {
            protectedJobs(Arrays.asList(protectedJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedJobs(Consumer<ProtectedJobSummary.Builder>... protectedJobs) {
            protectedJobs(Stream.of(protectedJobs).map(c -> ProtectedJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProtectedJobsResponse build() {
            return new ListProtectedJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
