/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The epsilon and noise parameters that you want to update in the privacy budget template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivacyBudgetTemplateUpdateParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivacyBudgetTemplateUpdateParameters.Builder, PrivacyBudgetTemplateUpdateParameters> {
    private static final SdkField<DifferentialPrivacyTemplateUpdateParameters> DIFFERENTIAL_PRIVACY_FIELD = SdkField
            .<DifferentialPrivacyTemplateUpdateParameters> builder(MarshallingType.SDK_POJO).memberName("differentialPrivacy")
            .getter(getter(PrivacyBudgetTemplateUpdateParameters::differentialPrivacy))
            .setter(setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyTemplateUpdateParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENTIAL_PRIVACY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DifferentialPrivacyTemplateUpdateParameters differentialPrivacy;

    private final Type type;

    private PrivacyBudgetTemplateUpdateParameters(BuilderImpl builder) {
        this.differentialPrivacy = builder.differentialPrivacy;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that specifies the new values for the epsilon and noise parameters.
     * </p>
     * 
     * @return An object that specifies the new values for the epsilon and noise parameters.
     */
    public final DifferentialPrivacyTemplateUpdateParameters differentialPrivacy() {
        return differentialPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(differentialPrivacy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetTemplateUpdateParameters)) {
            return false;
        }
        PrivacyBudgetTemplateUpdateParameters other = (PrivacyBudgetTemplateUpdateParameters) obj;
        return Objects.equals(differentialPrivacy(), other.differentialPrivacy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivacyBudgetTemplateUpdateParameters").add("DifferentialPrivacy", differentialPrivacy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "differentialPrivacy":
            return Optional.ofNullable(clazz.cast(differentialPrivacy()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * An object that specifies the new values for the epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        An object that specifies the new values for the epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateUpdateParameters fromDifferentialPrivacy(
            DifferentialPrivacyTemplateUpdateParameters differentialPrivacy) {
        return builder().differentialPrivacy(differentialPrivacy).build();
    }

    /**
     * Create an instance of this class with {@link #differentialPrivacy()} initialized to the given value.
     *
     * <p>
     * An object that specifies the new values for the epsilon and noise parameters.
     * </p>
     * 
     * @param differentialPrivacy
     *        An object that specifies the new values for the epsilon and noise parameters.
     */
    public static PrivacyBudgetTemplateUpdateParameters fromDifferentialPrivacy(
            Consumer<DifferentialPrivacyTemplateUpdateParameters.Builder> differentialPrivacy) {
        DifferentialPrivacyTemplateUpdateParameters.Builder builder = DifferentialPrivacyTemplateUpdateParameters.builder();
        differentialPrivacy.accept(builder);
        return fromDifferentialPrivacy(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("differentialPrivacy", DIFFERENTIAL_PRIVACY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetTemplateUpdateParameters, T> g) {
        return obj -> g.apply((PrivacyBudgetTemplateUpdateParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivacyBudgetTemplateUpdateParameters> {
        /**
         * <p>
         * An object that specifies the new values for the epsilon and noise parameters.
         * </p>
         * 
         * @param differentialPrivacy
         *        An object that specifies the new values for the epsilon and noise parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differentialPrivacy(DifferentialPrivacyTemplateUpdateParameters differentialPrivacy);

        /**
         * <p>
         * An object that specifies the new values for the epsilon and noise parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DifferentialPrivacyTemplateUpdateParameters.Builder} avoiding the need to create one manually via
         * {@link DifferentialPrivacyTemplateUpdateParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DifferentialPrivacyTemplateUpdateParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #differentialPrivacy(DifferentialPrivacyTemplateUpdateParameters)}.
         * 
         * @param differentialPrivacy
         *        a consumer that will call methods on {@link DifferentialPrivacyTemplateUpdateParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differentialPrivacy(DifferentialPrivacyTemplateUpdateParameters)
         */
        default Builder differentialPrivacy(Consumer<DifferentialPrivacyTemplateUpdateParameters.Builder> differentialPrivacy) {
            return differentialPrivacy(DifferentialPrivacyTemplateUpdateParameters.builder().applyMutation(differentialPrivacy)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DifferentialPrivacyTemplateUpdateParameters differentialPrivacy;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetTemplateUpdateParameters model) {
            differentialPrivacy(model.differentialPrivacy);
        }

        public final DifferentialPrivacyTemplateUpdateParameters.Builder getDifferentialPrivacy() {
            return differentialPrivacy != null ? differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyTemplateUpdateParameters.BuilderImpl differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyTemplateUpdateParameters differentialPrivacy) {
            Object oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy;
            handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
            return this;
        }

        @Override
        public PrivacyBudgetTemplateUpdateParameters build() {
            return new PrivacyBudgetTemplateUpdateParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PrivacyBudgetTemplateUpdateParameters#type()
     */
    public enum Type {
        DIFFERENTIAL_PRIVACY,

        UNKNOWN_TO_SDK_VERSION
    }
}
