/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a table within Snowflake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeTableReference implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeTableReference.Builder, SnowflakeTableReference> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(SnowflakeTableReference::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> ACCOUNT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountIdentifier").getter(getter(SnowflakeTableReference::accountIdentifier))
            .setter(setter(Builder::accountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifier").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(SnowflakeTableReference::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(SnowflakeTableReference::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaName").getter(getter(SnowflakeTableReference::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()).build();

    private static final SdkField<SnowflakeTableSchema> TABLE_SCHEMA_FIELD = SdkField
            .<SnowflakeTableSchema> builder(MarshallingType.SDK_POJO).memberName("tableSchema")
            .getter(getter(SnowflakeTableReference::tableSchema)).setter(setter(Builder::tableSchema))
            .constructor(SnowflakeTableSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            ACCOUNT_IDENTIFIER_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, SCHEMA_NAME_FIELD, TABLE_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String accountIdentifier;

    private final String databaseName;

    private final String tableName;

    private final String schemaName;

    private final SnowflakeTableSchema tableSchema;

    private SnowflakeTableReference(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.accountIdentifier = builder.accountIdentifier;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.schemaName = builder.schemaName;
        this.tableSchema = builder.tableSchema;
    }

    /**
     * <p>
     * The secret ARN of the Snowflake table reference.
     * </p>
     * 
     * @return The secret ARN of the Snowflake table reference.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The account identifier for the Snowflake table reference.
     * </p>
     * 
     * @return The account identifier for the Snowflake table reference.
     */
    public final String accountIdentifier() {
        return accountIdentifier;
    }

    /**
     * <p>
     * The name of the database the Snowflake table belongs to.
     * </p>
     * 
     * @return The name of the database the Snowflake table belongs to.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the Snowflake table.
     * </p>
     * 
     * @return The name of the Snowflake table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The schema name of the Snowflake table reference.
     * </p>
     * 
     * @return The schema name of the Snowflake table reference.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The schema of the Snowflake table.
     * </p>
     * 
     * @return The schema of the Snowflake table.
     */
    public final SnowflakeTableSchema tableSchema() {
        return tableSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeTableReference)) {
            return false;
        }
        SnowflakeTableReference other = (SnowflakeTableReference) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(accountIdentifier(), other.accountIdentifier())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(schemaName(), other.schemaName()) && Objects.equals(tableSchema(), other.tableSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeTableReference").add("SecretArn", secretArn())
                .add("AccountIdentifier", accountIdentifier()).add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("SchemaName", schemaName()).add("TableSchema", tableSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "accountIdentifier":
            return Optional.ofNullable(clazz.cast(accountIdentifier()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "schemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "tableSchema":
            return Optional.ofNullable(clazz.cast(tableSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("accountIdentifier", ACCOUNT_IDENTIFIER_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("tableSchema", TABLE_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeTableReference, T> g) {
        return obj -> g.apply((SnowflakeTableReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeTableReference> {
        /**
         * <p>
         * The secret ARN of the Snowflake table reference.
         * </p>
         * 
         * @param secretArn
         *        The secret ARN of the Snowflake table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The account identifier for the Snowflake table reference.
         * </p>
         * 
         * @param accountIdentifier
         *        The account identifier for the Snowflake table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifier(String accountIdentifier);

        /**
         * <p>
         * The name of the database the Snowflake table belongs to.
         * </p>
         * 
         * @param databaseName
         *        The name of the database the Snowflake table belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the Snowflake table.
         * </p>
         * 
         * @param tableName
         *        The name of the Snowflake table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The schema name of the Snowflake table reference.
         * </p>
         * 
         * @param schemaName
         *        The schema name of the Snowflake table reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The schema of the Snowflake table.
         * </p>
         * 
         * @param tableSchema
         *        The schema of the Snowflake table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSchema(SnowflakeTableSchema tableSchema);

        /**
         * <p>
         * The schema of the Snowflake table.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeTableSchema.Builder} avoiding
         * the need to create one manually via {@link SnowflakeTableSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeTableSchema.Builder#build()} is called immediately and
         * its result is passed to {@link #tableSchema(SnowflakeTableSchema)}.
         * 
         * @param tableSchema
         *        a consumer that will call methods on {@link SnowflakeTableSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableSchema(SnowflakeTableSchema)
         */
        default Builder tableSchema(Consumer<SnowflakeTableSchema.Builder> tableSchema) {
            return tableSchema(SnowflakeTableSchema.builder().applyMutation(tableSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String accountIdentifier;

        private String databaseName;

        private String tableName;

        private String schemaName;

        private SnowflakeTableSchema tableSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeTableReference model) {
            secretArn(model.secretArn);
            accountIdentifier(model.accountIdentifier);
            databaseName(model.databaseName);
            tableName(model.tableName);
            schemaName(model.schemaName);
            tableSchema(model.tableSchema);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getAccountIdentifier() {
            return accountIdentifier;
        }

        public final void setAccountIdentifier(String accountIdentifier) {
            this.accountIdentifier = accountIdentifier;
        }

        @Override
        public final Builder accountIdentifier(String accountIdentifier) {
            this.accountIdentifier = accountIdentifier;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final SnowflakeTableSchema.Builder getTableSchema() {
            return tableSchema != null ? tableSchema.toBuilder() : null;
        }

        public final void setTableSchema(SnowflakeTableSchema.BuilderImpl tableSchema) {
            this.tableSchema = tableSchema != null ? tableSchema.build() : null;
        }

        @Override
        public final Builder tableSchema(SnowflakeTableSchema tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        @Override
        public SnowflakeTableReference build() {
            return new SnowflakeTableReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
