/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdMappingTableRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateIdMappingTableRequest.Builder, UpdateIdMappingTableRequest> {
    private static final SdkField<String> ID_MAPPING_TABLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idMappingTableIdentifier").getter(getter(UpdateIdMappingTableRequest::idMappingTableIdentifier))
            .setter(setter(Builder::idMappingTableIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idMappingTableIdentifier").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdateIdMappingTableRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateIdMappingTableRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(UpdateIdMappingTableRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ID_MAPPING_TABLE_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String idMappingTableIdentifier;

    private final String membershipIdentifier;

    private final String description;

    private final String kmsKeyArn;

    private UpdateIdMappingTableRequest(BuilderImpl builder) {
        super(builder);
        this.idMappingTableIdentifier = builder.idMappingTableIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The unique identifier of the ID mapping table that you want to update.
     * </p>
     * 
     * @return The unique identifier of the ID mapping table that you want to update.
     */
    public final String idMappingTableIdentifier() {
        return idMappingTableIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the membership that contains the ID mapping table that you want to update.
     * </p>
     * 
     * @return The unique identifier of the membership that contains the ID mapping table that you want to update.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A new description for the ID mapping table.
     * </p>
     * 
     * @return A new description for the ID mapping table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdMappingTableRequest)) {
            return false;
        }
        UpdateIdMappingTableRequest other = (UpdateIdMappingTableRequest) obj;
        return Objects.equals(idMappingTableIdentifier(), other.idMappingTableIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdMappingTableRequest").add("IdMappingTableIdentifier", idMappingTableIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).add("Description", description())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingTableIdentifier":
            return Optional.ofNullable(clazz.cast(idMappingTableIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingTableIdentifier", ID_MAPPING_TABLE_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdMappingTableRequest, T> g) {
        return obj -> g.apply((UpdateIdMappingTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIdMappingTableRequest> {
        /**
         * <p>
         * The unique identifier of the ID mapping table that you want to update.
         * </p>
         * 
         * @param idMappingTableIdentifier
         *        The unique identifier of the ID mapping table that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTableIdentifier(String idMappingTableIdentifier);

        /**
         * <p>
         * The unique identifier of the membership that contains the ID mapping table that you want to update.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique identifier of the membership that contains the ID mapping table that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A new description for the ID mapping table.
         * </p>
         * 
         * @param description
         *        A new description for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String idMappingTableIdentifier;

        private String membershipIdentifier;

        private String description;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdMappingTableRequest model) {
            super(model);
            idMappingTableIdentifier(model.idMappingTableIdentifier);
            membershipIdentifier(model.membershipIdentifier);
            description(model.description);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getIdMappingTableIdentifier() {
            return idMappingTableIdentifier;
        }

        public final void setIdMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
        }

        @Override
        public final Builder idMappingTableIdentifier(String idMappingTableIdentifier) {
            this.idMappingTableIdentifier = idMappingTableIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdMappingTableRequest build() {
            return new UpdateIdMappingTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
