/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalyticsEngine;
import software.amazon.awssdk.services.cleanrooms.model.AutoApprovedChangeType;
import software.amazon.awssdk.services.cleanrooms.model.AutoApprovedChangeTypeListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationJobLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationQueryLogStatus;
import software.amazon.awssdk.services.cleanrooms.model.DataEncryptionMetadata;
import software.amazon.awssdk.services.cleanrooms.model.MemberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Collaboration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Collaboration> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Collaboration.getter(Collaboration::id)).setter(Collaboration.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Collaboration.getter(Collaboration::arn)).setter(Collaboration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Collaboration.getter(Collaboration::name)).setter(Collaboration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Collaboration.getter(Collaboration::description)).setter(Collaboration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(Collaboration.getter(Collaboration::creatorAccountId)).setter(Collaboration.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final SdkField<String> CREATOR_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorDisplayName").getter(Collaboration.getter(Collaboration::creatorDisplayName)).setter(Collaboration.setter(Builder::creatorDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorDisplayName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(Collaboration.getter(Collaboration::createTime)).setter(Collaboration.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(Collaboration.getter(Collaboration::updateTime)).setter(Collaboration.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> MEMBER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberStatus").getter(Collaboration.getter(Collaboration::memberStatusAsString)).setter(Collaboration.setter(Builder::memberStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberStatus").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(Collaboration.getter(Collaboration::membershipId)).setter(Collaboration.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(Collaboration.getter(Collaboration::membershipArn)).setter(Collaboration.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<DataEncryptionMetadata> DATA_ENCRYPTION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataEncryptionMetadata").getter(Collaboration.getter(Collaboration::dataEncryptionMetadata)).setter(Collaboration.setter(Builder::dataEncryptionMetadata)).constructor(DataEncryptionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataEncryptionMetadata").build()}).build();
    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLogStatus").getter(Collaboration.getter(Collaboration::queryLogStatusAsString)).setter(Collaboration.setter(Builder::queryLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()}).build();
    private static final SdkField<String> JOB_LOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobLogStatus").getter(Collaboration.getter(Collaboration::jobLogStatusAsString)).setter(Collaboration.setter(Builder::jobLogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLogStatus").build()}).build();
    private static final SdkField<String> ANALYTICS_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyticsEngine").getter(Collaboration.getter(Collaboration::analyticsEngineAsString)).setter(Collaboration.setter(Builder::analyticsEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyticsEngine").build()}).build();
    private static final SdkField<List<String>> AUTO_APPROVED_CHANGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoApprovedChangeTypes").getter(Collaboration.getter(Collaboration::autoApprovedChangeTypesAsStrings)).setter(Collaboration.setter(Builder::autoApprovedChangeTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoApprovedChangeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATOR_ACCOUNT_ID_FIELD, CREATOR_DISPLAY_NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBER_STATUS_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, DATA_ENCRYPTION_METADATA_FIELD, QUERY_LOG_STATUS_FIELD, JOB_LOG_STATUS_FIELD, ANALYTICS_ENGINE_FIELD, AUTO_APPROVED_CHANGE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collaboration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final String creatorAccountId;
    private final String creatorDisplayName;
    private final Instant createTime;
    private final Instant updateTime;
    private final String memberStatus;
    private final String membershipId;
    private final String membershipArn;
    private final DataEncryptionMetadata dataEncryptionMetadata;
    private final String queryLogStatus;
    private final String jobLogStatus;
    private final String analyticsEngine;
    private final List<String> autoApprovedChangeTypes;

    private Collaboration(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.creatorAccountId = builder.creatorAccountId;
        this.creatorDisplayName = builder.creatorDisplayName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.memberStatus = builder.memberStatus;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.dataEncryptionMetadata = builder.dataEncryptionMetadata;
        this.queryLogStatus = builder.queryLogStatus;
        this.jobLogStatus = builder.jobLogStatus;
        this.analyticsEngine = builder.analyticsEngine;
        this.autoApprovedChangeTypes = builder.autoApprovedChangeTypes;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final String creatorDisplayName() {
        return this.creatorDisplayName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final MemberStatus memberStatus() {
        return MemberStatus.fromValue(this.memberStatus);
    }

    public final String memberStatusAsString() {
        return this.memberStatus;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final DataEncryptionMetadata dataEncryptionMetadata() {
        return this.dataEncryptionMetadata;
    }

    public final CollaborationQueryLogStatus queryLogStatus() {
        return CollaborationQueryLogStatus.fromValue(this.queryLogStatus);
    }

    public final String queryLogStatusAsString() {
        return this.queryLogStatus;
    }

    public final CollaborationJobLogStatus jobLogStatus() {
        return CollaborationJobLogStatus.fromValue(this.jobLogStatus);
    }

    public final String jobLogStatusAsString() {
        return this.jobLogStatus;
    }

    public final AnalyticsEngine analyticsEngine() {
        return AnalyticsEngine.fromValue(this.analyticsEngine);
    }

    public final String analyticsEngineAsString() {
        return this.analyticsEngine;
    }

    public final List<AutoApprovedChangeType> autoApprovedChangeTypes() {
        return AutoApprovedChangeTypeListCopier.copyStringToEnum(this.autoApprovedChangeTypes);
    }

    public final boolean hasAutoApprovedChangeTypes() {
        return this.autoApprovedChangeTypes != null && !(this.autoApprovedChangeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> autoApprovedChangeTypesAsStrings() {
        return this.autoApprovedChangeTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncryptionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsEngineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoApprovedChangeTypes() ? this.autoApprovedChangeTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collaboration)) {
            return false;
        }
        Collaboration other = (Collaboration)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.creatorDisplayName(), other.creatorDisplayName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.memberStatusAsString(), other.memberStatusAsString()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.dataEncryptionMetadata(), other.dataEncryptionMetadata()) && Objects.equals(this.queryLogStatusAsString(), other.queryLogStatusAsString()) && Objects.equals(this.jobLogStatusAsString(), other.jobLogStatusAsString()) && Objects.equals(this.analyticsEngineAsString(), other.analyticsEngineAsString()) && this.hasAutoApprovedChangeTypes() == other.hasAutoApprovedChangeTypes() && Objects.equals(this.autoApprovedChangeTypesAsStrings(), other.autoApprovedChangeTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Collaboration").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("CreatorDisplayName", (Object)this.creatorDisplayName()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MemberStatus", (Object)this.memberStatusAsString()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("DataEncryptionMetadata", (Object)this.dataEncryptionMetadata()).add("QueryLogStatus", (Object)this.queryLogStatusAsString()).add("JobLogStatus", (Object)this.jobLogStatusAsString()).add("AnalyticsEngine", (Object)this.analyticsEngineAsString()).add("AutoApprovedChangeTypes", this.hasAutoApprovedChangeTypes() ? this.autoApprovedChangeTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "creatorDisplayName": {
                return Optional.ofNullable(clazz.cast(this.creatorDisplayName()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "memberStatus": {
                return Optional.ofNullable(clazz.cast(this.memberStatusAsString()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "dataEncryptionMetadata": {
                return Optional.ofNullable(clazz.cast(this.dataEncryptionMetadata()));
            }
            case "queryLogStatus": {
                return Optional.ofNullable(clazz.cast(this.queryLogStatusAsString()));
            }
            case "jobLogStatus": {
                return Optional.ofNullable(clazz.cast(this.jobLogStatusAsString()));
            }
            case "analyticsEngine": {
                return Optional.ofNullable(clazz.cast(this.analyticsEngineAsString()));
            }
            case "autoApprovedChangeTypes": {
                return Optional.ofNullable(clazz.cast(this.autoApprovedChangeTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("creatorDisplayName", CREATOR_DISPLAY_NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("memberStatus", MEMBER_STATUS_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("dataEncryptionMetadata", DATA_ENCRYPTION_METADATA_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("jobLogStatus", JOB_LOG_STATUS_FIELD);
        map.put("analyticsEngine", ANALYTICS_ENGINE_FIELD);
        map.put("autoApprovedChangeTypes", AUTO_APPROVED_CHANGE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Collaboration, T> g) {
        return obj -> g.apply((Collaboration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private String creatorAccountId;
        private String creatorDisplayName;
        private Instant createTime;
        private Instant updateTime;
        private String memberStatus;
        private String membershipId;
        private String membershipArn;
        private DataEncryptionMetadata dataEncryptionMetadata;
        private String queryLogStatus;
        private String jobLogStatus;
        private String analyticsEngine;
        private List<String> autoApprovedChangeTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Collaboration model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.creatorAccountId(model.creatorAccountId);
            this.creatorDisplayName(model.creatorDisplayName);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.memberStatus(model.memberStatus);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.dataEncryptionMetadata(model.dataEncryptionMetadata);
            this.queryLogStatus(model.queryLogStatus);
            this.jobLogStatus(model.jobLogStatus);
            this.analyticsEngine(model.analyticsEngine);
            this.autoApprovedChangeTypesWithStrings(model.autoApprovedChangeTypes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getCreatorDisplayName() {
            return this.creatorDisplayName;
        }

        public final void setCreatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
        }

        @Override
        public final Builder creatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMemberStatus() {
            return this.memberStatus;
        }

        public final void setMemberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
        }

        @Override
        public final Builder memberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        @Override
        public final Builder memberStatus(MemberStatus memberStatus) {
            this.memberStatus(memberStatus == null ? null : memberStatus.toString());
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final DataEncryptionMetadata.Builder getDataEncryptionMetadata() {
            return this.dataEncryptionMetadata != null ? this.dataEncryptionMetadata.toBuilder() : null;
        }

        public final void setDataEncryptionMetadata(DataEncryptionMetadata.BuilderImpl dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata != null ? dataEncryptionMetadata.build() : null;
        }

        @Override
        public final Builder dataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        public final String getQueryLogStatus() {
            return this.queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(CollaborationQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final String getJobLogStatus() {
            return this.jobLogStatus;
        }

        public final void setJobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
        }

        @Override
        public final Builder jobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        @Override
        public final Builder jobLogStatus(CollaborationJobLogStatus jobLogStatus) {
            this.jobLogStatus(jobLogStatus == null ? null : jobLogStatus.toString());
            return this;
        }

        public final String getAnalyticsEngine() {
            return this.analyticsEngine;
        }

        public final void setAnalyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
        }

        @Override
        public final Builder analyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        @Override
        public final Builder analyticsEngine(AnalyticsEngine analyticsEngine) {
            this.analyticsEngine(analyticsEngine == null ? null : analyticsEngine.toString());
            return this;
        }

        public final Collection<String> getAutoApprovedChangeTypes() {
            if (this.autoApprovedChangeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoApprovedChangeTypes;
        }

        public final void setAutoApprovedChangeTypes(Collection<String> autoApprovedChangeTypes) {
            this.autoApprovedChangeTypes = AutoApprovedChangeTypeListCopier.copy(autoApprovedChangeTypes);
        }

        @Override
        public final Builder autoApprovedChangeTypesWithStrings(Collection<String> autoApprovedChangeTypes) {
            this.autoApprovedChangeTypes = AutoApprovedChangeTypeListCopier.copy(autoApprovedChangeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoApprovedChangeTypesWithStrings(String ... autoApprovedChangeTypes) {
            this.autoApprovedChangeTypesWithStrings(Arrays.asList(autoApprovedChangeTypes));
            return this;
        }

        @Override
        public final Builder autoApprovedChangeTypes(Collection<AutoApprovedChangeType> autoApprovedChangeTypes) {
            this.autoApprovedChangeTypes = AutoApprovedChangeTypeListCopier.copyEnumToString(autoApprovedChangeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoApprovedChangeTypes(AutoApprovedChangeType ... autoApprovedChangeTypes) {
            this.autoApprovedChangeTypes(Arrays.asList(autoApprovedChangeTypes));
            return this;
        }

        public Collaboration build() {
            return new Collaboration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Collaboration> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder creatorAccountId(String var1);

        public Builder creatorDisplayName(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder memberStatus(String var1);

        public Builder memberStatus(MemberStatus var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder dataEncryptionMetadata(DataEncryptionMetadata var1);

        default public Builder dataEncryptionMetadata(Consumer<DataEncryptionMetadata.Builder> dataEncryptionMetadata) {
            return this.dataEncryptionMetadata((DataEncryptionMetadata)((DataEncryptionMetadata.Builder)DataEncryptionMetadata.builder().applyMutation(dataEncryptionMetadata)).build());
        }

        public Builder queryLogStatus(String var1);

        public Builder queryLogStatus(CollaborationQueryLogStatus var1);

        public Builder jobLogStatus(String var1);

        public Builder jobLogStatus(CollaborationJobLogStatus var1);

        public Builder analyticsEngine(String var1);

        public Builder analyticsEngine(AnalyticsEngine var1);

        public Builder autoApprovedChangeTypesWithStrings(Collection<String> var1);

        public Builder autoApprovedChangeTypesWithStrings(String ... var1);

        public Builder autoApprovedChangeTypes(Collection<AutoApprovedChangeType> var1);

        public Builder autoApprovedChangeTypes(AutoApprovedChangeType ... var1);
    }
}

