/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationChangeRequestsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationChangeRequestsResponse;

public class ListCollaborationChangeRequestsPublisher
implements SdkPublisher<ListCollaborationChangeRequestsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationChangeRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationChangeRequestsPublisher(CleanRoomsAsyncClient client, ListCollaborationChangeRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationChangeRequestsPublisher(CleanRoomsAsyncClient client, ListCollaborationChangeRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationChangeRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationChangeRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries() {
        Function<ListCollaborationChangeRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationChangeRequestSummaries() != null) {
                return response.collaborationChangeRequestSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationChangeRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationChangeRequestsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationChangeRequestsResponse> {
        private ListCollaborationChangeRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationChangeRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationChangeRequestsResponse> nextPage(ListCollaborationChangeRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationChangeRequestsPublisher.this.client.listCollaborationChangeRequests(ListCollaborationChangeRequestsPublisher.this.firstRequest);
            }
            return ListCollaborationChangeRequestsPublisher.this.client.listCollaborationChangeRequests((ListCollaborationChangeRequestsRequest)((Object)ListCollaborationChangeRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

