/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls and tracks usage limits for associated configured tables within a collaboration across queries and job.
 * Supports both period-based budgets that can renew (daily, weekly, or monthly) and fixed lifetime budgets. Contains
 * the resource ARN, remaining budget information, and up to two budget configurations (period-based and lifetime). By
 * default, table usage is unlimited unless a budget is configured.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessBudget implements SdkPojo, Serializable, ToCopyableBuilder<AccessBudget.Builder, AccessBudget> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(AccessBudget::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<List<AccessBudgetDetails>> DETAILS_FIELD = SdkField
            .<List<AccessBudgetDetails>> builder(MarshallingType.LIST)
            .memberName("details")
            .getter(getter(AccessBudget::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessBudgetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessBudgetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> AGGREGATE_REMAINING_BUDGET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("aggregateRemainingBudget").getter(getter(AccessBudget::aggregateRemainingBudget))
            .setter(setter(Builder::aggregateRemainingBudget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateRemainingBudget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            DETAILS_FIELD, AGGREGATE_REMAINING_BUDGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final List<AccessBudgetDetails> details;

    private final Integer aggregateRemainingBudget;

    private AccessBudget(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.details = builder.details;
        this.aggregateRemainingBudget = builder.aggregateRemainingBudget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access budget resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access budget resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed budget information including time bounds, remaining budget, and refresh settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Detailed budget information including time bounds, remaining budget, and refresh settings.
     */
    public final List<AccessBudgetDetails> details() {
        return details;
    }

    /**
     * <p>
     * The total remaining budget across all budget parameters, showing the lower value between the per-period budget
     * and lifetime budget for this access budget. For individual parameter budgets, see <code>remainingBudget</code>.
     * </p>
     * 
     * @return The total remaining budget across all budget parameters, showing the lower value between the per-period
     *         budget and lifetime budget for this access budget. For individual parameter budgets, see
     *         <code>remainingBudget</code>.
     */
    public final Integer aggregateRemainingBudget() {
        return aggregateRemainingBudget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregateRemainingBudget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudget)) {
            return false;
        }
        AccessBudget other = (AccessBudget) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details())
                && Objects.equals(aggregateRemainingBudget(), other.aggregateRemainingBudget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessBudget").add("ResourceArn", resourceArn()).add("Details", hasDetails() ? details() : null)
                .add("AggregateRemainingBudget", aggregateRemainingBudget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "aggregateRemainingBudget":
            return Optional.ofNullable(clazz.cast(aggregateRemainingBudget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("aggregateRemainingBudget", AGGREGATE_REMAINING_BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudget, T> g) {
        return obj -> g.apply((AccessBudget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessBudget> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access budget resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the access budget resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Detailed budget information including time bounds, remaining budget, and refresh settings.
         * </p>
         * 
         * @param details
         *        Detailed budget information including time bounds, remaining budget, and refresh settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<AccessBudgetDetails> details);

        /**
         * <p>
         * Detailed budget information including time bounds, remaining budget, and refresh settings.
         * </p>
         * 
         * @param details
         *        Detailed budget information including time bounds, remaining budget, and refresh settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(AccessBudgetDetails... details);

        /**
         * <p>
         * Detailed budget information including time bounds, remaining budget, and refresh settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #details(List<AccessBudgetDetails>)}.
         * 
         * @param details
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AccessBudgetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(java.util.Collection<AccessBudgetDetails>)
         */
        Builder details(Consumer<AccessBudgetDetails.Builder>... details);

        /**
         * <p>
         * The total remaining budget across all budget parameters, showing the lower value between the per-period
         * budget and lifetime budget for this access budget. For individual parameter budgets, see
         * <code>remainingBudget</code>.
         * </p>
         * 
         * @param aggregateRemainingBudget
         *        The total remaining budget across all budget parameters, showing the lower value between the
         *        per-period budget and lifetime budget for this access budget. For individual parameter budgets, see
         *        <code>remainingBudget</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateRemainingBudget(Integer aggregateRemainingBudget);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private List<AccessBudgetDetails> details = DefaultSdkAutoConstructList.getInstance();

        private Integer aggregateRemainingBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudget model) {
            resourceArn(model.resourceArn);
            details(model.details);
            aggregateRemainingBudget(model.aggregateRemainingBudget);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<AccessBudgetDetails.Builder> getDetails() {
            List<AccessBudgetDetails.Builder> result = AccessBudgetDetailsListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<AccessBudgetDetails.BuilderImpl> details) {
            this.details = AccessBudgetDetailsListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<AccessBudgetDetails> details) {
            this.details = AccessBudgetDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(AccessBudgetDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<AccessBudgetDetails.Builder>... details) {
            details(Stream.of(details).map(c -> AccessBudgetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getAggregateRemainingBudget() {
            return aggregateRemainingBudget;
        }

        public final void setAggregateRemainingBudget(Integer aggregateRemainingBudget) {
            this.aggregateRemainingBudget = aggregateRemainingBudget;
        }

        @Override
        public final Builder aggregateRemainingBudget(Integer aggregateRemainingBudget) {
            this.aggregateRemainingBudget = aggregateRemainingBudget;
            return this;
        }

        @Override
        public AccessBudget build() {
            return new AccessBudget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
