/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about an access budget including time bounds, budget allocation, and configuration settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessBudgetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessBudgetDetails.Builder, AccessBudgetDetails> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(AccessBudgetDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(AccessBudgetDetails::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Integer> REMAINING_BUDGET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("remainingBudget").getter(getter(AccessBudgetDetails::remainingBudget))
            .setter(setter(Builder::remainingBudget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remainingBudget").build()).build();

    private static final SdkField<Integer> BUDGET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("budget").getter(getter(AccessBudgetDetails::budget)).setter(setter(Builder::budget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budget").build()).build();

    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("budgetType").getter(getter(AccessBudgetDetails::budgetTypeAsString)).setter(setter(Builder::budgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetType").build()).build();

    private static final SdkField<String> AUTO_REFRESH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoRefresh").getter(getter(AccessBudgetDetails::autoRefreshAsString))
            .setter(setter(Builder::autoRefresh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRefresh").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, REMAINING_BUDGET_FIELD, BUDGET_FIELD, BUDGET_TYPE_FIELD, AUTO_REFRESH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer remainingBudget;

    private final Integer budget;

    private final String budgetType;

    private final String autoRefresh;

    private AccessBudgetDetails(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.remainingBudget = builder.remainingBudget;
        this.budget = builder.budget;
        this.budgetType = builder.budgetType;
        this.autoRefresh = builder.autoRefresh;
    }

    /**
     * <p>
     * The start time for the access budget period.
     * </p>
     * 
     * @return The start time for the access budget period.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the access budget period.
     * </p>
     * 
     * @return The end time for the access budget period.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The remaining budget amount available for use within this access budget.
     * </p>
     * 
     * @return The remaining budget amount available for use within this access budget.
     */
    public final Integer remainingBudget() {
        return remainingBudget;
    }

    /**
     * <p>
     * The total budget allocation amount for this access budget.
     * </p>
     * 
     * @return The total budget allocation amount for this access budget.
     */
    public final Integer budget() {
        return budget;
    }

    /**
     * <p>
     * Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the budget
     * can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage throughout the
     * collaboration. Valid values are:
     * </p>
     * <p>
     * <code>CALENDAR_DAY</code> - Limit table usage per day.
     * </p>
     * <p>
     * <code>CALENDAR_WEEK</code> - Limit table usage per week.
     * </p>
     * <p>
     * <code>CALENDAR_MONTH</code> - Limit table usage per month.
     * </p>
     * <p>
     * <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link AccessBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the
     *         budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage
     *         throughout the collaboration. Valid values are:</p>
     *         <p>
     *         <code>CALENDAR_DAY</code> - Limit table usage per day.
     *         </p>
     *         <p>
     *         <code>CALENDAR_WEEK</code> - Limit table usage per week.
     *         </p>
     *         <p>
     *         <code>CALENDAR_MONTH</code> - Limit table usage per month.
     *         </p>
     *         <p>
     *         <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
     * @see AccessBudgetType
     */
    public final AccessBudgetType budgetType() {
        return AccessBudgetType.fromValue(budgetType);
    }

    /**
     * <p>
     * Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the budget
     * can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage throughout the
     * collaboration. Valid values are:
     * </p>
     * <p>
     * <code>CALENDAR_DAY</code> - Limit table usage per day.
     * </p>
     * <p>
     * <code>CALENDAR_WEEK</code> - Limit table usage per week.
     * </p>
     * <p>
     * <code>CALENDAR_MONTH</code> - Limit table usage per month.
     * </p>
     * <p>
     * <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link AccessBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the
     *         budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage
     *         throughout the collaboration. Valid values are:</p>
     *         <p>
     *         <code>CALENDAR_DAY</code> - Limit table usage per day.
     *         </p>
     *         <p>
     *         <code>CALENDAR_WEEK</code> - Limit table usage per week.
     *         </p>
     *         <p>
     *         <code>CALENDAR_MONTH</code> - Limit table usage per month.
     *         </p>
     *         <p>
     *         <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
     * @see AccessBudgetType
     */
    public final String budgetTypeAsString() {
        return budgetType;
    }

    /**
     * <p>
     * Indicates whether the budget automatically refreshes for each time period specified in <code>budgetType</code>.
     * Valid values are:
     * </p>
     * <p>
     * <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
     * </p>
     * <p>
     * <code>DISABLED</code> - The budget must be refreshed manually.
     * </p>
     * <p>
     * <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRefresh} will
     * return {@link AutoRefreshMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRefreshAsString}.
     * </p>
     * 
     * @return Indicates whether the budget automatically refreshes for each time period specified in
     *         <code>budgetType</code>. Valid values are:</p>
     *         <p>
     *         <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
     *         </p>
     *         <p>
     *         <code>DISABLED</code> - The budget must be refreshed manually.
     *         </p>
     *         <p>
     *         <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
     * @see AutoRefreshMode
     */
    public final AutoRefreshMode autoRefresh() {
        return AutoRefreshMode.fromValue(autoRefresh);
    }

    /**
     * <p>
     * Indicates whether the budget automatically refreshes for each time period specified in <code>budgetType</code>.
     * Valid values are:
     * </p>
     * <p>
     * <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
     * </p>
     * <p>
     * <code>DISABLED</code> - The budget must be refreshed manually.
     * </p>
     * <p>
     * <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRefresh} will
     * return {@link AutoRefreshMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoRefreshAsString}.
     * </p>
     * 
     * @return Indicates whether the budget automatically refreshes for each time period specified in
     *         <code>budgetType</code>. Valid values are:</p>
     *         <p>
     *         <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
     *         </p>
     *         <p>
     *         <code>DISABLED</code> - The budget must be refreshed manually.
     *         </p>
     *         <p>
     *         <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
     * @see AutoRefreshMode
     */
    public final String autoRefreshAsString() {
        return autoRefresh;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(remainingBudget());
        hashCode = 31 * hashCode + Objects.hashCode(budget());
        hashCode = 31 * hashCode + Objects.hashCode(budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoRefreshAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessBudgetDetails)) {
            return false;
        }
        AccessBudgetDetails other = (AccessBudgetDetails) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(remainingBudget(), other.remainingBudget()) && Objects.equals(budget(), other.budget())
                && Objects.equals(budgetTypeAsString(), other.budgetTypeAsString())
                && Objects.equals(autoRefreshAsString(), other.autoRefreshAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessBudgetDetails").add("StartTime", startTime()).add("EndTime", endTime())
                .add("RemainingBudget", remainingBudget()).add("Budget", budget()).add("BudgetType", budgetTypeAsString())
                .add("AutoRefresh", autoRefreshAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "remainingBudget":
            return Optional.ofNullable(clazz.cast(remainingBudget()));
        case "budget":
            return Optional.ofNullable(clazz.cast(budget()));
        case "budgetType":
            return Optional.ofNullable(clazz.cast(budgetTypeAsString()));
        case "autoRefresh":
            return Optional.ofNullable(clazz.cast(autoRefreshAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("remainingBudget", REMAINING_BUDGET_FIELD);
        map.put("budget", BUDGET_FIELD);
        map.put("budgetType", BUDGET_TYPE_FIELD);
        map.put("autoRefresh", AUTO_REFRESH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessBudgetDetails, T> g) {
        return obj -> g.apply((AccessBudgetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessBudgetDetails> {
        /**
         * <p>
         * The start time for the access budget period.
         * </p>
         * 
         * @param startTime
         *        The start time for the access budget period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the access budget period.
         * </p>
         * 
         * @param endTime
         *        The end time for the access budget period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The remaining budget amount available for use within this access budget.
         * </p>
         * 
         * @param remainingBudget
         *        The remaining budget amount available for use within this access budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingBudget(Integer remainingBudget);

        /**
         * <p>
         * The total budget allocation amount for this access budget.
         * </p>
         * 
         * @param budget
         *        The total budget allocation amount for this access budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budget(Integer budget);

        /**
         * <p>
         * Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the
         * budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage
         * throughout the collaboration. Valid values are:
         * </p>
         * <p>
         * <code>CALENDAR_DAY</code> - Limit table usage per day.
         * </p>
         * <p>
         * <code>CALENDAR_WEEK</code> - Limit table usage per week.
         * </p>
         * <p>
         * <code>CALENDAR_MONTH</code> - Limit table usage per month.
         * </p>
         * <p>
         * <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
         * </p>
         * 
         * @param budgetType
         *        Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods,
         *        the budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total
         *        usage throughout the collaboration. Valid values are:</p>
         *        <p>
         *        <code>CALENDAR_DAY</code> - Limit table usage per day.
         *        </p>
         *        <p>
         *        <code>CALENDAR_WEEK</code> - Limit table usage per week.
         *        </p>
         *        <p>
         *        <code>CALENDAR_MONTH</code> - Limit table usage per month.
         *        </p>
         *        <p>
         *        <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
         * @see AccessBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessBudgetType
         */
        Builder budgetType(String budgetType);

        /**
         * <p>
         * Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods, the
         * budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total usage
         * throughout the collaboration. Valid values are:
         * </p>
         * <p>
         * <code>CALENDAR_DAY</code> - Limit table usage per day.
         * </p>
         * <p>
         * <code>CALENDAR_WEEK</code> - Limit table usage per week.
         * </p>
         * <p>
         * <code>CALENDAR_MONTH</code> - Limit table usage per month.
         * </p>
         * <p>
         * <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
         * </p>
         * 
         * @param budgetType
         *        Specifies the time period for limiting table usage in queries and jobs. For calendar-based periods,
         *        the budget can renew if auto refresh is enabled. For lifetime budgets, the limit applies to the total
         *        usage throughout the collaboration. Valid values are:</p>
         *        <p>
         *        <code>CALENDAR_DAY</code> - Limit table usage per day.
         *        </p>
         *        <p>
         *        <code>CALENDAR_WEEK</code> - Limit table usage per week.
         *        </p>
         *        <p>
         *        <code>CALENDAR_MONTH</code> - Limit table usage per month.
         *        </p>
         *        <p>
         *        <code>LIFETIME</code> - Limit total table usage for the collaboration duration.
         * @see AccessBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessBudgetType
         */
        Builder budgetType(AccessBudgetType budgetType);

        /**
         * <p>
         * Indicates whether the budget automatically refreshes for each time period specified in
         * <code>budgetType</code>. Valid values are:
         * </p>
         * <p>
         * <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
         * </p>
         * <p>
         * <code>DISABLED</code> - The budget must be refreshed manually.
         * </p>
         * <p>
         * <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
         * </p>
         * 
         * @param autoRefresh
         *        Indicates whether the budget automatically refreshes for each time period specified in
         *        <code>budgetType</code>. Valid values are:</p>
         *        <p>
         *        <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
         *        </p>
         *        <p>
         *        <code>DISABLED</code> - The budget must be refreshed manually.
         *        </p>
         *        <p>
         *        <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
         * @see AutoRefreshMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRefreshMode
         */
        Builder autoRefresh(String autoRefresh);

        /**
         * <p>
         * Indicates whether the budget automatically refreshes for each time period specified in
         * <code>budgetType</code>. Valid values are:
         * </p>
         * <p>
         * <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
         * </p>
         * <p>
         * <code>DISABLED</code> - The budget must be refreshed manually.
         * </p>
         * <p>
         * <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
         * </p>
         * 
         * @param autoRefresh
         *        Indicates whether the budget automatically refreshes for each time period specified in
         *        <code>budgetType</code>. Valid values are:</p>
         *        <p>
         *        <code>ENABLED</code> - The budget refreshes automatically at the start of each period.
         *        </p>
         *        <p>
         *        <code>DISABLED</code> - The budget must be refreshed manually.
         *        </p>
         *        <p>
         *        <code>NULL</code> - The value is null when <code>budgetType</code> is set to <code>LIFETIME</code>.
         * @see AutoRefreshMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRefreshMode
         */
        Builder autoRefresh(AutoRefreshMode autoRefresh);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Integer remainingBudget;

        private Integer budget;

        private String budgetType;

        private String autoRefresh;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessBudgetDetails model) {
            startTime(model.startTime);
            endTime(model.endTime);
            remainingBudget(model.remainingBudget);
            budget(model.budget);
            budgetType(model.budgetType);
            autoRefresh(model.autoRefresh);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getRemainingBudget() {
            return remainingBudget;
        }

        public final void setRemainingBudget(Integer remainingBudget) {
            this.remainingBudget = remainingBudget;
        }

        @Override
        public final Builder remainingBudget(Integer remainingBudget) {
            this.remainingBudget = remainingBudget;
            return this;
        }

        public final Integer getBudget() {
            return budget;
        }

        public final void setBudget(Integer budget) {
            this.budget = budget;
        }

        @Override
        public final Builder budget(Integer budget) {
            this.budget = budget;
            return this;
        }

        public final String getBudgetType() {
            return budgetType;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(AccessBudgetType budgetType) {
            this.budgetType(budgetType == null ? null : budgetType.toString());
            return this;
        }

        public final String getAutoRefresh() {
            return autoRefresh;
        }

        public final void setAutoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        @Override
        public final Builder autoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public final Builder autoRefresh(AutoRefreshMode autoRefresh) {
            this.autoRefresh(autoRefresh == null ? null : autoRefresh.toString());
            return this;
        }

        @Override
        public AccessBudgetDetails build() {
            return new AccessBudgetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
