/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the query specifications that can be run on configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRulePolicyV1 implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRulePolicyV1.Builder, AnalysisRulePolicyV1> {
    private static final SdkField<AnalysisRuleList> LIST_FIELD = SdkField.<AnalysisRuleList> builder(MarshallingType.SDK_POJO)
            .memberName("list").getter(getter(AnalysisRulePolicyV1::list)).setter(setter(Builder::list))
            .constructor(AnalysisRuleList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build()).build();

    private static final SdkField<AnalysisRuleAggregation> AGGREGATION_FIELD = SdkField
            .<AnalysisRuleAggregation> builder(MarshallingType.SDK_POJO).memberName("aggregation")
            .getter(getter(AnalysisRulePolicyV1::aggregation)).setter(setter(Builder::aggregation))
            .constructor(AnalysisRuleAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()).build();

    private static final SdkField<AnalysisRuleCustom> CUSTOM_FIELD = SdkField
            .<AnalysisRuleCustom> builder(MarshallingType.SDK_POJO).memberName("custom")
            .getter(getter(AnalysisRulePolicyV1::custom)).setter(setter(Builder::custom))
            .constructor(AnalysisRuleCustom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final SdkField<AnalysisRuleIdMappingTable> ID_MAPPING_TABLE_FIELD = SdkField
            .<AnalysisRuleIdMappingTable> builder(MarshallingType.SDK_POJO).memberName("idMappingTable")
            .getter(getter(AnalysisRulePolicyV1::idMappingTable)).setter(setter(Builder::idMappingTable))
            .constructor(AnalysisRuleIdMappingTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_FIELD, AGGREGATION_FIELD,
            CUSTOM_FIELD, ID_MAPPING_TABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalysisRuleList list;

    private final AnalysisRuleAggregation aggregation;

    private final AnalysisRuleCustom custom;

    private final AnalysisRuleIdMappingTable idMappingTable;

    private final Type type;

    private AnalysisRulePolicyV1(BuilderImpl builder) {
        this.list = builder.list;
        this.aggregation = builder.aggregation;
        this.custom = builder.custom;
        this.idMappingTable = builder.idMappingTable;
        this.type = builder.type;
    }

    /**
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @return Analysis rule type that enables only list queries on a configured table.
     */
    public final AnalysisRuleList list() {
        return list;
    }

    /**
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @return Analysis rule type that enables only aggregation queries on a configured table.
     */
    public final AnalysisRuleAggregation aggregation() {
        return aggregation;
    }

    /**
     * <p>
     * Analysis rule type that enables custom SQL queries on a configured table.
     * </p>
     * 
     * @return Analysis rule type that enables custom SQL queries on a configured table.
     */
    public final AnalysisRuleCustom custom() {
        return custom;
    }

    /**
     * <p>
     * The ID mapping table.
     * </p>
     * 
     * @return The ID mapping table.
     */
    public final AnalysisRuleIdMappingTable idMappingTable() {
        return idMappingTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(list());
        hashCode = 31 * hashCode + Objects.hashCode(aggregation());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRulePolicyV1)) {
            return false;
        }
        AnalysisRulePolicyV1 other = (AnalysisRulePolicyV1) obj;
        return Objects.equals(list(), other.list()) && Objects.equals(aggregation(), other.aggregation())
                && Objects.equals(custom(), other.custom()) && Objects.equals(idMappingTable(), other.idMappingTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRulePolicyV1").add("List", list()).add("Aggregation", aggregation())
                .add("Custom", custom()).add("IdMappingTable", idMappingTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "list":
            return Optional.ofNullable(clazz.cast(list()));
        case "aggregation":
            return Optional.ofNullable(clazz.cast(aggregation()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        case "idMappingTable":
            return Optional.ofNullable(clazz.cast(idMappingTable()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @param list
     *        Analysis rule type that enables only list queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromList(AnalysisRuleList list) {
        return builder().list(list).build();
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @param list
     *        Analysis rule type that enables only list queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromList(Consumer<AnalysisRuleList.Builder> list) {
        AnalysisRuleList.Builder builder = AnalysisRuleList.builder();
        list.accept(builder);
        return fromList(builder.build());
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @param aggregation
     *        Analysis rule type that enables only aggregation queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromAggregation(AnalysisRuleAggregation aggregation) {
        return builder().aggregation(aggregation).build();
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @param aggregation
     *        Analysis rule type that enables only aggregation queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromAggregation(Consumer<AnalysisRuleAggregation.Builder> aggregation) {
        AnalysisRuleAggregation.Builder builder = AnalysisRuleAggregation.builder();
        aggregation.accept(builder);
        return fromAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables custom SQL queries on a configured table.
     * </p>
     * 
     * @param custom
     *        Analysis rule type that enables custom SQL queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromCustom(AnalysisRuleCustom custom) {
        return builder().custom(custom).build();
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables custom SQL queries on a configured table.
     * </p>
     * 
     * @param custom
     *        Analysis rule type that enables custom SQL queries on a configured table.
     */
    public static AnalysisRulePolicyV1 fromCustom(Consumer<AnalysisRuleCustom.Builder> custom) {
        AnalysisRuleCustom.Builder builder = AnalysisRuleCustom.builder();
        custom.accept(builder);
        return fromCustom(builder.build());
    }

    /**
     * Create an instance of this class with {@link #idMappingTable()} initialized to the given value.
     *
     * <p>
     * The ID mapping table.
     * </p>
     * 
     * @param idMappingTable
     *        The ID mapping table.
     */
    public static AnalysisRulePolicyV1 fromIdMappingTable(AnalysisRuleIdMappingTable idMappingTable) {
        return builder().idMappingTable(idMappingTable).build();
    }

    /**
     * Create an instance of this class with {@link #idMappingTable()} initialized to the given value.
     *
     * <p>
     * The ID mapping table.
     * </p>
     * 
     * @param idMappingTable
     *        The ID mapping table.
     */
    public static AnalysisRulePolicyV1 fromIdMappingTable(Consumer<AnalysisRuleIdMappingTable.Builder> idMappingTable) {
        AnalysisRuleIdMappingTable.Builder builder = AnalysisRuleIdMappingTable.builder();
        idMappingTable.accept(builder);
        return fromIdMappingTable(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("list", LIST_FIELD);
        map.put("aggregation", AGGREGATION_FIELD);
        map.put("custom", CUSTOM_FIELD);
        map.put("idMappingTable", ID_MAPPING_TABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRulePolicyV1, T> g) {
        return obj -> g.apply((AnalysisRulePolicyV1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRulePolicyV1> {
        /**
         * <p>
         * Analysis rule type that enables only list queries on a configured table.
         * </p>
         * 
         * @param list
         *        Analysis rule type that enables only list queries on a configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(AnalysisRuleList list);

        /**
         * <p>
         * Analysis rule type that enables only list queries on a configured table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRuleList.Builder} avoiding the
         * need to create one manually via {@link AnalysisRuleList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRuleList.Builder#build()} is called immediately and its
         * result is passed to {@link #list(AnalysisRuleList)}.
         * 
         * @param list
         *        a consumer that will call methods on {@link AnalysisRuleList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(AnalysisRuleList)
         */
        default Builder list(Consumer<AnalysisRuleList.Builder> list) {
            return list(AnalysisRuleList.builder().applyMutation(list).build());
        }

        /**
         * <p>
         * Analysis rule type that enables only aggregation queries on a configured table.
         * </p>
         * 
         * @param aggregation
         *        Analysis rule type that enables only aggregation queries on a configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregation(AnalysisRuleAggregation aggregation);

        /**
         * <p>
         * Analysis rule type that enables only aggregation queries on a configured table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRuleAggregation.Builder} avoiding
         * the need to create one manually via {@link AnalysisRuleAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRuleAggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregation(AnalysisRuleAggregation)}.
         * 
         * @param aggregation
         *        a consumer that will call methods on {@link AnalysisRuleAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregation(AnalysisRuleAggregation)
         */
        default Builder aggregation(Consumer<AnalysisRuleAggregation.Builder> aggregation) {
            return aggregation(AnalysisRuleAggregation.builder().applyMutation(aggregation).build());
        }

        /**
         * <p>
         * Analysis rule type that enables custom SQL queries on a configured table.
         * </p>
         * 
         * @param custom
         *        Analysis rule type that enables custom SQL queries on a configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(AnalysisRuleCustom custom);

        /**
         * <p>
         * Analysis rule type that enables custom SQL queries on a configured table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRuleCustom.Builder} avoiding the
         * need to create one manually via {@link AnalysisRuleCustom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRuleCustom.Builder#build()} is called immediately and its
         * result is passed to {@link #custom(AnalysisRuleCustom)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link AnalysisRuleCustom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(AnalysisRuleCustom)
         */
        default Builder custom(Consumer<AnalysisRuleCustom.Builder> custom) {
            return custom(AnalysisRuleCustom.builder().applyMutation(custom).build());
        }

        /**
         * <p>
         * The ID mapping table.
         * </p>
         * 
         * @param idMappingTable
         *        The ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingTable(AnalysisRuleIdMappingTable idMappingTable);

        /**
         * <p>
         * The ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRuleIdMappingTable.Builder}
         * avoiding the need to create one manually via {@link AnalysisRuleIdMappingTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRuleIdMappingTable.Builder#build()} is called immediately
         * and its result is passed to {@link #idMappingTable(AnalysisRuleIdMappingTable)}.
         * 
         * @param idMappingTable
         *        a consumer that will call methods on {@link AnalysisRuleIdMappingTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingTable(AnalysisRuleIdMappingTable)
         */
        default Builder idMappingTable(Consumer<AnalysisRuleIdMappingTable.Builder> idMappingTable) {
            return idMappingTable(AnalysisRuleIdMappingTable.builder().applyMutation(idMappingTable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalysisRuleList list;

        private AnalysisRuleAggregation aggregation;

        private AnalysisRuleCustom custom;

        private AnalysisRuleIdMappingTable idMappingTable;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRulePolicyV1 model) {
            list(model.list);
            aggregation(model.aggregation);
            custom(model.custom);
            idMappingTable(model.idMappingTable);
        }

        public final AnalysisRuleList.Builder getList() {
            return list != null ? list.toBuilder() : null;
        }

        public final void setList(AnalysisRuleList.BuilderImpl list) {
            Object oldValue = this.list;
            this.list = list != null ? list.build() : null;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
        }

        @Override
        public final Builder list(AnalysisRuleList list) {
            Object oldValue = this.list;
            this.list = list;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
            return this;
        }

        public final AnalysisRuleAggregation.Builder getAggregation() {
            return aggregation != null ? aggregation.toBuilder() : null;
        }

        public final void setAggregation(AnalysisRuleAggregation.BuilderImpl aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation != null ? aggregation.build() : null;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
        }

        @Override
        public final Builder aggregation(AnalysisRuleAggregation aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
            return this;
        }

        public final AnalysisRuleCustom.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(AnalysisRuleCustom.BuilderImpl custom) {
            Object oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(AnalysisRuleCustom custom) {
            Object oldValue = this.custom;
            this.custom = custom;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        public final AnalysisRuleIdMappingTable.Builder getIdMappingTable() {
            return idMappingTable != null ? idMappingTable.toBuilder() : null;
        }

        public final void setIdMappingTable(AnalysisRuleIdMappingTable.BuilderImpl idMappingTable) {
            Object oldValue = this.idMappingTable;
            this.idMappingTable = idMappingTable != null ? idMappingTable.build() : null;
            handleUnionValueChange(Type.ID_MAPPING_TABLE, oldValue, this.idMappingTable);
        }

        @Override
        public final Builder idMappingTable(AnalysisRuleIdMappingTable idMappingTable) {
            Object oldValue = this.idMappingTable;
            this.idMappingTable = idMappingTable;
            handleUnionValueChange(Type.ID_MAPPING_TABLE, oldValue, this.idMappingTable);
            return this;
        }

        @Override
        public AnalysisRulePolicyV1 build() {
            return new AnalysisRulePolicyV1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalysisRulePolicyV1#type()
     */
    public enum Type {
        LIST,

        AGGREGATION,

        CUSTOM,

        ID_MAPPING_TABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
