/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdMappingTableRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateIdMappingTableRequest.Builder, CreateIdMappingTableRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CreateIdMappingTableRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateIdMappingTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateIdMappingTableRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IdMappingTableInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField
            .<IdMappingTableInputReferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inputReferenceConfig")
            .getter(getter(CreateIdMappingTableRequest::inputReferenceConfig)).setter(setter(Builder::inputReferenceConfig))
            .constructor(IdMappingTableInputReferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateIdMappingTableRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateIdMappingTableRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, INPUT_REFERENCE_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String name;

    private final String description;

    private final IdMappingTableInputReferenceConfig inputReferenceConfig;

    private final Map<String, String> tags;

    private final String kmsKeyArn;

    private CreateIdMappingTableRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The unique identifier of the membership that contains the ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the membership that contains the ID mapping table.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A name for the ID mapping table.
     * </p>
     * 
     * @return A name for the ID mapping table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the ID mapping table.
     * </p>
     * 
     * @return A description of the ID mapping table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The input reference configuration needed to create the ID mapping table.
     * </p>
     * 
     * @return The input reference configuration needed to create the ID mapping table.
     */
    public final IdMappingTableInputReferenceConfig inputReferenceConfig() {
        return inputReferenceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key. This value is used to encrypt the mapping
     * table data that is stored by Clean Rooms.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services KMS key. This value is used to encrypt the
     *         mapping table data that is stored by Clean Rooms.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdMappingTableRequest)) {
            return false;
        }
        CreateIdMappingTableRequest other = (CreateIdMappingTableRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(inputReferenceConfig(), other.inputReferenceConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIdMappingTableRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("Name", name()).add("Description", description()).add("InputReferenceConfig", inputReferenceConfig())
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inputReferenceConfig":
            return Optional.ofNullable(clazz.cast(inputReferenceConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputReferenceConfig", INPUT_REFERENCE_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIdMappingTableRequest, T> g) {
        return obj -> g.apply((CreateIdMappingTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIdMappingTableRequest> {
        /**
         * <p>
         * The unique identifier of the membership that contains the ID mapping table.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique identifier of the membership that contains the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A name for the ID mapping table.
         * </p>
         * 
         * @param name
         *        A name for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the ID mapping table.
         * </p>
         * 
         * @param description
         *        A description of the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The input reference configuration needed to create the ID mapping table.
         * </p>
         * 
         * @param inputReferenceConfig
         *        The input reference configuration needed to create the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig);

        /**
         * <p>
         * The input reference configuration needed to create the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdMappingTableInputReferenceConfig.Builder} avoiding the need to create one manually via
         * {@link IdMappingTableInputReferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTableInputReferenceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputReferenceConfig(IdMappingTableInputReferenceConfig)}.
         * 
         * @param inputReferenceConfig
         *        a consumer that will call methods on {@link IdMappingTableInputReferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceConfig(IdMappingTableInputReferenceConfig)
         */
        default Builder inputReferenceConfig(Consumer<IdMappingTableInputReferenceConfig.Builder> inputReferenceConfig) {
            return inputReferenceConfig(IdMappingTableInputReferenceConfig.builder().applyMutation(inputReferenceConfig).build());
        }

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key. This value is used to encrypt the mapping
         * table data that is stored by Clean Rooms.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services KMS key. This value is used to encrypt the
         *        mapping table data that is stored by Clean Rooms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String name;

        private String description;

        private IdMappingTableInputReferenceConfig inputReferenceConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdMappingTableRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            name(model.name);
            description(model.description);
            inputReferenceConfig(model.inputReferenceConfig);
            tags(model.tags);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdMappingTableInputReferenceConfig.Builder getInputReferenceConfig() {
            return inputReferenceConfig != null ? inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdMappingTableInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdMappingTableRequest build() {
            return new CreateIdMappingTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
