/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConfiguredTableAnalysisRuleRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<DeleteConfiguredTableAnalysisRuleRequest.Builder, DeleteConfiguredTableAnalysisRuleRequest> {
    private static final SdkField<String> CONFIGURED_TABLE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableIdentifier")
            .getter(getter(DeleteConfiguredTableAnalysisRuleRequest::configuredTableIdentifier))
            .setter(setter(Builder::configuredTableIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredTableIdentifier").build())
            .build();

    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisRuleType").getter(getter(DeleteConfiguredTableAnalysisRuleRequest::analysisRuleTypeAsString))
            .setter(setter(Builder::analysisRuleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisRuleType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_TABLE_IDENTIFIER_FIELD, ANALYSIS_RULE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configuredTableIdentifier;

    private final String analysisRuleType;

    private DeleteConfiguredTableAnalysisRuleRequest(BuilderImpl builder) {
        super(builder);
        this.configuredTableIdentifier = builder.configuredTableIdentifier;
        this.analysisRuleType = builder.analysisRuleType;
    }

    /**
     * <p>
     * The unique identifier for the configured table that the analysis rule applies to. Currently accepts the
     * configured table ID.
     * </p>
     * 
     * @return The unique identifier for the configured table that the analysis rule applies to. Currently accepts the
     *         configured table ID.
     */
    public final String configuredTableIdentifier() {
        return configuredTableIdentifier;
    }

    /**
     * <p>
     * The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their configured
     * table identifier and analysis rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
     *         configured table identifier and analysis rule type.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final ConfiguredTableAnalysisRuleType analysisRuleType() {
        return ConfiguredTableAnalysisRuleType.fromValue(analysisRuleType);
    }

    /**
     * <p>
     * The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their configured
     * table identifier and analysis rule type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
     *         configured table identifier and analysis rule type.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final String analysisRuleTypeAsString() {
        return analysisRuleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(analysisRuleTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConfiguredTableAnalysisRuleRequest)) {
            return false;
        }
        DeleteConfiguredTableAnalysisRuleRequest other = (DeleteConfiguredTableAnalysisRuleRequest) obj;
        return Objects.equals(configuredTableIdentifier(), other.configuredTableIdentifier())
                && Objects.equals(analysisRuleTypeAsString(), other.analysisRuleTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConfiguredTableAnalysisRuleRequest")
                .add("ConfiguredTableIdentifier", configuredTableIdentifier())
                .add("AnalysisRuleType", analysisRuleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableIdentifier":
            return Optional.ofNullable(clazz.cast(configuredTableIdentifier()));
        case "analysisRuleType":
            return Optional.ofNullable(clazz.cast(analysisRuleTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredTableIdentifier", CONFIGURED_TABLE_IDENTIFIER_FIELD);
        map.put("analysisRuleType", ANALYSIS_RULE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConfiguredTableAnalysisRuleRequest, T> g) {
        return obj -> g.apply((DeleteConfiguredTableAnalysisRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteConfiguredTableAnalysisRuleRequest> {
        /**
         * <p>
         * The unique identifier for the configured table that the analysis rule applies to. Currently accepts the
         * configured table ID.
         * </p>
         * 
         * @param configuredTableIdentifier
         *        The unique identifier for the configured table that the analysis rule applies to. Currently accepts
         *        the configured table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableIdentifier(String configuredTableIdentifier);

        /**
         * <p>
         * The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
         * configured table identifier and analysis rule type.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
         *        configured table identifier and analysis rule type.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder analysisRuleType(String analysisRuleType);

        /**
         * <p>
         * The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
         * configured table identifier and analysis rule type.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type to be deleted. Configured table analysis rules are uniquely identified by their
         *        configured table identifier and analysis rule type.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String configuredTableIdentifier;

        private String analysisRuleType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConfiguredTableAnalysisRuleRequest model) {
            super(model);
            configuredTableIdentifier(model.configuredTableIdentifier);
            analysisRuleType(model.analysisRuleType);
        }

        public final String getConfiguredTableIdentifier() {
            return configuredTableIdentifier;
        }

        public final void setConfiguredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
        }

        @Override
        public final Builder configuredTableIdentifier(String configuredTableIdentifier) {
            this.configuredTableIdentifier = configuredTableIdentifier;
            return this;
        }

        public final String getAnalysisRuleType() {
            return analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(ConfiguredTableAnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConfiguredTableAnalysisRuleRequest build() {
            return new DeleteConfiguredTableAnalysisRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
