/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationIdNamespaceAssociationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetCollaborationIdNamespaceAssociationRequest.Builder, GetCollaborationIdNamespaceAssociationRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(GetCollaborationIdNamespaceAssociationRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceAssociationIdentifier")
            .getter(getter(GetCollaborationIdNamespaceAssociationRequest::idNamespaceAssociationIdentifier))
            .setter(setter(Builder::idNamespaceAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idNamespaceAssociationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String idNamespaceAssociationIdentifier;

    private GetCollaborationIdNamespaceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.idNamespaceAssociationIdentifier = builder.idNamespaceAssociationIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains the ID namespace association that you want to retrieve.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains the ID namespace association that you want to
     *         retrieve.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the ID namespace association that you want to retrieve.
     * </p>
     * 
     * @return The unique identifier of the ID namespace association that you want to retrieve.
     */
    public final String idNamespaceAssociationIdentifier() {
        return idNamespaceAssociationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceAssociationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationIdNamespaceAssociationRequest)) {
            return false;
        }
        GetCollaborationIdNamespaceAssociationRequest other = (GetCollaborationIdNamespaceAssociationRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(idNamespaceAssociationIdentifier(), other.idNamespaceAssociationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationIdNamespaceAssociationRequest")
                .add("CollaborationIdentifier", collaborationIdentifier())
                .add("IdNamespaceAssociationIdentifier", idNamespaceAssociationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "idNamespaceAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(idNamespaceAssociationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("idNamespaceAssociationIdentifier", ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationIdNamespaceAssociationRequest, T> g) {
        return obj -> g.apply((GetCollaborationIdNamespaceAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationIdNamespaceAssociationRequest> {
        /**
         * <p>
         * The unique identifier of the collaboration that contains the ID namespace association that you want to
         * retrieve.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The unique identifier of the collaboration that contains the ID namespace association that you want to
         *        retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The unique identifier of the ID namespace association that you want to retrieve.
         * </p>
         * 
         * @param idNamespaceAssociationIdentifier
         *        The unique identifier of the ID namespace association that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String idNamespaceAssociationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationIdNamespaceAssociationRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            idNamespaceAssociationIdentifier(model.idNamespaceAssociationIdentifier);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getIdNamespaceAssociationIdentifier() {
            return idNamespaceAssociationIdentifier;
        }

        public final void setIdNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier) {
            this.idNamespaceAssociationIdentifier = idNamespaceAssociationIdentifier;
        }

        @Override
        public final Builder idNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier) {
            this.idNamespaceAssociationIdentifier = idNamespaceAssociationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationIdNamespaceAssociationRequest build() {
            return new GetCollaborationIdNamespaceAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
