/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredTableAssociationAnalysisRuleResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<GetConfiguredTableAssociationAnalysisRuleResponse.Builder, GetConfiguredTableAssociationAnalysisRuleResponse> {
    private static final SdkField<ConfiguredTableAssociationAnalysisRule> ANALYSIS_RULE_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRule> builder(MarshallingType.SDK_POJO).memberName("analysisRule")
            .getter(getter(GetConfiguredTableAssociationAnalysisRuleResponse::analysisRule))
            .setter(setter(Builder::analysisRule)).constructor(ConfiguredTableAssociationAnalysisRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConfiguredTableAssociationAnalysisRule analysisRule;

    private GetConfiguredTableAssociationAnalysisRuleResponse(BuilderImpl builder) {
        super(builder);
        this.analysisRule = builder.analysisRule;
    }

    /**
     * <p>
     * The analysis rule for the conﬁgured table association. In the console, the
     * <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <i>collaboration analysis rule</i>.
     * </p>
     * 
     * @return The analysis rule for the conﬁgured table association. In the console, the
     *         <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <i>collaboration analysis
     *         rule</i>.
     */
    public final ConfiguredTableAssociationAnalysisRule analysisRule() {
        return analysisRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredTableAssociationAnalysisRuleResponse)) {
            return false;
        }
        GetConfiguredTableAssociationAnalysisRuleResponse other = (GetConfiguredTableAssociationAnalysisRuleResponse) obj;
        return Objects.equals(analysisRule(), other.analysisRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredTableAssociationAnalysisRuleResponse").add("AnalysisRule", analysisRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisRule":
            return Optional.ofNullable(clazz.cast(analysisRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisRule", ANALYSIS_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredTableAssociationAnalysisRuleResponse, T> g) {
        return obj -> g.apply((GetConfiguredTableAssociationAnalysisRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredTableAssociationAnalysisRuleResponse> {
        /**
         * <p>
         * The analysis rule for the conﬁgured table association. In the console, the
         * <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <i>collaboration analysis rule</i>.
         * </p>
         * 
         * @param analysisRule
         *        The analysis rule for the conﬁgured table association. In the console, the
         *        <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <i>collaboration analysis
         *        rule</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRule(ConfiguredTableAssociationAnalysisRule analysisRule);

        /**
         * <p>
         * The analysis rule for the conﬁgured table association. In the console, the
         * <code>ConfiguredTableAssociationAnalysisRule</code> is referred to as the <i>collaboration analysis rule</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRule.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAssociationAnalysisRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociationAnalysisRule.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisRule(ConfiguredTableAssociationAnalysisRule)}.
         * 
         * @param analysisRule
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisRule(ConfiguredTableAssociationAnalysisRule)
         */
        default Builder analysisRule(Consumer<ConfiguredTableAssociationAnalysisRule.Builder> analysisRule) {
            return analysisRule(ConfiguredTableAssociationAnalysisRule.builder().applyMutation(analysisRule).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private ConfiguredTableAssociationAnalysisRule analysisRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredTableAssociationAnalysisRuleResponse model) {
            super(model);
            analysisRule(model.analysisRule);
        }

        public final ConfiguredTableAssociationAnalysisRule.Builder getAnalysisRule() {
            return analysisRule != null ? analysisRule.toBuilder() : null;
        }

        public final void setAnalysisRule(ConfiguredTableAssociationAnalysisRule.BuilderImpl analysisRule) {
            this.analysisRule = analysisRule != null ? analysisRule.build() : null;
        }

        @Override
        public final Builder analysisRule(ConfiguredTableAssociationAnalysisRule analysisRule) {
            this.analysisRule = analysisRule;
            return this;
        }

        @Override
        public GetConfiguredTableAssociationAnalysisRuleResponse build() {
            return new GetConfiguredTableAssociationAnalysisRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
