/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information about the ID mapping table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingTable implements SdkPojo, Serializable, ToCopyableBuilder<IdMappingTable.Builder, IdMappingTable> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(IdMappingTable::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IdMappingTable::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<IdMappingTableInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField
            .<IdMappingTableInputReferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inputReferenceConfig")
            .getter(getter(IdMappingTable::inputReferenceConfig)).setter(setter(Builder::inputReferenceConfig))
            .constructor(IdMappingTableInputReferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(IdMappingTable::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(IdMappingTable::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(IdMappingTable::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(IdMappingTable::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IdMappingTable::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IdMappingTable::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(IdMappingTable::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(IdMappingTable::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<IdMappingTableInputReferenceProperties> INPUT_REFERENCE_PROPERTIES_FIELD = SdkField
            .<IdMappingTableInputReferenceProperties> builder(MarshallingType.SDK_POJO).memberName("inputReferenceProperties")
            .getter(getter(IdMappingTable::inputReferenceProperties)).setter(setter(Builder::inputReferenceProperties))
            .constructor(IdMappingTableInputReferenceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceProperties").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(IdMappingTable::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            INPUT_REFERENCE_CONFIG_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, COLLABORATION_ID_FIELD,
            COLLABORATION_ARN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            INPUT_REFERENCE_PROPERTIES_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final IdMappingTableInputReferenceConfig inputReferenceConfig;

    private final String membershipId;

    private final String membershipArn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String description;

    private final String name;

    private final Instant createTime;

    private final Instant updateTime;

    private final IdMappingTableInputReferenceProperties inputReferenceProperties;

    private final String kmsKeyArn;

    private IdMappingTable(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.description = builder.description;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.inputReferenceProperties = builder.inputReferenceProperties;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The unique identifier of the ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the ID mapping table.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ID mapping table.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The input reference configuration for the ID mapping table.
     * </p>
     * 
     * @return The input reference configuration for the ID mapping table.
     */
    public final IdMappingTableInputReferenceConfig inputReferenceConfig() {
        return inputReferenceConfig;
    }

    /**
     * <p>
     * The unique identifier of the membership resource for the ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the membership resource for the ID mapping table.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the membership resource for the ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the membership resource for the ID mapping table.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this ID mapping table.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this ID mapping table.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The description of the ID mapping table.
     * </p>
     * 
     * @return The description of the ID mapping table.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the ID mapping table.
     * </p>
     * 
     * @return The name of the ID mapping table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the ID mapping table was created.
     * </p>
     * 
     * @return The time at which the ID mapping table was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the ID mapping table was updated.
     * </p>
     * 
     * @return The most recent time at which the ID mapping table was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The input reference properties for the ID mapping table.
     * </p>
     * 
     * @return The input reference properties for the ID mapping table.
     */
    public final IdMappingTableInputReferenceProperties inputReferenceProperties() {
        return inputReferenceProperties;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingTable)) {
            return false;
        }
        IdMappingTable other = (IdMappingTable) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(inputReferenceConfig(), other.inputReferenceConfig())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(inputReferenceProperties(), other.inputReferenceProperties())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingTable").add("Id", id()).add("Arn", arn())
                .add("InputReferenceConfig", inputReferenceConfig()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CollaborationId", collaborationId())
                .add("CollaborationArn", collaborationArn()).add("Description", description()).add("Name", name())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("InputReferenceProperties", inputReferenceProperties()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "inputReferenceConfig":
            return Optional.ofNullable(clazz.cast(inputReferenceConfig()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "inputReferenceProperties":
            return Optional.ofNullable(clazz.cast(inputReferenceProperties()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("inputReferenceConfig", INPUT_REFERENCE_CONFIG_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("inputReferenceProperties", INPUT_REFERENCE_PROPERTIES_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingTable, T> g) {
        return obj -> g.apply((IdMappingTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingTable> {
        /**
         * <p>
         * The unique identifier of the ID mapping table.
         * </p>
         * 
         * @param id
         *        The unique identifier of the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ID mapping table.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The input reference configuration for the ID mapping table.
         * </p>
         * 
         * @param inputReferenceConfig
         *        The input reference configuration for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig);

        /**
         * <p>
         * The input reference configuration for the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdMappingTableInputReferenceConfig.Builder} avoiding the need to create one manually via
         * {@link IdMappingTableInputReferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTableInputReferenceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputReferenceConfig(IdMappingTableInputReferenceConfig)}.
         * 
         * @param inputReferenceConfig
         *        a consumer that will call methods on {@link IdMappingTableInputReferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceConfig(IdMappingTableInputReferenceConfig)
         */
        default Builder inputReferenceConfig(Consumer<IdMappingTableInputReferenceConfig.Builder> inputReferenceConfig) {
            return inputReferenceConfig(IdMappingTableInputReferenceConfig.builder().applyMutation(inputReferenceConfig).build());
        }

        /**
         * <p>
         * The unique identifier of the membership resource for the ID mapping table.
         * </p>
         * 
         * @param membershipId
         *        The unique identifier of the membership resource for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the membership resource for the ID mapping table.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the membership resource for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this ID mapping table.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
         * </p>
         * 
         * @param collaborationArn
         *        The Amazon Resource Name (ARN) of the collaboration that contains this ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The description of the ID mapping table.
         * </p>
         * 
         * @param description
         *        The description of the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the ID mapping table.
         * </p>
         * 
         * @param name
         *        The name of the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the ID mapping table was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the ID mapping table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the ID mapping table was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the ID mapping table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The input reference properties for the ID mapping table.
         * </p>
         * 
         * @param inputReferenceProperties
         *        The input reference properties for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceProperties(IdMappingTableInputReferenceProperties inputReferenceProperties);

        /**
         * <p>
         * The input reference properties for the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdMappingTableInputReferenceProperties.Builder} avoiding the need to create one manually via
         * {@link IdMappingTableInputReferenceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingTableInputReferenceProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputReferenceProperties(IdMappingTableInputReferenceProperties)}.
         * 
         * @param inputReferenceProperties
         *        a consumer that will call methods on {@link IdMappingTableInputReferenceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceProperties(IdMappingTableInputReferenceProperties)
         */
        default Builder inputReferenceProperties(Consumer<IdMappingTableInputReferenceProperties.Builder> inputReferenceProperties) {
            return inputReferenceProperties(IdMappingTableInputReferenceProperties.builder()
                    .applyMutation(inputReferenceProperties).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private IdMappingTableInputReferenceConfig inputReferenceConfig;

        private String membershipId;

        private String membershipArn;

        private String collaborationId;

        private String collaborationArn;

        private String description;

        private String name;

        private Instant createTime;

        private Instant updateTime;

        private IdMappingTableInputReferenceProperties inputReferenceProperties;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingTable model) {
            id(model.id);
            arn(model.arn);
            inputReferenceConfig(model.inputReferenceConfig);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            description(model.description);
            name(model.name);
            createTime(model.createTime);
            updateTime(model.updateTime);
            inputReferenceProperties(model.inputReferenceProperties);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final IdMappingTableInputReferenceConfig.Builder getInputReferenceConfig() {
            return inputReferenceConfig != null ? inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdMappingTableInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final IdMappingTableInputReferenceProperties.Builder getInputReferenceProperties() {
            return inputReferenceProperties != null ? inputReferenceProperties.toBuilder() : null;
        }

        public final void setInputReferenceProperties(IdMappingTableInputReferenceProperties.BuilderImpl inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties != null ? inputReferenceProperties.build() : null;
        }

        @Override
        public final Builder inputReferenceProperties(IdMappingTableInputReferenceProperties inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public IdMappingTable build() {
            return new IdMappingTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
