/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information to create the ID namespace association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceAssociation.Builder, IdNamespaceAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(IdNamespaceAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IdNamespaceAssociation::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(IdNamespaceAssociation::membershipId))
            .setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(IdNamespaceAssociation::membershipArn))
            .setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(IdNamespaceAssociation::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(IdNamespaceAssociation::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IdNamespaceAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IdNamespaceAssociation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(IdNamespaceAssociation::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(IdNamespaceAssociation::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<IdNamespaceAssociationInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField
            .<IdNamespaceAssociationInputReferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inputReferenceConfig")
            .getter(getter(IdNamespaceAssociation::inputReferenceConfig)).setter(setter(Builder::inputReferenceConfig))
            .constructor(IdNamespaceAssociationInputReferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build())
            .build();

    private static final SdkField<IdNamespaceAssociationInputReferenceProperties> INPUT_REFERENCE_PROPERTIES_FIELD = SdkField
            .<IdNamespaceAssociationInputReferenceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("inputReferenceProperties").getter(getter(IdNamespaceAssociation::inputReferenceProperties))
            .setter(setter(Builder::inputReferenceProperties))
            .constructor(IdNamespaceAssociationInputReferenceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceProperties").build())
            .build();

    private static final SdkField<IdMappingConfig> ID_MAPPING_CONFIG_FIELD = SdkField
            .<IdMappingConfig> builder(MarshallingType.SDK_POJO).memberName("idMappingConfig")
            .getter(getter(IdNamespaceAssociation::idMappingConfig)).setter(setter(Builder::idMappingConfig))
            .constructor(IdMappingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, INPUT_REFERENCE_CONFIG_FIELD,
            INPUT_REFERENCE_PROPERTIES_FIELD, ID_MAPPING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String membershipId;

    private final String membershipArn;

    private final String collaborationId;

    private final String collaborationArn;

    private final String name;

    private final String description;

    private final Instant createTime;

    private final Instant updateTime;

    private final IdNamespaceAssociationInputReferenceConfig inputReferenceConfig;

    private final IdNamespaceAssociationInputReferenceProperties inputReferenceProperties;

    private final IdMappingConfig idMappingConfig;

    private IdNamespaceAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationArn = builder.collaborationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.inputReferenceProperties = builder.inputReferenceProperties;
        this.idMappingConfig = builder.idMappingConfig;
    }

    /**
     * <p>
     * The unique identifier for this ID namespace association.
     * </p>
     * 
     * @return The unique identifier for this ID namespace association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ID namespace association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ID namespace association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the membership resource for this ID namespace association.
     * </p>
     * 
     * @return The unique identifier of the membership resource for this ID namespace association.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The unique identifier of the collaboration that contains this ID namespace association.
     * </p>
     * 
     * @return The unique identifier of the collaboration that contains this ID namespace association.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The name of this ID namespace association.
     * </p>
     * 
     * @return The name of this ID namespace association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the ID namespace association.
     * </p>
     * 
     * @return The description of the ID namespace association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the ID namespace association was created.
     * </p>
     * 
     * @return The time at which the ID namespace association was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the ID namespace association was updated.
     * </p>
     * 
     * @return The most recent time at which the ID namespace association was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The input reference configuration for the ID namespace association.
     * </p>
     * 
     * @return The input reference configuration for the ID namespace association.
     */
    public final IdNamespaceAssociationInputReferenceConfig inputReferenceConfig() {
        return inputReferenceConfig;
    }

    /**
     * <p>
     * The input reference properties for the ID namespace association.
     * </p>
     * 
     * @return The input reference properties for the ID namespace association.
     */
    public final IdNamespaceAssociationInputReferenceProperties inputReferenceProperties() {
        return inputReferenceProperties;
    }

    /**
     * <p>
     * The configuration settings for the ID mapping table.
     * </p>
     * 
     * @return The configuration settings for the ID mapping table.
     */
    public final IdMappingConfig idMappingConfig() {
        return idMappingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(idMappingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceAssociation)) {
            return false;
        }
        IdNamespaceAssociation other = (IdNamespaceAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(membershipId(), other.membershipId()) && Objects.equals(membershipArn(), other.membershipArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationArn(), other.collaborationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(inputReferenceConfig(), other.inputReferenceConfig())
                && Objects.equals(inputReferenceProperties(), other.inputReferenceProperties())
                && Objects.equals(idMappingConfig(), other.idMappingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceAssociation").add("Id", id()).add("Arn", arn()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CollaborationId", collaborationId())
                .add("CollaborationArn", collaborationArn()).add("Name", name()).add("Description", description())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("InputReferenceConfig", inputReferenceConfig()).add("InputReferenceProperties", inputReferenceProperties())
                .add("IdMappingConfig", idMappingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "inputReferenceConfig":
            return Optional.ofNullable(clazz.cast(inputReferenceConfig()));
        case "inputReferenceProperties":
            return Optional.ofNullable(clazz.cast(inputReferenceProperties()));
        case "idMappingConfig":
            return Optional.ofNullable(clazz.cast(idMappingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("inputReferenceConfig", INPUT_REFERENCE_CONFIG_FIELD);
        map.put("inputReferenceProperties", INPUT_REFERENCE_PROPERTIES_FIELD);
        map.put("idMappingConfig", ID_MAPPING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceAssociation, T> g) {
        return obj -> g.apply((IdNamespaceAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceAssociation> {
        /**
         * <p>
         * The unique identifier for this ID namespace association.
         * </p>
         * 
         * @param id
         *        The unique identifier for this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ID namespace association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the membership resource for this ID namespace association.
         * </p>
         * 
         * @param membershipId
         *        The unique identifier of the membership resource for this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
         * </p>
         * 
         * @param membershipArn
         *        The Amazon Resource Name (ARN) of the membership resource for this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The unique identifier of the collaboration that contains this ID namespace association.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier of the collaboration that contains this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
         * </p>
         * 
         * @param collaborationArn
         *        The Amazon Resource Name (ARN) of the collaboration that contains this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The name of this ID namespace association.
         * </p>
         * 
         * @param name
         *        The name of this ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the ID namespace association.
         * </p>
         * 
         * @param description
         *        The description of the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the ID namespace association was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the ID namespace association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the ID namespace association was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the ID namespace association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The input reference configuration for the ID namespace association.
         * </p>
         * 
         * @param inputReferenceConfig
         *        The input reference configuration for the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig inputReferenceConfig);

        /**
         * <p>
         * The input reference configuration for the ID namespace association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdNamespaceAssociationInputReferenceConfig.Builder} avoiding the need to create one manually via
         * {@link IdNamespaceAssociationInputReferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdNamespaceAssociationInputReferenceConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig)}.
         * 
         * @param inputReferenceConfig
         *        a consumer that will call methods on {@link IdNamespaceAssociationInputReferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig)
         */
        default Builder inputReferenceConfig(Consumer<IdNamespaceAssociationInputReferenceConfig.Builder> inputReferenceConfig) {
            return inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig.builder().applyMutation(inputReferenceConfig)
                    .build());
        }

        /**
         * <p>
         * The input reference properties for the ID namespace association.
         * </p>
         * 
         * @param inputReferenceProperties
         *        The input reference properties for the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceProperties(IdNamespaceAssociationInputReferenceProperties inputReferenceProperties);

        /**
         * <p>
         * The input reference properties for the ID namespace association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IdNamespaceAssociationInputReferenceProperties.Builder} avoiding the need to create one manually via
         * {@link IdNamespaceAssociationInputReferenceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdNamespaceAssociationInputReferenceProperties.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #inputReferenceProperties(IdNamespaceAssociationInputReferenceProperties)}.
         * 
         * @param inputReferenceProperties
         *        a consumer that will call methods on {@link IdNamespaceAssociationInputReferenceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputReferenceProperties(IdNamespaceAssociationInputReferenceProperties)
         */
        default Builder inputReferenceProperties(
                Consumer<IdNamespaceAssociationInputReferenceProperties.Builder> inputReferenceProperties) {
            return inputReferenceProperties(IdNamespaceAssociationInputReferenceProperties.builder()
                    .applyMutation(inputReferenceProperties).build());
        }

        /**
         * <p>
         * The configuration settings for the ID mapping table.
         * </p>
         * 
         * @param idMappingConfig
         *        The configuration settings for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingConfig(IdMappingConfig idMappingConfig);

        /**
         * <p>
         * The configuration settings for the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdMappingConfig.Builder} avoiding the
         * need to create one manually via {@link IdMappingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #idMappingConfig(IdMappingConfig)}.
         * 
         * @param idMappingConfig
         *        a consumer that will call methods on {@link IdMappingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingConfig(IdMappingConfig)
         */
        default Builder idMappingConfig(Consumer<IdMappingConfig.Builder> idMappingConfig) {
            return idMappingConfig(IdMappingConfig.builder().applyMutation(idMappingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String membershipId;

        private String membershipArn;

        private String collaborationId;

        private String collaborationArn;

        private String name;

        private String description;

        private Instant createTime;

        private Instant updateTime;

        private IdNamespaceAssociationInputReferenceConfig inputReferenceConfig;

        private IdNamespaceAssociationInputReferenceProperties inputReferenceProperties;

        private IdMappingConfig idMappingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceAssociation model) {
            id(model.id);
            arn(model.arn);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            collaborationId(model.collaborationId);
            collaborationArn(model.collaborationArn);
            name(model.name);
            description(model.description);
            createTime(model.createTime);
            updateTime(model.updateTime);
            inputReferenceConfig(model.inputReferenceConfig);
            inputReferenceProperties(model.inputReferenceProperties);
            idMappingConfig(model.idMappingConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final IdNamespaceAssociationInputReferenceConfig.Builder getInputReferenceConfig() {
            return inputReferenceConfig != null ? inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdNamespaceAssociationInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdNamespaceAssociationInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final IdNamespaceAssociationInputReferenceProperties.Builder getInputReferenceProperties() {
            return inputReferenceProperties != null ? inputReferenceProperties.toBuilder() : null;
        }

        public final void setInputReferenceProperties(
                IdNamespaceAssociationInputReferenceProperties.BuilderImpl inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties != null ? inputReferenceProperties.build() : null;
        }

        @Override
        public final Builder inputReferenceProperties(IdNamespaceAssociationInputReferenceProperties inputReferenceProperties) {
            this.inputReferenceProperties = inputReferenceProperties;
            return this;
        }

        public final IdMappingConfig.Builder getIdMappingConfig() {
            return idMappingConfig != null ? idMappingConfig.toBuilder() : null;
        }

        public final void setIdMappingConfig(IdMappingConfig.BuilderImpl idMappingConfig) {
            this.idMappingConfig = idMappingConfig != null ? idMappingConfig.build() : null;
        }

        @Override
        public final Builder idMappingConfig(IdMappingConfig idMappingConfig) {
            this.idMappingConfig = idMappingConfig;
            return this;
        }

        @Override
        public IdNamespaceAssociation build() {
            return new IdNamespaceAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
