/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationChangeRequestsResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListCollaborationChangeRequestsResponse.Builder, ListCollaborationChangeRequestsResponse> {
    private static final SdkField<List<CollaborationChangeRequestSummary>> COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD = SdkField
            .<List<CollaborationChangeRequestSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationChangeRequestSummaries")
            .getter(getter(ListCollaborationChangeRequestsResponse::collaborationChangeRequestSummaries))
            .setter(setter(Builder::collaborationChangeRequestSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationChangeRequestSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationChangeRequestSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationChangeRequestSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationChangeRequestsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries;

    private final String nextToken;

    private ListCollaborationChangeRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationChangeRequestSummaries = builder.collaborationChangeRequestSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationChangeRequestSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationChangeRequestSummaries() {
        return collaborationChangeRequestSummaries != null
                && !(collaborationChangeRequestSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of collaboration change request summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationChangeRequestSummaries}
     * method.
     * </p>
     * 
     * @return The list of collaboration change request summaries.
     */
    public final List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries() {
        return collaborationChangeRequestSummaries;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCollaborationChangeRequestSummaries() ? collaborationChangeRequestSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationChangeRequestsResponse)) {
            return false;
        }
        ListCollaborationChangeRequestsResponse other = (ListCollaborationChangeRequestsResponse) obj;
        return hasCollaborationChangeRequestSummaries() == other.hasCollaborationChangeRequestSummaries()
                && Objects.equals(collaborationChangeRequestSummaries(), other.collaborationChangeRequestSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationChangeRequestsResponse")
                .add("CollaborationChangeRequestSummaries",
                        hasCollaborationChangeRequestSummaries() ? collaborationChangeRequestSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationChangeRequestSummaries":
            return Optional.ofNullable(clazz.cast(collaborationChangeRequestSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationChangeRequestSummaries", COLLABORATION_CHANGE_REQUEST_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationChangeRequestsResponse, T> g) {
        return obj -> g.apply((ListCollaborationChangeRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationChangeRequestsResponse> {
        /**
         * <p>
         * The list of collaboration change request summaries.
         * </p>
         * 
         * @param collaborationChangeRequestSummaries
         *        The list of collaboration change request summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationChangeRequestSummaries(
                Collection<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries);

        /**
         * <p>
         * The list of collaboration change request summaries.
         * </p>
         * 
         * @param collaborationChangeRequestSummaries
         *        The list of collaboration change request summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationChangeRequestSummaries(CollaborationChangeRequestSummary... collaborationChangeRequestSummaries);

        /**
         * <p>
         * The list of collaboration change request summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #collaborationChangeRequestSummaries(List<CollaborationChangeRequestSummary>)}.
         * 
         * @param collaborationChangeRequestSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationChangeRequestSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationChangeRequestSummaries(java.util.Collection<CollaborationChangeRequestSummary>)
         */
        Builder collaborationChangeRequestSummaries(
                Consumer<CollaborationChangeRequestSummary.Builder>... collaborationChangeRequestSummaries);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationChangeRequestsResponse model) {
            super(model);
            collaborationChangeRequestSummaries(model.collaborationChangeRequestSummaries);
            nextToken(model.nextToken);
        }

        public final List<CollaborationChangeRequestSummary.Builder> getCollaborationChangeRequestSummaries() {
            List<CollaborationChangeRequestSummary.Builder> result = CollaborationChangeRequestSummaryListCopier
                    .copyToBuilder(this.collaborationChangeRequestSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationChangeRequestSummaries(
                Collection<CollaborationChangeRequestSummary.BuilderImpl> collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries = CollaborationChangeRequestSummaryListCopier
                    .copyFromBuilder(collaborationChangeRequestSummaries);
        }

        @Override
        public final Builder collaborationChangeRequestSummaries(
                Collection<CollaborationChangeRequestSummary> collaborationChangeRequestSummaries) {
            this.collaborationChangeRequestSummaries = CollaborationChangeRequestSummaryListCopier
                    .copy(collaborationChangeRequestSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationChangeRequestSummaries(
                CollaborationChangeRequestSummary... collaborationChangeRequestSummaries) {
            collaborationChangeRequestSummaries(Arrays.asList(collaborationChangeRequestSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationChangeRequestSummaries(
                Consumer<CollaborationChangeRequestSummary.Builder>... collaborationChangeRequestSummaries) {
            collaborationChangeRequestSummaries(Stream.of(collaborationChangeRequestSummaries)
                    .map(c -> CollaborationChangeRequestSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollaborationChangeRequestsResponse build() {
            return new ListCollaborationChangeRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
