/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protected job output configuration input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobOutputConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobOutputConfigurationInput.Builder, ProtectedJobOutputConfigurationInput> {
    private static final SdkField<ProtectedJobMemberOutputConfigurationInput> MEMBER_FIELD = SdkField
            .<ProtectedJobMemberOutputConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("member")
            .getter(getter(ProtectedJobOutputConfigurationInput::member)).setter(setter(Builder::member))
            .constructor(ProtectedJobMemberOutputConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobMemberOutputConfigurationInput member;

    private final Type type;

    private ProtectedJobOutputConfigurationInput(BuilderImpl builder) {
        this.member = builder.member;
        this.type = builder.type;
    }

    /**
     * <p>
     * The member of the protected job output configuration input.
     * </p>
     * 
     * @return The member of the protected job output configuration input.
     */
    public final ProtectedJobMemberOutputConfigurationInput member() {
        return member;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(member());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobOutputConfigurationInput)) {
            return false;
        }
        ProtectedJobOutputConfigurationInput other = (ProtectedJobOutputConfigurationInput) obj;
        return Objects.equals(member(), other.member());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobOutputConfigurationInput").add("Member", member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "member":
            return Optional.ofNullable(clazz.cast(member()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #member()} initialized to the given value.
     *
     * <p>
     * The member of the protected job output configuration input.
     * </p>
     * 
     * @param member
     *        The member of the protected job output configuration input.
     */
    public static ProtectedJobOutputConfigurationInput fromMember(ProtectedJobMemberOutputConfigurationInput member) {
        return builder().member(member).build();
    }

    /**
     * Create an instance of this class with {@link #member()} initialized to the given value.
     *
     * <p>
     * The member of the protected job output configuration input.
     * </p>
     * 
     * @param member
     *        The member of the protected job output configuration input.
     */
    public static ProtectedJobOutputConfigurationInput fromMember(
            Consumer<ProtectedJobMemberOutputConfigurationInput.Builder> member) {
        ProtectedJobMemberOutputConfigurationInput.Builder builder = ProtectedJobMemberOutputConfigurationInput.builder();
        member.accept(builder);
        return fromMember(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("member", MEMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobOutputConfigurationInput, T> g) {
        return obj -> g.apply((ProtectedJobOutputConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobOutputConfigurationInput> {
        /**
         * <p>
         * The member of the protected job output configuration input.
         * </p>
         * 
         * @param member
         *        The member of the protected job output configuration input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(ProtectedJobMemberOutputConfigurationInput member);

        /**
         * <p>
         * The member of the protected job output configuration input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobMemberOutputConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobMemberOutputConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobMemberOutputConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to {@link #member(ProtectedJobMemberOutputConfigurationInput)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link ProtectedJobMemberOutputConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(ProtectedJobMemberOutputConfigurationInput)
         */
        default Builder member(Consumer<ProtectedJobMemberOutputConfigurationInput.Builder> member) {
            return member(ProtectedJobMemberOutputConfigurationInput.builder().applyMutation(member).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobMemberOutputConfigurationInput member;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobOutputConfigurationInput model) {
            member(model.member);
        }

        public final ProtectedJobMemberOutputConfigurationInput.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(ProtectedJobMemberOutputConfigurationInput.BuilderImpl member) {
            Object oldValue = this.member;
            this.member = member != null ? member.build() : null;
            handleUnionValueChange(Type.MEMBER, oldValue, this.member);
        }

        @Override
        public final Builder member(ProtectedJobMemberOutputConfigurationInput member) {
            Object oldValue = this.member;
            this.member = member;
            handleUnionValueChange(Type.MEMBER, oldValue, this.member);
            return this;
        }

        @Override
        public ProtectedJobOutputConfigurationInput build() {
            return new ProtectedJobOutputConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ProtectedJobOutputConfigurationInput#type()
     */
    public enum Type {
        MEMBER,

        UNKNOWN_TO_SDK_VERSION
    }
}
