/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for the SQL type Protected Query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQuerySQLParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQuerySQLParameters.Builder, ProtectedQuerySQLParameters> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(ProtectedQuerySQLParameters::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> ANALYSIS_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisTemplateArn").getter(getter(ProtectedQuerySQLParameters::analysisTemplateArn))
            .setter(setter(Builder::analysisTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisTemplateArn").build())
            .build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ProtectedQuerySQLParameters::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            ANALYSIS_TEMPLATE_ARN_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryString;

    private final String analysisTemplateArn;

    private final Map<String, String> parameters;

    private ProtectedQuerySQLParameters(BuilderImpl builder) {
        this.queryString = builder.queryString;
        this.analysisTemplateArn = builder.analysisTemplateArn;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The query string to be submitted.
     * </p>
     * 
     * @return The query string to be submitted.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.
     */
    public final String analysisTemplateArn() {
        return analysisTemplateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The protected query SQL parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The protected query SQL parameters.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuerySQLParameters)) {
            return false;
        }
        ProtectedQuerySQLParameters other = (ProtectedQuerySQLParameters) obj;
        return Objects.equals(queryString(), other.queryString())
                && Objects.equals(analysisTemplateArn(), other.analysisTemplateArn()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQuerySQLParameters").add("QueryString", queryString())
                .add("AnalysisTemplateArn", analysisTemplateArn()).add("Parameters", hasParameters() ? parameters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "analysisTemplateArn":
            return Optional.ofNullable(clazz.cast(analysisTemplateArn()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("analysisTemplateArn", ANALYSIS_TEMPLATE_ARN_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuerySQLParameters, T> g) {
        return obj -> g.apply((ProtectedQuerySQLParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQuerySQLParameters> {
        /**
         * <p>
         * The query string to be submitted.
         * </p>
         * 
         * @param queryString
         *        The query string to be submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.
         * </p>
         * 
         * @param analysisTemplateArn
         *        The Amazon Resource Name (ARN) associated with the analysis template within a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisTemplateArn(String analysisTemplateArn);

        /**
         * <p>
         * The protected query SQL parameters.
         * </p>
         * 
         * @param parameters
         *        The protected query SQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String queryString;

        private String analysisTemplateArn;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuerySQLParameters model) {
            queryString(model.queryString);
            analysisTemplateArn(model.analysisTemplateArn);
            parameters(model.parameters);
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getAnalysisTemplateArn() {
            return analysisTemplateArn;
        }

        public final void setAnalysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
        }

        @Override
        public final Builder analysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterMapCopier.copy(parameters);
            return this;
        }

        @Override
        public ProtectedQuerySQLParameters build() {
            return new ProtectedQuerySQLParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
