/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration properties that define the compute environment settings for workers in Clean Rooms. These
 * properties enable customization of the underlying compute environment to optimize performance for your specific
 * workloads.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerComputeConfigurationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerComputeConfigurationProperties.Builder, WorkerComputeConfigurationProperties> {
    private static final SdkField<Map<String, String>> SPARK_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("spark")
            .getter(getter(WorkerComputeConfigurationProperties::spark))
            .setter(setter(Builder::spark))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spark").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPARK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> spark;

    private final Type type;

    private WorkerComputeConfigurationProperties(BuilderImpl builder) {
        this.spark = builder.spark;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spark property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSpark() {
        return spark != null && !(spark instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure Apache
     * Spark settings to optimize performance for your data processing jobs. You can specify up to 50 Spark properties,
     * with each key being 1-200 characters and each value being 0-500 characters. These properties allow you to adjust
     * compute capacity for large datasets and complex workloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpark} method.
     * </p>
     * 
     * @return The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure
     *         Apache Spark settings to optimize performance for your data processing jobs. You can specify up to 50
     *         Spark properties, with each key being 1-200 characters and each value being 0-500 characters. These
     *         properties allow you to adjust compute capacity for large datasets and complex workloads.
     */
    public final Map<String, String> spark() {
        return spark;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSpark() ? spark() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerComputeConfigurationProperties)) {
            return false;
        }
        WorkerComputeConfigurationProperties other = (WorkerComputeConfigurationProperties) obj;
        return hasSpark() == other.hasSpark() && Objects.equals(spark(), other.spark());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerComputeConfigurationProperties").add("Spark", hasSpark() ? spark() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spark":
            return Optional.ofNullable(clazz.cast(spark()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #spark()} initialized to the given value.
     *
     * <p>
     * The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure Apache
     * Spark settings to optimize performance for your data processing jobs. You can specify up to 50 Spark properties,
     * with each key being 1-200 characters and each value being 0-500 characters. These properties allow you to adjust
     * compute capacity for large datasets and complex workloads.
     * </p>
     * 
     * @param spark
     *        The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure
     *        Apache Spark settings to optimize performance for your data processing jobs. You can specify up to 50
     *        Spark properties, with each key being 1-200 characters and each value being 0-500 characters. These
     *        properties allow you to adjust compute capacity for large datasets and complex workloads.
     */
    public static WorkerComputeConfigurationProperties fromSpark(Map<String, String> spark) {
        return builder().spark(spark).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spark", SPARK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerComputeConfigurationProperties, T> g) {
        return obj -> g.apply((WorkerComputeConfigurationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerComputeConfigurationProperties> {
        /**
         * <p>
         * The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure Apache
         * Spark settings to optimize performance for your data processing jobs. You can specify up to 50 Spark
         * properties, with each key being 1-200 characters and each value being 0-500 characters. These properties
         * allow you to adjust compute capacity for large datasets and complex workloads.
         * </p>
         * 
         * @param spark
         *        The Spark configuration properties for SQL workloads. This map contains key-value pairs that configure
         *        Apache Spark settings to optimize performance for your data processing jobs. You can specify up to 50
         *        Spark properties, with each key being 1-200 characters and each value being 0-500 characters. These
         *        properties allow you to adjust compute capacity for large datasets and complex workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spark(Map<String, String> spark);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> spark = DefaultSdkAutoConstructMap.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerComputeConfigurationProperties model) {
            spark(model.spark);
        }

        public final Map<String, String> getSpark() {
            if (spark instanceof SdkAutoConstructMap) {
                return null;
            }
            return spark;
        }

        public final void setSpark(Map<String, String> spark) {
            Object oldValue = this.spark;
            this.spark = SparkPropertiesCopier.copy(spark);
            handleUnionValueChange(Type.SPARK, oldValue, this.spark);
        }

        @Override
        public final Builder spark(Map<String, String> spark) {
            Object oldValue = this.spark;
            this.spark = SparkPropertiesCopier.copy(spark);
            handleUnionValueChange(Type.SPARK, oldValue, this.spark);
            return this;
        }

        @Override
        public WorkerComputeConfigurationProperties build() {
            return new WorkerComputeConfigurationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see WorkerComputeConfigurationProperties#type()
     */
    public enum Type {
        SPARK,

        UNKNOWN_TO_SDK_VERSION
    }
}
