/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfiguredAudienceModelRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<CreateConfiguredAudienceModelRequest.Builder, CreateConfiguredAudienceModelRequest> {
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceModelArn").getter(getter(CreateConfiguredAudienceModelRequest::audienceModelArn))
            .setter(setter(Builder::audienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()).build();

    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField
            .<AudienceSizeConfig> builder(MarshallingType.SDK_POJO).memberName("audienceSizeConfig")
            .getter(getter(CreateConfiguredAudienceModelRequest::audienceSizeConfig)).setter(setter(Builder::audienceSizeConfig))
            .constructor(AudienceSizeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build())
            .build();

    private static final SdkField<String> CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("childResourceTagOnCreatePolicy")
            .getter(getter(CreateConfiguredAudienceModelRequest::childResourceTagOnCreatePolicyAsString))
            .setter(setter(Builder::childResourceTagOnCreatePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childResourceTagOnCreatePolicy")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateConfiguredAudienceModelRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minMatchingSeedSize").getter(getter(CreateConfiguredAudienceModelRequest::minMatchingSeedSize))
            .setter(setter(Builder::minMatchingSeedSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateConfiguredAudienceModelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<ConfiguredAudienceModelOutputConfig> builder(MarshallingType.SDK_POJO).memberName("outputConfig")
            .getter(getter(CreateConfiguredAudienceModelRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(ConfiguredAudienceModelOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()).build();

    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sharedAudienceMetrics")
            .getter(getter(CreateConfiguredAudienceModelRequest::sharedAudienceMetricsAsStrings))
            .setter(setter(Builder::sharedAudienceMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateConfiguredAudienceModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_MODEL_ARN_FIELD,
            AUDIENCE_SIZE_CONFIG_FIELD, CHILD_RESOURCE_TAG_ON_CREATE_POLICY_FIELD, DESCRIPTION_FIELD,
            MIN_MATCHING_SEED_SIZE_FIELD, NAME_FIELD, OUTPUT_CONFIG_FIELD, SHARED_AUDIENCE_METRICS_FIELD, TAGS_FIELD));

    private final String audienceModelArn;

    private final AudienceSizeConfig audienceSizeConfig;

    private final String childResourceTagOnCreatePolicy;

    private final String description;

    private final Integer minMatchingSeedSize;

    private final String name;

    private final ConfiguredAudienceModelOutputConfig outputConfig;

    private final List<String> sharedAudienceMetrics;

    private final Map<String, String> tags;

    private CreateConfiguredAudienceModelRequest(BuilderImpl builder) {
        super(builder);
        this.audienceModelArn = builder.audienceModelArn;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.childResourceTagOnCreatePolicy = builder.childResourceTagOnCreatePolicy;
        this.description = builder.description;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.name = builder.name;
        this.outputConfig = builder.outputConfig;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
     */
    public final String audienceModelArn() {
        return audienceModelArn;
    }

    /**
     * <p>
     * Configure the list of output sizes of audiences that can be created using this configured audience model. A
     * request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
     * <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a> to
     * configure out audience sizes using the count of identifiers in the output. You can use the
     * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
     * </p>
     * 
     * @return Configure the list of output sizes of audiences that can be created using this configured audience model.
     *         A request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
     *         <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code>
     *         <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can
     *         use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
     */
    public final AudienceSizeConfig audienceSizeConfig() {
        return audienceSizeConfig;
    }

    /**
     * <p>
     * Configure how the service tags audience generation jobs created using this configured audience model. If you
     * specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the tags of the
     * audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience generation job inherits
     * the tags from the configured audience model, by default. Tags in the <a>StartAudienceGenerationJob</a> will
     * override the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #childResourceTagOnCreatePolicy} will return {@link TagOnCreatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #childResourceTagOnCreatePolicyAsString}.
     * </p>
     * 
     * @return Configure how the service tags audience generation jobs created using this configured audience model. If
     *         you specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the
     *         tags of the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience
     *         generation job inherits the tags from the configured audience model, by default. Tags in the
     *         <a>StartAudienceGenerationJob</a> will override the default.
     * @see TagOnCreatePolicy
     */
    public final TagOnCreatePolicy childResourceTagOnCreatePolicy() {
        return TagOnCreatePolicy.fromValue(childResourceTagOnCreatePolicy);
    }

    /**
     * <p>
     * Configure how the service tags audience generation jobs created using this configured audience model. If you
     * specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the tags of the
     * audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience generation job inherits
     * the tags from the configured audience model, by default. Tags in the <a>StartAudienceGenerationJob</a> will
     * override the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #childResourceTagOnCreatePolicy} will return {@link TagOnCreatePolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #childResourceTagOnCreatePolicyAsString}.
     * </p>
     * 
     * @return Configure how the service tags audience generation jobs created using this configured audience model. If
     *         you specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the
     *         tags of the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience
     *         generation job inherits the tags from the configured audience model, by default. Tags in the
     *         <a>StartAudienceGenerationJob</a> will override the default.
     * @see TagOnCreatePolicy
     */
    public final String childResourceTagOnCreatePolicyAsString() {
        return childResourceTagOnCreatePolicy;
    }

    /**
     * <p>
     * The description of the configured audience model.
     * </p>
     * 
     * @return The description of the configured audience model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The minimum number of users from the seed audience that must match with users in the training data of the
     * audience model.
     * </p>
     * 
     * @return The minimum number of users from the seed audience that must match with users in the training data of the
     *         audience model.
     */
    public final Integer minMatchingSeedSize() {
        return minMatchingSeedSize;
    }

    /**
     * <p>
     * The name of the configured audience model.
     * </p>
     * 
     * @return The name of the configured audience model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model. Each
     * audience will have a unique location. The IAM Role must have <code>s3:PutObject</code> permission on the
     * destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must also
     * have the required KMS permissions.
     * </p>
     * 
     * @return Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model.
     *         Each audience will have a unique location. The IAM Role must have <code>s3:PutObject</code> permission on
     *         the destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role
     *         must also have the required KMS permissions.
     */
    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * Whether audience metrics are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return Whether audience metrics are shared.
     */
    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(sharedAudienceMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedAudienceMetrics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSharedAudienceMetrics() {
        return sharedAudienceMetrics != null && !(sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Whether audience metrics are shared.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedAudienceMetrics} method.
     * </p>
     * 
     * @return Whether audience metrics are shared.
     */
    public final List<String> sharedAudienceMetricsAsStrings() {
        return sharedAudienceMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit
     * of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a user tag
     *         and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count against
     *         your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(childResourceTagOnCreatePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredAudienceModelRequest)) {
            return false;
        }
        CreateConfiguredAudienceModelRequest other = (CreateConfiguredAudienceModelRequest) obj;
        return Objects.equals(audienceModelArn(), other.audienceModelArn())
                && Objects.equals(audienceSizeConfig(), other.audienceSizeConfig())
                && Objects.equals(childResourceTagOnCreatePolicyAsString(), other.childResourceTagOnCreatePolicyAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(minMatchingSeedSize(), other.minMatchingSeedSize()) && Objects.equals(name(), other.name())
                && Objects.equals(outputConfig(), other.outputConfig())
                && hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics()
                && Objects.equals(sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfiguredAudienceModelRequest").add("AudienceModelArn", audienceModelArn())
                .add("AudienceSizeConfig", audienceSizeConfig())
                .add("ChildResourceTagOnCreatePolicy", childResourceTagOnCreatePolicyAsString())
                .add("Description", description()).add("MinMatchingSeedSize", minMatchingSeedSize()).add("Name", name())
                .add("OutputConfig", outputConfig())
                .add("SharedAudienceMetrics", hasSharedAudienceMetrics() ? sharedAudienceMetricsAsStrings() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audienceModelArn":
            return Optional.ofNullable(clazz.cast(audienceModelArn()));
        case "audienceSizeConfig":
            return Optional.ofNullable(clazz.cast(audienceSizeConfig()));
        case "childResourceTagOnCreatePolicy":
            return Optional.ofNullable(clazz.cast(childResourceTagOnCreatePolicyAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "minMatchingSeedSize":
            return Optional.ofNullable(clazz.cast(minMatchingSeedSize()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "outputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "sharedAudienceMetrics":
            return Optional.ofNullable(clazz.cast(sharedAudienceMetricsAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredAudienceModelRequest, T> g) {
        return obj -> g.apply((CreateConfiguredAudienceModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfiguredAudienceModelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
         * </p>
         * 
         * @param audienceModelArn
         *        The Amazon Resource Name (ARN) of the audience model to use for the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceModelArn(String audienceModelArn);

        /**
         * <p>
         * Configure the list of output sizes of audiences that can be created using this configured audience model. A
         * request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
         * <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a>
         * to configure out audience sizes using the count of identifiers in the output. You can use the
         * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * </p>
         * 
         * @param audienceSizeConfig
         *        Configure the list of output sizes of audiences that can be created using this configured audience
         *        model. A request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must
         *        have an <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code>
         *        <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You
         *        can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig);

        /**
         * <p>
         * Configure the list of output sizes of audiences that can be created using this configured audience model. A
         * request to <a>StartAudienceGenerationJob</a> that uses this configured audience model must have an
         * <code>audienceSize</code> selected from this list. You can use the <code>ABSOLUTE</code> <a>AudienceSize</a>
         * to configure out audience sizes using the count of identifiers in the output. You can use the
         * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceSizeConfig.Builder} avoiding the
         * need to create one manually via {@link AudienceSizeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSizeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSizeConfig(AudienceSizeConfig)}.
         * 
         * @param audienceSizeConfig
         *        a consumer that will call methods on {@link AudienceSizeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSizeConfig(AudienceSizeConfig)
         */
        default Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return audienceSizeConfig(AudienceSizeConfig.builder().applyMutation(audienceSizeConfig).build());
        }

        /**
         * <p>
         * Configure how the service tags audience generation jobs created using this configured audience model. If you
         * specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the tags of
         * the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience generation job
         * inherits the tags from the configured audience model, by default. Tags in the
         * <a>StartAudienceGenerationJob</a> will override the default.
         * </p>
         * 
         * @param childResourceTagOnCreatePolicy
         *        Configure how the service tags audience generation jobs created using this configured audience model.
         *        If you specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request
         *        determine the tags of the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>,
         *        the audience generation job inherits the tags from the configured audience model, by default. Tags in
         *        the <a>StartAudienceGenerationJob</a> will override the default.
         * @see TagOnCreatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagOnCreatePolicy
         */
        Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy);

        /**
         * <p>
         * Configure how the service tags audience generation jobs created using this configured audience model. If you
         * specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request determine the tags of
         * the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>, the audience generation job
         * inherits the tags from the configured audience model, by default. Tags in the
         * <a>StartAudienceGenerationJob</a> will override the default.
         * </p>
         * 
         * @param childResourceTagOnCreatePolicy
         *        Configure how the service tags audience generation jobs created using this configured audience model.
         *        If you specify <code>NONE</code>, the tags from the <a>StartAudienceGenerationJob</a> request
         *        determine the tags of the audience generation job. If you specify <code>FROM_PARENT_RESOURCE</code>,
         *        the audience generation job inherits the tags from the configured audience model, by default. Tags in
         *        the <a>StartAudienceGenerationJob</a> will override the default.
         * @see TagOnCreatePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagOnCreatePolicy
         */
        Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy);

        /**
         * <p>
         * The description of the configured audience model.
         * </p>
         * 
         * @param description
         *        The description of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The minimum number of users from the seed audience that must match with users in the training data of the
         * audience model.
         * </p>
         * 
         * @param minMatchingSeedSize
         *        The minimum number of users from the seed audience that must match with users in the training data of
         *        the audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minMatchingSeedSize(Integer minMatchingSeedSize);

        /**
         * <p>
         * The name of the configured audience model.
         * </p>
         * 
         * @param name
         *        The name of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model.
         * Each audience will have a unique location. The IAM Role must have <code>s3:PutObject</code> permission on the
         * destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must
         * also have the required KMS permissions.
         * </p>
         * 
         * @param outputConfig
         *        Configure the Amazon S3 location and IAM Role for audiences created using this configured audience
         *        model. Each audience will have a unique location. The IAM Role must have <code>s3:PutObject</code>
         *        permission on the destination Amazon S3 location. If the destination is protected with Amazon S3
         *        KMS-SSE, then the Role must also have the required KMS permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig);

        /**
         * <p>
         * Configure the Amazon S3 location and IAM Role for audiences created using this configured audience model.
         * Each audience will have a unique location. The IAM Role must have <code>s3:PutObject</code> permission on the
         * destination Amazon S3 location. If the destination is protected with Amazon S3 KMS-SSE, then the Role must
         * also have the required KMS permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredAudienceModelOutputConfig.Builder} avoiding the need to create one manually via
         * {@link ConfiguredAudienceModelOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredAudienceModelOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(ConfiguredAudienceModelOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link ConfiguredAudienceModelOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(ConfiguredAudienceModelOutputConfig)
         */
        default Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return outputConfig(ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics);

        /**
         * <p>
         * Whether audience metrics are shared.
         * </p>
         * 
         * @param sharedAudienceMetrics
         *        Whether audience metrics are shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics);

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Forecast considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Forecast considers it to be a
         *        user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String audienceModelArn;

        private AudienceSizeConfig audienceSizeConfig;

        private String childResourceTagOnCreatePolicy;

        private String description;

        private Integer minMatchingSeedSize;

        private String name;

        private ConfiguredAudienceModelOutputConfig outputConfig;

        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredAudienceModelRequest model) {
            super(model);
            audienceModelArn(model.audienceModelArn);
            audienceSizeConfig(model.audienceSizeConfig);
            childResourceTagOnCreatePolicy(model.childResourceTagOnCreatePolicy);
            description(model.description);
            minMatchingSeedSize(model.minMatchingSeedSize);
            name(model.name);
            outputConfig(model.outputConfig);
            sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
            tags(model.tags);
        }

        public final String getAudienceModelArn() {
            return audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return audienceSizeConfig != null ? audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final String getChildResourceTagOnCreatePolicy() {
            return childResourceTagOnCreatePolicy;
        }

        public final void setChildResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(String childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy;
            return this;
        }

        @Override
        public final Builder childResourceTagOnCreatePolicy(TagOnCreatePolicy childResourceTagOnCreatePolicy) {
            this.childResourceTagOnCreatePolicy(childResourceTagOnCreatePolicy == null ? null : childResourceTagOnCreatePolicy
                    .toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String... sharedAudienceMetrics) {
            sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics... sharedAudienceMetrics) {
            sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredAudienceModelRequest build() {
            return new CreateConfiguredAudienceModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
