/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The audience model metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceModelMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceModelMetric.Builder, AudienceModelMetric> {
    private static final SdkField<Integer> FOR_TOP_K_ITEM_PREDICTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("forTopKItemPredictions").getter(getter(AudienceModelMetric::forTopKItemPredictions))
            .setter(setter(Builder::forTopKItemPredictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forTopKItemPredictions").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AudienceModelMetric::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(AudienceModelMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FOR_TOP_K_ITEM_PREDICTIONS_FIELD, TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer forTopKItemPredictions;

    private final String type;

    private final Double value;

    private AudienceModelMetric(BuilderImpl builder) {
        this.forTopKItemPredictions = builder.forTopKItemPredictions;
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The number of users that were used to generate these model metrics.
     * </p>
     * 
     * @return The number of users that were used to generate these model metrics.
     */
    public final Integer forTopKItemPredictions() {
        return forTopKItemPredictions;
    }

    /**
     * <p>
     * The audience model metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AudienceModelMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The audience model metric.
     * @see AudienceModelMetricType
     */
    public final AudienceModelMetricType type() {
        return AudienceModelMetricType.fromValue(type);
    }

    /**
     * <p>
     * The audience model metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AudienceModelMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The audience model metric.
     * @see AudienceModelMetricType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The value of the audience model metric
     * </p>
     * 
     * @return The value of the audience model metric
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forTopKItemPredictions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceModelMetric)) {
            return false;
        }
        AudienceModelMetric other = (AudienceModelMetric) obj;
        return Objects.equals(forTopKItemPredictions(), other.forTopKItemPredictions())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceModelMetric").add("ForTopKItemPredictions", forTopKItemPredictions())
                .add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forTopKItemPredictions":
            return Optional.ofNullable(clazz.cast(forTopKItemPredictions()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceModelMetric, T> g) {
        return obj -> g.apply((AudienceModelMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceModelMetric> {
        /**
         * <p>
         * The number of users that were used to generate these model metrics.
         * </p>
         * 
         * @param forTopKItemPredictions
         *        The number of users that were used to generate these model metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forTopKItemPredictions(Integer forTopKItemPredictions);

        /**
         * <p>
         * The audience model metric.
         * </p>
         * 
         * @param type
         *        The audience model metric.
         * @see AudienceModelMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceModelMetricType
         */
        Builder type(String type);

        /**
         * <p>
         * The audience model metric.
         * </p>
         * 
         * @param type
         *        The audience model metric.
         * @see AudienceModelMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceModelMetricType
         */
        Builder type(AudienceModelMetricType type);

        /**
         * <p>
         * The value of the audience model metric
         * </p>
         * 
         * @param value
         *        The value of the audience model metric
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private Integer forTopKItemPredictions;

        private String type;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceModelMetric model) {
            forTopKItemPredictions(model.forTopKItemPredictions);
            type(model.type);
            value(model.value);
        }

        public final Integer getForTopKItemPredictions() {
            return forTopKItemPredictions;
        }

        public final void setForTopKItemPredictions(Integer forTopKItemPredictions) {
            this.forTopKItemPredictions = forTopKItemPredictions;
        }

        @Override
        public final Builder forTopKItemPredictions(Integer forTopKItemPredictions) {
            this.forTopKItemPredictions = forTopKItemPredictions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AudienceModelMetricType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public AudienceModelMetric build() {
            return new AudienceModelMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
