/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfiguredAudienceModelPolicyRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<PutConfiguredAudienceModelPolicyRequest.Builder, PutConfiguredAudienceModelPolicyRequest> {
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(PutConfiguredAudienceModelPolicyRequest::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelPolicy")
            .getter(getter(PutConfiguredAudienceModelPolicyRequest::configuredAudienceModelPolicy))
            .setter(setter(Builder::configuredAudienceModelPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelPolicy")
                    .build()).build();

    private static final SdkField<String> POLICY_EXISTENCE_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyExistenceCondition")
            .getter(getter(PutConfiguredAudienceModelPolicyRequest::policyExistenceConditionAsString))
            .setter(setter(Builder::policyExistenceCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyExistenceCondition").build())
            .build();

    private static final SdkField<String> PREVIOUS_POLICY_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("previousPolicyHash").getter(getter(PutConfiguredAudienceModelPolicyRequest::previousPolicyHash))
            .setter(setter(Builder::previousPolicyHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousPolicyHash").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD, POLICY_EXISTENCE_CONDITION_FIELD,
            PREVIOUS_POLICY_HASH_FIELD));

    private final String configuredAudienceModelArn;

    private final String configuredAudienceModelPolicy;

    private final String policyExistenceCondition;

    private final String previousPolicyHash;

    private PutConfiguredAudienceModelPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.configuredAudienceModelPolicy = builder.configuredAudienceModelPolicy;
        this.policyExistenceCondition = builder.policyExistenceCondition;
        this.previousPolicyHash = builder.previousPolicyHash;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model that the resource policy will govern.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model that the resource policy will govern.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The IAM resource policy.
     * </p>
     * 
     * @return The IAM resource policy.
     */
    public final String configuredAudienceModelPolicy() {
        return configuredAudienceModelPolicy;
    }

    /**
     * <p>
     * Use this to prevent unexpected concurrent modification of the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistenceCondition} will return {@link PolicyExistenceCondition#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #policyExistenceConditionAsString}.
     * </p>
     * 
     * @return Use this to prevent unexpected concurrent modification of the policy.
     * @see PolicyExistenceCondition
     */
    public final PolicyExistenceCondition policyExistenceCondition() {
        return PolicyExistenceCondition.fromValue(policyExistenceCondition);
    }

    /**
     * <p>
     * Use this to prevent unexpected concurrent modification of the policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistenceCondition} will return {@link PolicyExistenceCondition#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #policyExistenceConditionAsString}.
     * </p>
     * 
     * @return Use this to prevent unexpected concurrent modification of the policy.
     * @see PolicyExistenceCondition
     */
    public final String policyExistenceConditionAsString() {
        return policyExistenceCondition;
    }

    /**
     * <p>
     * A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the
     * policy.
     * </p>
     * 
     * @return A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of
     *         the policy.
     */
    public final String previousPolicyHash() {
        return previousPolicyHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(policyExistenceConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousPolicyHash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfiguredAudienceModelPolicyRequest)) {
            return false;
        }
        PutConfiguredAudienceModelPolicyRequest other = (PutConfiguredAudienceModelPolicyRequest) obj;
        return Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(configuredAudienceModelPolicy(), other.configuredAudienceModelPolicy())
                && Objects.equals(policyExistenceConditionAsString(), other.policyExistenceConditionAsString())
                && Objects.equals(previousPolicyHash(), other.previousPolicyHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfiguredAudienceModelPolicyRequest")
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn())
                .add("ConfiguredAudienceModelPolicy", configuredAudienceModelPolicy())
                .add("PolicyExistenceCondition", policyExistenceConditionAsString())
                .add("PreviousPolicyHash", previousPolicyHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "configuredAudienceModelPolicy":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelPolicy()));
        case "policyExistenceCondition":
            return Optional.ofNullable(clazz.cast(policyExistenceConditionAsString()));
        case "previousPolicyHash":
            return Optional.ofNullable(clazz.cast(previousPolicyHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfiguredAudienceModelPolicyRequest, T> g) {
        return obj -> g.apply((PutConfiguredAudienceModelPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfiguredAudienceModelPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model that the resource policy will govern.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model that the resource policy will govern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The IAM resource policy.
         * </p>
         * 
         * @param configuredAudienceModelPolicy
         *        The IAM resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelPolicy(String configuredAudienceModelPolicy);

        /**
         * <p>
         * Use this to prevent unexpected concurrent modification of the policy.
         * </p>
         * 
         * @param policyExistenceCondition
         *        Use this to prevent unexpected concurrent modification of the policy.
         * @see PolicyExistenceCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyExistenceCondition
         */
        Builder policyExistenceCondition(String policyExistenceCondition);

        /**
         * <p>
         * Use this to prevent unexpected concurrent modification of the policy.
         * </p>
         * 
         * @param policyExistenceCondition
         *        Use this to prevent unexpected concurrent modification of the policy.
         * @see PolicyExistenceCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyExistenceCondition
         */
        Builder policyExistenceCondition(PolicyExistenceCondition policyExistenceCondition);

        /**
         * <p>
         * A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the
         * policy.
         * </p>
         * 
         * @param previousPolicyHash
         *        A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification
         *        of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousPolicyHash(String previousPolicyHash);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String configuredAudienceModelArn;

        private String configuredAudienceModelPolicy;

        private String policyExistenceCondition;

        private String previousPolicyHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfiguredAudienceModelPolicyRequest model) {
            super(model);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            configuredAudienceModelPolicy(model.configuredAudienceModelPolicy);
            policyExistenceCondition(model.policyExistenceCondition);
            previousPolicyHash(model.previousPolicyHash);
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelPolicy() {
            return configuredAudienceModelPolicy;
        }

        public final void setConfiguredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
        }

        @Override
        public final Builder configuredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
            return this;
        }

        public final String getPolicyExistenceCondition() {
            return policyExistenceCondition;
        }

        public final void setPolicyExistenceCondition(String policyExistenceCondition) {
            this.policyExistenceCondition = policyExistenceCondition;
        }

        @Override
        public final Builder policyExistenceCondition(String policyExistenceCondition) {
            this.policyExistenceCondition = policyExistenceCondition;
            return this;
        }

        @Override
        public final Builder policyExistenceCondition(PolicyExistenceCondition policyExistenceCondition) {
            this.policyExistenceCondition(policyExistenceCondition == null ? null : policyExistenceCondition.toString());
            return this;
        }

        public final String getPreviousPolicyHash() {
            return previousPolicyHash;
        }

        public final void setPreviousPolicyHash(String previousPolicyHash) {
            this.previousPolicyHash = previousPolicyHash;
        }

        @Override
        public final Builder previousPolicyHash(String previousPolicyHash) {
            this.previousPolicyHash = previousPolicyHash;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfiguredAudienceModelPolicyRequest build() {
            return new PutConfiguredAudienceModelPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
