/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrainingDatasetResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetTrainingDatasetResponse.Builder, GetTrainingDatasetResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetTrainingDatasetResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTrainingDatasetResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTrainingDatasetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetTrainingDatasetResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTrainingDatasetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTrainingDatasetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Dataset>> TRAINING_DATA_FIELD = SdkField
            .<List<Dataset>> builder(MarshallingType.LIST)
            .memberName("trainingData")
            .getter(getter(GetTrainingDatasetResponse::trainingData))
            .setter(setter(Builder::trainingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dataset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dataset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(GetTrainingDatasetResponse::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build())
            .build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetTrainingDatasetResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, TAGS_FIELD, TRAINING_DATA_FIELD,
            TRAINING_DATASET_ARN_FIELD, UPDATE_TIME_FIELD));

    private final Instant createTime;

    private final String description;

    private final String name;

    private final String roleArn;

    private final String status;

    private final Map<String, String> tags;

    private final List<Dataset> trainingData;

    private final String trainingDatasetArn;

    private final Instant updateTime;

    private GetTrainingDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.tags = builder.tags;
        this.trainingData = builder.trainingData;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The time at which the training dataset was created.
     * </p>
     * 
     * @return The time at which the training dataset was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The description of the training dataset.
     * </p>
     * 
     * @return The description of the training dataset.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the training dataset.
     * </p>
     * 
     * @return The name of the training dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The IAM role used to read the training data.
     * </p>
     * 
     * @return The IAM role used to read the training data.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the training dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingDatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the training dataset.
     * @see TrainingDatasetStatus
     */
    public final TrainingDatasetStatus status() {
        return TrainingDatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the training dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainingDatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the training dataset.
     * @see TrainingDatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are assigned to this training dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are assigned to this training dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingData property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainingData() {
        return trainingData != null && !(trainingData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata about the requested training data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingData} method.
     * </p>
     * 
     * @return Metadata about the requested training data.
     */
    public final List<Dataset> trainingData() {
        return trainingData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    /**
     * <p>
     * The most recent time at which the training dataset was updated.
     * </p>
     * 
     * @return The most recent time at which the training dataset was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingData() ? trainingData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainingDatasetResponse)) {
            return false;
        }
        GetTrainingDatasetResponse other = (GetTrainingDatasetResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTrainingData() == other.hasTrainingData()
                && Objects.equals(trainingData(), other.trainingData())
                && Objects.equals(trainingDatasetArn(), other.trainingDatasetArn())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrainingDatasetResponse").add("CreateTime", createTime()).add("Description", description())
                .add("Name", name()).add("RoleArn", roleArn()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("TrainingData", hasTrainingData() ? trainingData() : null)
                .add("TrainingDatasetArn", trainingDatasetArn()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "trainingData":
            return Optional.ofNullable(clazz.cast(trainingData()));
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrainingDatasetResponse, T> g) {
        return obj -> g.apply((GetTrainingDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrainingDatasetResponse> {
        /**
         * <p>
         * The time at which the training dataset was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the training dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The description of the training dataset.
         * </p>
         * 
         * @param description
         *        The description of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the training dataset.
         * </p>
         * 
         * @param name
         *        The name of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The IAM role used to read the training data.
         * </p>
         * 
         * @param roleArn
         *        The IAM role used to read the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the training dataset.
         * </p>
         * 
         * @param status
         *        The status of the training dataset.
         * @see TrainingDatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the training dataset.
         * </p>
         * 
         * @param status
         *        The status of the training dataset.
         * @see TrainingDatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDatasetStatus
         */
        Builder status(TrainingDatasetStatus status);

        /**
         * <p>
         * The tags that are assigned to this training dataset.
         * </p>
         * 
         * @param tags
         *        The tags that are assigned to this training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Metadata about the requested training data.
         * </p>
         * 
         * @param trainingData
         *        Metadata about the requested training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(Collection<Dataset> trainingData);

        /**
         * <p>
         * Metadata about the requested training data.
         * </p>
         * 
         * @param trainingData
         *        Metadata about the requested training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(Dataset... trainingData);

        /**
         * <p>
         * Metadata about the requested training data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder#build()} is called immediately and
         * its result is passed to {@link #trainingData(List<Dataset>)}.
         * 
         * @param trainingData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.Dataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingData(java.util.Collection<Dataset>)
         */
        Builder trainingData(Consumer<Dataset.Builder>... trainingData);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);

        /**
         * <p>
         * The most recent time at which the training dataset was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the training dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private String description;

        private String name;

        private String roleArn;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<Dataset> trainingData = DefaultSdkAutoConstructList.getInstance();

        private String trainingDatasetArn;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainingDatasetResponse model) {
            super(model);
            createTime(model.createTime);
            description(model.description);
            name(model.name);
            roleArn(model.roleArn);
            status(model.status);
            tags(model.tags);
            trainingData(model.trainingData);
            trainingDatasetArn(model.trainingDatasetArn);
            updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingDatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<Dataset.Builder> getTrainingData() {
            List<Dataset.Builder> result = DatasetListCopier.copyToBuilder(this.trainingData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingData(Collection<Dataset.BuilderImpl> trainingData) {
            this.trainingData = DatasetListCopier.copyFromBuilder(trainingData);
        }

        @Override
        public final Builder trainingData(Collection<Dataset> trainingData) {
            this.trainingData = DatasetListCopier.copy(trainingData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Dataset... trainingData) {
            trainingData(Arrays.asList(trainingData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Consumer<Dataset.Builder>... trainingData) {
            trainingData(Stream.of(trainingData).map(c -> Dataset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetTrainingDatasetResponse build() {
            return new GetTrainingDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
