/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The size of the generated audience. Must match one of the sizes in the configured audience model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceSize implements SdkPojo, Serializable, ToCopyableBuilder<AudienceSize.Builder, AudienceSize> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AudienceSize::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("value")
            .getter(getter(AudienceSize::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer value;

    private AudienceSize(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * Whether the audience size is defined in absolute terms or as a percentage. You can use the <code>ABSOLUTE</code>
     * <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the
     * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AudienceSizeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the audience size is defined in absolute terms or as a percentage. You can use the
     *         <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers
     *         in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the
     *         range 1-100 percent.
     * @see AudienceSizeType
     */
    public final AudienceSizeType type() {
        return AudienceSizeType.fromValue(type);
    }

    /**
     * <p>
     * Whether the audience size is defined in absolute terms or as a percentage. You can use the <code>ABSOLUTE</code>
     * <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the output. You can use the
     * <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AudienceSizeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the audience size is defined in absolute terms or as a percentage. You can use the
     *         <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers
     *         in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the
     *         range 1-100 percent.
     * @see AudienceSizeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specify an audience size value.
     * </p>
     * 
     * @return Specify an audience size value.
     */
    public final Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceSize)) {
            return false;
        }
        AudienceSize other = (AudienceSize) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceSize").add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceSize, T> g) {
        return obj -> g.apply((AudienceSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceSize> {
        /**
         * <p>
         * Whether the audience size is defined in absolute terms or as a percentage. You can use the
         * <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in
         * the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100
         * percent.
         * </p>
         * 
         * @param type
         *        Whether the audience size is defined in absolute terms or as a percentage. You can use the
         *        <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of
         *        identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure
         *        sizes in the range 1-100 percent.
         * @see AudienceSizeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceSizeType
         */
        Builder type(String type);

        /**
         * <p>
         * Whether the audience size is defined in absolute terms or as a percentage. You can use the
         * <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in
         * the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100
         * percent.
         * </p>
         * 
         * @param type
         *        Whether the audience size is defined in absolute terms or as a percentage. You can use the
         *        <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of
         *        identifiers in the output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure
         *        sizes in the range 1-100 percent.
         * @see AudienceSizeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceSizeType
         */
        Builder type(AudienceSizeType type);

        /**
         * <p>
         * Specify an audience size value.
         * </p>
         * 
         * @param value
         *        Specify an audience size value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceSize model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AudienceSizeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public AudienceSize build() {
            return new AudienceSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
