/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relevance score of a generated audience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelevanceMetric implements SdkPojo, Serializable, ToCopyableBuilder<RelevanceMetric.Builder, RelevanceMetric> {
    private static final SdkField<AudienceSize> AUDIENCE_SIZE_FIELD = SdkField.<AudienceSize> builder(MarshallingType.SDK_POJO)
            .memberName("audienceSize").getter(getter(RelevanceMetric::audienceSize)).setter(setter(Builder::audienceSize))
            .constructor(AudienceSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSize").build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(RelevanceMetric::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_SIZE_FIELD,
            SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudienceSize audienceSize;

    private final Double score;

    private RelevanceMetric(BuilderImpl builder) {
        this.audienceSize = builder.audienceSize;
        this.score = builder.score;
    }

    /**
     * Returns the value of the AudienceSize property for this object.
     * 
     * @return The value of the AudienceSize property for this object.
     */
    public final AudienceSize audienceSize() {
        return audienceSize;
    }

    /**
     * <p>
     * The relevance score of the generated audience.
     * </p>
     * 
     * @return The relevance score of the generated audience.
     */
    public final Double score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audienceSize());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelevanceMetric)) {
            return false;
        }
        RelevanceMetric other = (RelevanceMetric) obj;
        return Objects.equals(audienceSize(), other.audienceSize()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelevanceMetric").add("AudienceSize", audienceSize()).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audienceSize":
            return Optional.ofNullable(clazz.cast(audienceSize()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelevanceMetric, T> g) {
        return obj -> g.apply((RelevanceMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelevanceMetric> {
        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * @param audienceSize
         *        The new value for the AudienceSize property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSize(AudienceSize audienceSize);

        /**
         * Sets the value of the AudienceSize property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudienceSize.Builder} avoiding the need
         * to create one manually via {@link AudienceSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceSize.Builder#build()} is called immediately and its
         * result is passed to {@link #audienceSize(AudienceSize)}.
         * 
         * @param audienceSize
         *        a consumer that will call methods on {@link AudienceSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceSize(AudienceSize)
         */
        default Builder audienceSize(Consumer<AudienceSize.Builder> audienceSize) {
            return audienceSize(AudienceSize.builder().applyMutation(audienceSize).build());
        }

        /**
         * <p>
         * The relevance score of the generated audience.
         * </p>
         * 
         * @param score
         *        The relevance score of the generated audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);
    }

    static final class BuilderImpl implements Builder {
        private AudienceSize audienceSize;

        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(RelevanceMetric model) {
            audienceSize(model.audienceSize);
            score(model.score);
        }

        public final AudienceSize.Builder getAudienceSize() {
            return audienceSize != null ? audienceSize.toBuilder() : null;
        }

        public final void setAudienceSize(AudienceSize.BuilderImpl audienceSize) {
            this.audienceSize = audienceSize != null ? audienceSize.build() : null;
        }

        @Override
        public final Builder audienceSize(AudienceSize audienceSize) {
            this.audienceSize = audienceSize;
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        @Override
        public RelevanceMetric build() {
            return new RelevanceMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
