/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher;
import software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher;

/**
 * Service client for accessing AWS Clean Rooms ML asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>Amazon Web Services Clean Rooms ML API Reference</i>.
 * </p>
 * <p>
 * Amazon Web Services Clean Rooms ML provides a privacy-enhancing method for two parties to identify similar users in
 * their data without the need to share their data with each other. The first party brings the training data to Clean
 * Rooms so that they can create and configure an audience model (lookalike model) and associate it with a
 * collaboration. The second party then brings their seed data to Clean Rooms and generates an audience (lookalike
 * segment) that resembles the training data.
 * </p>
 * <p>
 * To learn more about Amazon Web Services Clean Rooms ML concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/machine-learning.html">Clean Rooms User Guide</a>.
 * </p>
 * <p>
 * To learn more about SQL commands, functions, and conditions supported in Clean Rooms, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/sql-reference/sql-reference.html">Clean Rooms SQL Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CleanRoomsMlAsyncClient extends AwsClient {
    String SERVICE_NAME = "cleanrooms-ml";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cleanrooms-ml";

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     *
     * @param createAudienceModelRequest
     * @return A Java Future containing the result of the CreateAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAudienceModelResponse> createAudienceModel(
            CreateAudienceModelRequest createAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create an audience model. An audience model is a machine learning model that
     * Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the
     * audience model. The audience model can be used in multiple calls to the <a>StartAudienceGenerationJob</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAudienceModelRequest#builder()}
     * </p>
     *
     * @param createAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAudienceModelResponse> createAudienceModel(
            Consumer<CreateAudienceModelRequest.Builder> createAudienceModelRequest) {
        return createAudienceModel(CreateAudienceModelRequest.builder().applyMutation(createAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the CreateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredAudienceModelResponse> createConfiguredAudienceModel(
            CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param createConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfiguredAudienceModelResponse> createConfiguredAudienceModel(
            Consumer<CreateConfiguredAudienceModelRequest.Builder> createConfiguredAudienceModelRequest) {
        return createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest.builder()
                .applyMutation(createConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     *
     * @param createTrainingDatasetRequest
     * @return A Java Future containing the result of the CreateTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainingDatasetResponse> createTrainingDataset(
            CreateTrainingDatasetRequest createTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the information necessary to create a training dataset, or seed audience. In Clean Rooms ML, the
     * <code>TrainingDataset</code> is metadata that points to a Glue table, which is read only during
     * <code>AudienceModel</code> creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param createTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.CreateTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrainingDatasetResponse> createTrainingDataset(
            Consumer<CreateTrainingDatasetRequest.Builder> createTrainingDatasetRequest) {
        return createTrainingDataset(CreateTrainingDatasetRequest.builder().applyMutation(createTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     * @return A Java Future containing the result of the DeleteAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceGenerationJobResponse> deleteAudienceGenerationJob(
            DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified audience generation job, and removes all data associated with the job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceGenerationJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param deleteAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceGenerationJobResponse> deleteAudienceGenerationJob(
            Consumer<DeleteAudienceGenerationJobRequest.Builder> deleteAudienceGenerationJobRequest) {
        return deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest.builder()
                .applyMutation(deleteAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     *
     * @param deleteAudienceModelRequest
     * @return A Java Future containing the result of the DeleteAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceModelResponse> deleteAudienceModel(
            DeleteAudienceModelRequest deleteAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an audience model that you want to delete. You can't delete an audience model if there are any
     * configured audience models that depend on the audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAudienceModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAudienceModelResponse> deleteAudienceModel(
            Consumer<DeleteAudienceModelRequest.Builder> deleteAudienceModelRequest) {
        return deleteAudienceModel(DeleteAudienceModelRequest.builder().applyMutation(deleteAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelResponse> deleteConfiguredAudienceModel(
            DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model. You can't delete a configured audience model if there are any
     * lookalike models that use the configured audience model. If you delete a configured audience model, it will be
     * removed from any collaborations that it is associated to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelResponse> deleteConfiguredAudienceModel(
            Consumer<DeleteConfiguredAudienceModelRequest.Builder> deleteConfiguredAudienceModelRequest) {
        return deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> deleteConfiguredAudienceModelPolicy(
            DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteConfiguredAudienceModelPolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfiguredAudienceModelPolicyResponse> deleteConfiguredAudienceModelPolicy(
            Consumer<DeleteConfiguredAudienceModelPolicyRequest.Builder> deleteConfiguredAudienceModelPolicyRequest) {
        return deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(deleteConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     * @return A Java Future containing the result of the DeleteTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingDatasetResponse> deleteTrainingDataset(
            DeleteTrainingDatasetRequest deleteTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any
     * audience models that depend on the training dataset. In Clean Rooms ML, the <code>TrainingDataset</code> is
     * metadata that points to a Glue table, which is read only during <code>AudienceModel</code> creation. This action
     * deletes the metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param deleteTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.DeleteTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingDatasetResponse> deleteTrainingDataset(
            Consumer<DeleteTrainingDatasetRequest.Builder> deleteTrainingDatasetRequest) {
        return deleteTrainingDataset(DeleteTrainingDatasetRequest.builder().applyMutation(deleteTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     * @return A Java Future containing the result of the GetAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAudienceGenerationJobResponse> getAudienceGenerationJob(
            GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param getAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAudienceGenerationJobResponse> getAudienceGenerationJob(
            Consumer<GetAudienceGenerationJobRequest.Builder> getAudienceGenerationJobRequest) {
        return getAudienceGenerationJob(GetAudienceGenerationJobRequest.builder().applyMutation(getAudienceGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     *
     * @param getAudienceModelRequest
     * @return A Java Future containing the result of the GetAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAudienceModelResponse> getAudienceModel(GetAudienceModelRequest getAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an audience model
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAudienceModelRequest.Builder} avoiding the need
     * to create one manually via {@link GetAudienceModelRequest#builder()}
     * </p>
     *
     * @param getAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAudienceModelResponse> getAudienceModel(
            Consumer<GetAudienceModelRequest.Builder> getAudienceModelRequest) {
        return getAudienceModel(GetAudienceModelRequest.builder().applyMutation(getAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelResponse> getConfiguredAudienceModel(
            GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelRequest.Builder} avoiding
     * the need to create one manually via {@link GetConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConfiguredAudienceModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelResponse> getConfiguredAudienceModel(
            Consumer<GetConfiguredAudienceModelRequest.Builder> getConfiguredAudienceModelRequest) {
        return getConfiguredAudienceModel(GetConfiguredAudienceModelRequest.builder()
                .applyMutation(getConfiguredAudienceModelRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the GetConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelPolicyResponse> getConfiguredAudienceModelPolicy(
            GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured audience model policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param getConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfiguredAudienceModelPolicyResponse> getConfiguredAudienceModelPolicy(
            Consumer<GetConfiguredAudienceModelPolicyRequest.Builder> getConfiguredAudienceModelPolicyRequest) {
        return getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(getConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     *
     * @param getTrainingDatasetRequest
     * @return A Java Future containing the result of the GetTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainingDatasetResponse> getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training dataset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrainingDatasetRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrainingDatasetRequest#builder()}
     * </p>
     *
     * @param getTrainingDatasetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrainingDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.GetTrainingDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrainingDatasetResponse> getTrainingDataset(
            Consumer<GetTrainingDatasetRequest.Builder> getTrainingDatasetRequest) {
        return getTrainingDataset(GetTrainingDatasetRequest.builder().applyMutation(getTrainingDatasetRequest).build());
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A Java Future containing the result of the ListAudienceExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceExportJobsResponse> listAudienceExportJobs(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAudienceExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceExportJobsResponse> listAudienceExportJobs(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) {
        return listAudienceExportJobs(ListAudienceExportJobsRequest.builder().applyMutation(listAudienceExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsPublisher listAudienceExportJobsPaginator(
            ListAudienceExportJobsRequest listAudienceExportJobsRequest) {
        return new ListAudienceExportJobsPublisher(this, listAudienceExportJobsRequest);
    }

    /**
     * <p>
     * Returns a list of the audience export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceExportJobsPublisher publisher = client.listAudienceExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceExportJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceExportJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceExportJobsPublisher listAudienceExportJobsPaginator(
            Consumer<ListAudienceExportJobsRequest.Builder> listAudienceExportJobsRequest) {
        return listAudienceExportJobsPaginator(ListAudienceExportJobsRequest.builder()
                .applyMutation(listAudienceExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A Java Future containing the result of the ListAudienceGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceGenerationJobsResponse> listAudienceGenerationJobs(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAudienceGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceGenerationJobsResponse> listAudienceGenerationJobs(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) {
        return listAudienceGenerationJobs(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsPublisher listAudienceGenerationJobsPaginator(
            ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) {
        return new ListAudienceGenerationJobsPublisher(this, listAudienceGenerationJobsRequest);
    }

    /**
     * <p>
     * Returns a list of audience generation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceGenerationJobsPublisher publisher = client.listAudienceGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceGenerationJobs(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAudienceGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listAudienceGenerationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceGenerationJobsPublisher listAudienceGenerationJobsPaginator(
            Consumer<ListAudienceGenerationJobsRequest.Builder> listAudienceGenerationJobsRequest) {
        return listAudienceGenerationJobsPaginator(ListAudienceGenerationJobsRequest.builder()
                .applyMutation(listAudienceGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A Java Future containing the result of the ListAudienceModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceModelsResponse> listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAudienceModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAudienceModelsResponse> listAudienceModels(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) {
        return listAudienceModels(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAudienceModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsPublisher listAudienceModelsPaginator(ListAudienceModelsRequest listAudienceModelsRequest) {
        return new ListAudienceModelsPublisher(this, listAudienceModelsRequest);
    }

    /**
     * <p>
     * Returns a list of audience models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListAudienceModelsPublisher publisher = client.listAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAudienceModelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAudienceModelsPublisher listAudienceModelsPaginator(
            Consumer<ListAudienceModelsRequest.Builder> listAudienceModelsRequest) {
        return listAudienceModelsPaginator(ListAudienceModelsRequest.builder().applyMutation(listAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A Java Future containing the result of the ListConfiguredAudienceModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredAudienceModelsResponse> listConfiguredAudienceModels(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListConfiguredAudienceModels operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfiguredAudienceModelsResponse> listConfiguredAudienceModels(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest) {
        return listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsPublisher listConfiguredAudienceModelsPaginator(
            ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) {
        return new ListConfiguredAudienceModelsPublisher(this, listConfiguredAudienceModelsRequest);
    }

    /**
     * <p>
     * Returns a list of the configured audience models.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListConfiguredAudienceModelsPublisher publisher = client.listConfiguredAudienceModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredAudienceModels(software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredAudienceModelsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredAudienceModelsRequest#builder()}
     * </p>
     *
     * @param listConfiguredAudienceModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListConfiguredAudienceModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredAudienceModelsPublisher listConfiguredAudienceModelsPaginator(
            Consumer<ListConfiguredAudienceModelsRequest.Builder> listConfiguredAudienceModelsRequest) {
        return listConfiguredAudienceModelsPaginator(ListConfiguredAudienceModelsRequest.builder()
                .applyMutation(listConfiguredAudienceModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a provided resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A Java Future containing the result of the ListTrainingDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainingDatasetsResponse> listTrainingDatasets(
            ListTrainingDatasetsRequest listTrainingDatasetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrainingDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrainingDatasetsResponse> listTrainingDatasets(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) {
        return listTrainingDatasets(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrainingDatasetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsPublisher listTrainingDatasetsPaginator(ListTrainingDatasetsRequest listTrainingDatasetsRequest) {
        return new ListTrainingDatasetsPublisher(this, listTrainingDatasetsRequest);
    }

    /**
     * <p>
     * Returns a list of training datasets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanroomsml.paginators.ListTrainingDatasetsPublisher publisher = client.listTrainingDatasetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrainingDatasets(software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrainingDatasetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTrainingDatasetsRequest#builder()}
     * </p>
     *
     * @param listTrainingDatasetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.ListTrainingDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrainingDatasetsPublisher listTrainingDatasetsPaginator(
            Consumer<ListTrainingDatasetsRequest.Builder> listTrainingDatasetsRequest) {
        return listTrainingDatasetsPaginator(ListTrainingDatasetsRequest.builder().applyMutation(listTrainingDatasetsRequest)
                .build());
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     * @return A Java Future containing the result of the PutConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfiguredAudienceModelPolicyResponse> putConfiguredAudienceModelPolicy(
            PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create or update the resource policy for a configured audience model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfiguredAudienceModelPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfiguredAudienceModelPolicyRequest#builder()}
     * </p>
     *
     * @param putConfiguredAudienceModelPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutConfiguredAudienceModelPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.PutConfiguredAudienceModelPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfiguredAudienceModelPolicyResponse> putConfiguredAudienceModelPolicy(
            Consumer<PutConfiguredAudienceModelPolicyRequest.Builder> putConfiguredAudienceModelPolicyRequest) {
        return putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest.builder()
                .applyMutation(putConfiguredAudienceModelPolicyRequest).build());
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     *
     * @param startAudienceExportJobRequest
     * @return A Java Future containing the result of the StartAudienceExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceExportJobResponse> startAudienceExportJob(
            StartAudienceExportJobRequest startAudienceExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Export an audience of a specified size after you have generated an audience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartAudienceExportJobRequest#builder()}
     * </p>
     *
     * @param startAudienceExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartAudienceExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceExportJobResponse> startAudienceExportJob(
            Consumer<StartAudienceExportJobRequest.Builder> startAudienceExportJobRequest) {
        return startAudienceExportJob(StartAudienceExportJobRequest.builder().applyMutation(startAudienceExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     * @return A Java Future containing the result of the StartAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceGenerationJobResponse> startAudienceGenerationJob(
            StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information necessary to start the audience generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAudienceGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAudienceGenerationJobRequest#builder()}
     * </p>
     *
     * @param startAudienceGenerationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAudienceGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.StartAudienceGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAudienceGenerationJobResponse> startAudienceGenerationJob(
            Consumer<StartAudienceGenerationJobRequest.Builder> startAudienceGenerationJobRequest) {
        return startAudienceGenerationJob(StartAudienceGenerationJobRequest.builder()
                .applyMutation(startAudienceGenerationJobRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfiguredAudienceModelResponse> updateConfiguredAudienceModel(
            UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the information necessary to update a configured audience model. Updates that impact audience generation
     * jobs take effect when a new job starts, but do not impact currently running jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredAudienceModelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredAudienceModelRequest#builder()}
     * </p>
     *
     * @param updateConfiguredAudienceModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateConfiguredAudienceModel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A resource with that name already exists in this region.</li>
     *         <li>ValidationException The request parameters for this request are incorrect.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The resource you are requesting does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CleanRoomsMlException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CleanRoomsMlAsyncClient.UpdateConfiguredAudienceModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfiguredAudienceModelResponse> updateConfiguredAudienceModel(
            Consumer<UpdateConfiguredAudienceModelRequest.Builder> updateConfiguredAudienceModelRequest) {
        return updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest.builder()
                .applyMutation(updateConfiguredAudienceModelRequest).build());
    }

    @Override
    default CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CleanRoomsMlAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CleanRoomsMlAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CleanRoomsMlAsyncClient}.
     */
    static CleanRoomsMlAsyncClientBuilder builder() {
        return new DefaultCleanRoomsMlAsyncClientBuilder();
    }
}
