/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information necessary for the configure audience model output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredAudienceModelOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredAudienceModelOutputConfig.Builder, ConfiguredAudienceModelOutputConfig> {
    private static final SdkField<AudienceDestination> DESTINATION_FIELD = SdkField
            .<AudienceDestination> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(ConfiguredAudienceModelOutputConfig::destination)).setter(setter(Builder::destination))
            .constructor(AudienceDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ConfiguredAudienceModelOutputConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudienceDestination destination;

    private final String roleArn;

    private ConfiguredAudienceModelOutputConfig(BuilderImpl builder) {
        this.destination = builder.destination;
        this.roleArn = builder.roleArn;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final AudienceDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The ARN of the IAM role that can write the Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN of the IAM role that can write the Amazon S3 bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredAudienceModelOutputConfig)) {
            return false;
        }
        ConfiguredAudienceModelOutputConfig other = (ConfiguredAudienceModelOutputConfig) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredAudienceModelOutputConfig").add("Destination", destination())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredAudienceModelOutputConfig, T> g) {
        return obj -> g.apply((ConfiguredAudienceModelOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredAudienceModelOutputConfig> {
        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(AudienceDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AudienceDestination.Builder} avoiding the
         * need to create one manually via {@link AudienceDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #destination(AudienceDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link AudienceDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(AudienceDestination)
         */
        default Builder destination(Consumer<AudienceDestination.Builder> destination) {
            return destination(AudienceDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that can write the Amazon S3 bucket.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that can write the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private AudienceDestination destination;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredAudienceModelOutputConfig model) {
            destination(model.destination);
            roleArn(model.roleArn);
        }

        public final AudienceDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(AudienceDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(AudienceDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public ConfiguredAudienceModelOutputConfig build() {
            return new ConfiguredAudienceModelOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
