/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Amazon S3 bucket where the training data for the configured audience is stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceGenerationJobDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceGenerationJobDataSource.Builder, AudienceGenerationJobDataSource> {
    private static final SdkField<S3ConfigMap> DATA_SOURCE_FIELD = SdkField.<S3ConfigMap> builder(MarshallingType.SDK_POJO)
            .memberName("dataSource").getter(getter(AudienceGenerationJobDataSource::dataSource))
            .setter(setter(Builder::dataSource)).constructor(S3ConfigMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AudienceGenerationJobDataSource::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ConfigMap dataSource;

    private final String roleArn;

    private AudienceGenerationJobDataSource(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the training data for the configured audience is stored.
     * </p>
     * 
     * @return The Amazon S3 bucket where the training data for the configured audience is stored.
     */
    public final S3ConfigMap dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The ARN of the IAM role that can read the Amazon S3 bucket where the training data is stored.
     * </p>
     * 
     * @return The ARN of the IAM role that can read the Amazon S3 bucket where the training data is stored.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceGenerationJobDataSource)) {
            return false;
        }
        AudienceGenerationJobDataSource other = (AudienceGenerationJobDataSource) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceGenerationJobDataSource").add("DataSource", dataSource()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceGenerationJobDataSource, T> g) {
        return obj -> g.apply((AudienceGenerationJobDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceGenerationJobDataSource> {
        /**
         * <p>
         * The Amazon S3 bucket where the training data for the configured audience is stored.
         * </p>
         * 
         * @param dataSource
         *        The Amazon S3 bucket where the training data for the configured audience is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(S3ConfigMap dataSource);

        /**
         * <p>
         * The Amazon S3 bucket where the training data for the configured audience is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ConfigMap.Builder} avoiding the need to
         * create one manually via {@link S3ConfigMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ConfigMap.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(S3ConfigMap)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link S3ConfigMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(S3ConfigMap)
         */
        default Builder dataSource(Consumer<S3ConfigMap.Builder> dataSource) {
            return dataSource(S3ConfigMap.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that can read the Amazon S3 bucket where the training data is stored.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that can read the Amazon S3 bucket where the training data is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private S3ConfigMap dataSource;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceGenerationJobDataSource model) {
            dataSource(model.dataSource);
            roleArn(model.roleArn);
        }

        public final S3ConfigMap.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(S3ConfigMap.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(S3ConfigMap dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AudienceGenerationJobDataSource build() {
            return new AudienceGenerationJobDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
