/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AudienceModelMetricsCopier {
    static List<AudienceModelMetric> copy(Collection<? extends AudienceModelMetric> audienceModelMetricsParam) {
        List<AudienceModelMetric> list;
        if (audienceModelMetricsParam == null || audienceModelMetricsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AudienceModelMetric> modifiableList = new ArrayList<>();
            audienceModelMetricsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AudienceModelMetric> copyFromBuilder(Collection<? extends AudienceModelMetric.Builder> audienceModelMetricsParam) {
        List<AudienceModelMetric> list;
        if (audienceModelMetricsParam == null || audienceModelMetricsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AudienceModelMetric> modifiableList = new ArrayList<>();
            audienceModelMetricsParam.forEach(entry -> {
                AudienceModelMetric member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AudienceModelMetric.Builder> copyToBuilder(Collection<? extends AudienceModelMetric> audienceModelMetricsParam) {
        List<AudienceModelMetric.Builder> list;
        if (audienceModelMetricsParam == null || audienceModelMetricsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AudienceModelMetric.Builder> modifiableList = new ArrayList<>();
            audienceModelMetricsParam.forEach(entry -> {
                AudienceModelMetric.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
