/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configure the list of audience output sizes that can be created. A request to <a>StartAudienceGenerationJob</a> that
 * uses this configured audience model must have an <code>audienceSize</code> selected from this list. You can use the
 * <code>ABSOLUTE</code> <a>AudienceSize</a> to configure out audience sizes using the count of identifiers in the
 * output. You can use the <code>Percentage</code> <a>AudienceSize</a> to configure sizes in the range 1-100 percent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceSizeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AudienceSizeConfig.Builder, AudienceSizeConfig> {
    private static final SdkField<List<Integer>> AUDIENCE_SIZE_BINS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("audienceSizeBins")
            .getter(getter(AudienceSizeConfig::audienceSizeBins))
            .setter(setter(Builder::audienceSizeBins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeBins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIENCE_SIZE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceSizeType").getter(getter(AudienceSizeConfig::audienceSizeTypeAsString))
            .setter(setter(Builder::audienceSizeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_SIZE_BINS_FIELD,
            AUDIENCE_SIZE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> audienceSizeBins;

    private final String audienceSizeType;

    private AudienceSizeConfig(BuilderImpl builder) {
        this.audienceSizeBins = builder.audienceSizeBins;
        this.audienceSizeType = builder.audienceSizeType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudienceSizeBins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudienceSizeBins() {
        return audienceSizeBins != null && !(audienceSizeBins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the different audience output sizes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudienceSizeBins} method.
     * </p>
     * 
     * @return An array of the different audience output sizes.
     */
    public final List<Integer> audienceSizeBins() {
        return audienceSizeBins;
    }

    /**
     * <p>
     * Whether the audience output sizes are defined as an absolute number or a percentage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audienceSizeType}
     * will return {@link AudienceSizeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audienceSizeTypeAsString}.
     * </p>
     * 
     * @return Whether the audience output sizes are defined as an absolute number or a percentage.
     * @see AudienceSizeType
     */
    public final AudienceSizeType audienceSizeType() {
        return AudienceSizeType.fromValue(audienceSizeType);
    }

    /**
     * <p>
     * Whether the audience output sizes are defined as an absolute number or a percentage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audienceSizeType}
     * will return {@link AudienceSizeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audienceSizeTypeAsString}.
     * </p>
     * 
     * @return Whether the audience output sizes are defined as an absolute number or a percentage.
     * @see AudienceSizeType
     */
    public final String audienceSizeTypeAsString() {
        return audienceSizeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudienceSizeBins() ? audienceSizeBins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(audienceSizeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceSizeConfig)) {
            return false;
        }
        AudienceSizeConfig other = (AudienceSizeConfig) obj;
        return hasAudienceSizeBins() == other.hasAudienceSizeBins()
                && Objects.equals(audienceSizeBins(), other.audienceSizeBins())
                && Objects.equals(audienceSizeTypeAsString(), other.audienceSizeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceSizeConfig").add("AudienceSizeBins", hasAudienceSizeBins() ? audienceSizeBins() : null)
                .add("AudienceSizeType", audienceSizeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audienceSizeBins":
            return Optional.ofNullable(clazz.cast(audienceSizeBins()));
        case "audienceSizeType":
            return Optional.ofNullable(clazz.cast(audienceSizeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceSizeConfig, T> g) {
        return obj -> g.apply((AudienceSizeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceSizeConfig> {
        /**
         * <p>
         * An array of the different audience output sizes.
         * </p>
         * 
         * @param audienceSizeBins
         *        An array of the different audience output sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSizeBins(Collection<Integer> audienceSizeBins);

        /**
         * <p>
         * An array of the different audience output sizes.
         * </p>
         * 
         * @param audienceSizeBins
         *        An array of the different audience output sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceSizeBins(Integer... audienceSizeBins);

        /**
         * <p>
         * Whether the audience output sizes are defined as an absolute number or a percentage.
         * </p>
         * 
         * @param audienceSizeType
         *        Whether the audience output sizes are defined as an absolute number or a percentage.
         * @see AudienceSizeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceSizeType
         */
        Builder audienceSizeType(String audienceSizeType);

        /**
         * <p>
         * Whether the audience output sizes are defined as an absolute number or a percentage.
         * </p>
         * 
         * @param audienceSizeType
         *        Whether the audience output sizes are defined as an absolute number or a percentage.
         * @see AudienceSizeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceSizeType
         */
        Builder audienceSizeType(AudienceSizeType audienceSizeType);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> audienceSizeBins = DefaultSdkAutoConstructList.getInstance();

        private String audienceSizeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceSizeConfig model) {
            audienceSizeBins(model.audienceSizeBins);
            audienceSizeType(model.audienceSizeType);
        }

        public final Collection<Integer> getAudienceSizeBins() {
            if (audienceSizeBins instanceof SdkAutoConstructList) {
                return null;
            }
            return audienceSizeBins;
        }

        public final void setAudienceSizeBins(Collection<Integer> audienceSizeBins) {
            this.audienceSizeBins = AudienceSizeBinsCopier.copy(audienceSizeBins);
        }

        @Override
        public final Builder audienceSizeBins(Collection<Integer> audienceSizeBins) {
            this.audienceSizeBins = AudienceSizeBinsCopier.copy(audienceSizeBins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceSizeBins(Integer... audienceSizeBins) {
            audienceSizeBins(Arrays.asList(audienceSizeBins));
            return this;
        }

        public final String getAudienceSizeType() {
            return audienceSizeType;
        }

        public final void setAudienceSizeType(String audienceSizeType) {
            this.audienceSizeType = audienceSizeType;
        }

        @Override
        public final Builder audienceSizeType(String audienceSizeType) {
            this.audienceSizeType = audienceSizeType;
            return this;
        }

        @Override
        public final Builder audienceSizeType(AudienceSizeType audienceSizeType) {
            this.audienceSizeType(audienceSizeType == null ? null : audienceSizeType.toString());
            return this;
        }

        @Override
        public AudienceSizeConfig build() {
            return new AudienceSizeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
