/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainingDatasetResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<CreateTrainingDatasetResponse.Builder, CreateTrainingDatasetResponse> {
    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDatasetArn").getter(getter(CreateTrainingDatasetResponse::trainingDatasetArn))
            .setter(setter(Builder::trainingDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_DATASET_ARN_FIELD));

    private final String trainingDatasetArn;

    private CreateTrainingDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.trainingDatasetArn = builder.trainingDatasetArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training dataset resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training dataset resource.
     */
    public final String trainingDatasetArn() {
        return trainingDatasetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingDatasetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingDatasetResponse)) {
            return false;
        }
        CreateTrainingDatasetResponse other = (CreateTrainingDatasetResponse) obj;
        return Objects.equals(trainingDatasetArn(), other.trainingDatasetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrainingDatasetResponse").add("TrainingDatasetArn", trainingDatasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainingDatasetArn":
            return Optional.ofNullable(clazz.cast(trainingDatasetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingDatasetResponse, T> g) {
        return obj -> g.apply((CreateTrainingDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrainingDatasetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training dataset resource.
         * </p>
         * 
         * @param trainingDatasetArn
         *        The Amazon Resource Name (ARN) of the training dataset resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDatasetArn(String trainingDatasetArn);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String trainingDatasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingDatasetResponse model) {
            super(model);
            trainingDatasetArn(model.trainingDatasetArn);
        }

        public final String getTrainingDatasetArn() {
            return trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        @Override
        public CreateTrainingDatasetResponse build() {
            return new CreateTrainingDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
